/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Returns Order Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturn extends VdmEntity<CustomerReturn>
{

    /**
     * Selector for all available fields of CustomerReturn.
     *
     */
    public final static CustomerReturnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Customer Return
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_RETURN = new CustomerReturnField<String>("CustomerReturn");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnType</b>
     * </p>
     *
     * @return Customer Return Type
     */
    @SerializedName( "CustomerReturnType" )
    @JsonProperty( "CustomerReturnType" )
    @Nullable
    @ODataField( odataName = "CustomerReturnType" )
    private String customerReturnType;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnType</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_RETURN_TYPE =
        new CustomerReturnField<String>("CustomerReturnType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SALES_ORGANIZATION =
        new CustomerReturnField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> DISTRIBUTION_CHANNEL =
        new CustomerReturnField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> ORGANIZATION_DIVISION =
        new CustomerReturnField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SALES_GROUP = new CustomerReturnField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SALES_OFFICE = new CustomerReturnField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SALES_DISTRICT = new CustomerReturnField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SOLD_TO_PARTY = new CustomerReturnField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static CustomerReturnField<LocalDateTime> CREATION_DATE =
        new CustomerReturnField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CREATED_BY_USER = new CustomerReturnField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static CustomerReturnField<LocalDateTime> LAST_CHANGE_DATE =
        new CustomerReturnField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SenderBusinessSystemName</b>
     * </p>
     *
     * @return External Business System ID
     */
    @SerializedName( "SenderBusinessSystemName" )
    @JsonProperty( "SenderBusinessSystemName" )
    @Nullable
    @ODataField( odataName = "SenderBusinessSystemName" )
    private String senderBusinessSystemName;
    /**
     * Use with available fluent helpers to apply the <b>SenderBusinessSystemName</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SENDER_BUSINESS_SYSTEM_NAME =
        new CustomerReturnField<String>("SenderBusinessSystemName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static CustomerReturnField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new CustomerReturnField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new CustomerReturnField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @return Customer Purchase Order Type
     */
    @SerializedName( "CustomerPurchaseOrderType" )
    @JsonProperty( "CustomerPurchaseOrderType" )
    @Nullable
    @ODataField( odataName = "CustomerPurchaseOrderType" )
    private String customerPurchaseOrderType;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderType</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_PURCHASE_ORDER_TYPE =
        new CustomerReturnField<String>("CustomerPurchaseOrderType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Customer Reference Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static CustomerReturnField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new CustomerReturnField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnDate</b>
     * </p>
     *
     * @return Document Date (Date Received/Sent)
     */
    @SerializedName( "CustomerReturnDate" )
    @JsonProperty( "CustomerReturnDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerReturnDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerReturnDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnDate</b> field to query operations.
     *
     */
    public final static CustomerReturnField<LocalDateTime> CUSTOMER_RETURN_DATE =
        new CustomerReturnField<LocalDateTime>("CustomerReturnDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value of the Sales Order in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static CustomerReturnField<BigDecimal> TOTAL_NET_AMOUNT =
        new CustomerReturnField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> TRANSACTION_CURRENCY =
        new CustomerReturnField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SD_DOCUMENT_REASON =
        new CustomerReturnField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static CustomerReturnField<LocalDateTime> PRICING_DATE =
        new CustomerReturnField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static CustomerReturnField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new CustomerReturnField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SHIPPING_TYPE = new CustomerReturnField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block in SD Document
     */
    @SerializedName( "HeaderBillingBlockReason" )
    @JsonProperty( "HeaderBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "HeaderBillingBlockReason" )
    private String headerBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>HeaderBillingBlockReason</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> HEADER_BILLING_BLOCK_REASON =
        new CustomerReturnField<String>("HeaderBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @return Delivery Block (Document Header)
     */
    @SerializedName( "DeliveryBlockReason" )
    @JsonProperty( "DeliveryBlockReason" )
    @Nullable
    @ODataField( odataName = "DeliveryBlockReason" )
    private String deliveryBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryBlockReason</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> DELIVERY_BLOCK_REASON =
        new CustomerReturnField<String>("DeliveryBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> INCOTERMS_CLASSIFICATION =
        new CustomerReturnField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> INCOTERMS_TRANSFER_LOCATION =
        new CustomerReturnField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> INCOTERMS_LOCATION1 =
        new CustomerReturnField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> INCOTERMS_LOCATION2 =
        new CustomerReturnField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> INCOTERMS_VERSION =
        new CustomerReturnField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_PAYMENT_TERMS =
        new CustomerReturnField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> PAYMENT_METHOD = new CustomerReturnField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @return Alternative Tax Classification
     */
    @SerializedName( "CustomerTaxClassification1" )
    @JsonProperty( "CustomerTaxClassification1" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification1" )
    private String customerTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification1</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION1 =
        new CustomerReturnField<String>("CustomerTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Customer
     */
    @SerializedName( "CustomerTaxClassification2" )
    @JsonProperty( "CustomerTaxClassification2" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification2" )
    private String customerTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification2</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION2 =
        new CustomerReturnField<String>("CustomerTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Customer
     */
    @SerializedName( "CustomerTaxClassification3" )
    @JsonProperty( "CustomerTaxClassification3" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification3" )
    private String customerTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification3</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION3 =
        new CustomerReturnField<String>("CustomerTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Customer
     */
    @SerializedName( "CustomerTaxClassification4" )
    @JsonProperty( "CustomerTaxClassification4" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification4" )
    private String customerTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification4</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION4 =
        new CustomerReturnField<String>("CustomerTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Customer
     */
    @SerializedName( "CustomerTaxClassification5" )
    @JsonProperty( "CustomerTaxClassification5" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification5" )
    private String customerTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification5</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION5 =
        new CustomerReturnField<String>("CustomerTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Customer
     */
    @SerializedName( "CustomerTaxClassification6" )
    @JsonProperty( "CustomerTaxClassification6" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification6" )
    private String customerTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification6</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION6 =
        new CustomerReturnField<String>("CustomerTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Customer
     */
    @SerializedName( "CustomerTaxClassification7" )
    @JsonProperty( "CustomerTaxClassification7" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification7" )
    private String customerTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification7</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION7 =
        new CustomerReturnField<String>("CustomerTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Customer
     */
    @SerializedName( "CustomerTaxClassification8" )
    @JsonProperty( "CustomerTaxClassification8" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification8" )
    private String customerTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification8</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION8 =
        new CustomerReturnField<String>("CustomerTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Customer
     */
    @SerializedName( "CustomerTaxClassification9" )
    @JsonProperty( "CustomerTaxClassification9" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification9" )
    private String customerTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification9</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_TAX_CLASSIFICATION9 =
        new CustomerReturnField<String>("CustomerTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @return Process Identification Number
     */
    @SerializedName( "RetsMgmtProcess" )
    @JsonProperty( "RetsMgmtProcess" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcess" )
    private String retsMgmtProcess;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcess</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> RETS_MGMT_PROCESS =
        new CustomerReturnField<String>("RetsMgmtProcess");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> REFERENCE_SD_DOCUMENT =
        new CustomerReturnField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Preceding SD Document
     */
    @SerializedName( "ReferenceSDDocumentCategory" )
    @JsonProperty( "ReferenceSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentCategory" )
    private String referenceSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentCategory</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> REFERENCE_SD_DOCUMENT_CATEGORY =
        new CustomerReturnField<String>("ReferenceSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "AccountingDocExternalReference" )
    @JsonProperty( "AccountingDocExternalReference" )
    @Nullable
    @ODataField( odataName = "AccountingDocExternalReference" )
    private String accountingDocExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocExternalReference</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> ACCOUNTING_DOC_EXTERNAL_REFERENCE =
        new CustomerReturnField<String>("AccountingDocExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> ASSIGNMENT_REFERENCE =
        new CustomerReturnField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnApprovalReason</b>
     * </p>
     *
     * @return Approval Request Reason ID
     */
    @SerializedName( "CustomerReturnApprovalReason" )
    @JsonProperty( "CustomerReturnApprovalReason" )
    @Nullable
    @ODataField( odataName = "CustomerReturnApprovalReason" )
    private String customerReturnApprovalReason;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnApprovalReason</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> CUSTOMER_RETURN_APPROVAL_REASON =
        new CustomerReturnField<String>("CustomerReturnApprovalReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocApprovalStatus</b>
     * </p>
     *
     * @return Document Approval Status
     */
    @SerializedName( "SalesDocApprovalStatus" )
    @JsonProperty( "SalesDocApprovalStatus" )
    @Nullable
    @ODataField( odataName = "SalesDocApprovalStatus" )
    private String salesDocApprovalStatus;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocApprovalStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> SALES_DOC_APPROVAL_STATUS =
        new CustomerReturnField<String>("SalesDocApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtLogProcgStatus</b>
     * </p>
     *
     * @return Logistical Processing Status of a Return
     */
    @SerializedName( "RetsMgmtLogProcgStatus" )
    @JsonProperty( "RetsMgmtLogProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtLogProcgStatus" )
    private String retsMgmtLogProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtLogProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> RETS_MGMT_LOG_PROCG_STATUS =
        new CustomerReturnField<String>("RetsMgmtLogProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtCompnProcgStatus</b>
     * </p>
     *
     * @return Status of Returns Refund Determination
     */
    @SerializedName( "RetsMgmtCompnProcgStatus" )
    @JsonProperty( "RetsMgmtCompnProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtCompnProcgStatus" )
    private String retsMgmtCompnProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtCompnProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> RETS_MGMT_COMPN_PROCG_STATUS =
        new CustomerReturnField<String>("RetsMgmtCompnProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessingStatus</b>
     * </p>
     *
     * @return Processing Status
     */
    @SerializedName( "RetsMgmtProcessingStatus" )
    @JsonProperty( "RetsMgmtProcessingStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcessingStatus" )
    private String retsMgmtProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcessingStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> RETS_MGMT_PROCESSING_STATUS =
        new CustomerReturnField<String>("RetsMgmtProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> OVERALL_SD_PROCESS_STATUS =
        new CustomerReturnField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @return Overall Status of Credit Checks
     */
    @SerializedName( "TotalCreditCheckStatus" )
    @JsonProperty( "TotalCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "TotalCreditCheckStatus" )
    private String totalCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> TOTAL_CREDIT_CHECK_STATUS =
        new CustomerReturnField<String>("TotalCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocumentRejectionSts</b>
     * </p>
     *
     * @return Rejection Status (All Items)
     */
    @SerializedName( "OverallSDDocumentRejectionSts" )
    @JsonProperty( "OverallSDDocumentRejectionSts" )
    @Nullable
    @ODataField( odataName = "OverallSDDocumentRejectionSts" )
    private String overallSDDocumentRejectionSts;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDDocumentRejectionSts</b> field to query operations.
     *
     */
    public final static CustomerReturnField<String> OVERALL_SD_DOCUMENT_REJECTION_STS =
        new CustomerReturnField<String>("OverallSDDocumentRejectionSts");
    /**
     * Navigation property <b>to_CustomerReturnOverviewStatus</b> for <b>CustomerReturn</b> to single
     * <b>CustomerReturnOverviewStatus</b>.
     *
     */
    @SerializedName( "to_CustomerReturnOverviewStatus" )
    @JsonProperty( "to_CustomerReturnOverviewStatus" )
    @ODataField( odataName = "to_CustomerReturnOverviewStatus" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturnOverviewStatus toCustomerReturnOverviewStatus;
    /**
     * Navigation property <b>to_Item</b> for <b>CustomerReturn</b> to multiple <b>CustomerReturnItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>CustomerReturn</b> to multiple <b>CustomerReturnPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>CustomerReturn</b> to multiple
     * <b>CustomerReturnPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnPrcgElmnt> toPricingElement;
    /**
     * Navigation property <b>to_RelatedObject</b> for <b>CustomerReturn</b> to multiple
     * <b>CustomerReturnRelatedObject</b>.
     *
     */
    @SerializedName( "to_RelatedObject" )
    @JsonProperty( "to_RelatedObject" )
    @ODataField( odataName = "to_RelatedObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnRelatedObject> toRelatedObject;
    /**
     * Navigation property <b>to_Text</b> for <b>CustomerReturn</b> to multiple <b>CustomerReturnText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturnOverviewStatus</b> navigation property to
     * query operations.
     *
     */
    public final static CustomerReturnOneToOneLink<CustomerReturnOverviewStatus> TO_CUSTOMER_RETURN_OVERVIEW_STATUS =
        new CustomerReturnOneToOneLink<CustomerReturnOverviewStatus>("to_CustomerReturnOverviewStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnLink<CustomerReturnItem> TO_ITEM =
        new CustomerReturnLink<CustomerReturnItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnLink<CustomerReturnPartner> TO_PARTNER =
        new CustomerReturnLink<CustomerReturnPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnLink<CustomerReturnPrcgElmnt> TO_PRICING_ELEMENT =
        new CustomerReturnLink<CustomerReturnPrcgElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_RelatedObject</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnLink<CustomerReturnRelatedObject> TO_RELATED_OBJECT =
        new CustomerReturnLink<CustomerReturnRelatedObject>("to_RelatedObject");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnLink<CustomerReturnText> TO_TEXT =
        new CustomerReturnLink<CustomerReturnText>("to_Text");

    @Nonnull
    @Override
    public Class<CustomerReturn> getType()
    {
        return CustomerReturn.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Customer Return
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnType</b>
     * </p>
     *
     * @param customerReturnType
     *            Customer Return Type
     */
    public void setCustomerReturnType( @Nullable final String customerReturnType )
    {
        rememberChangedField("CustomerReturnType", this.customerReturnType);
        this.customerReturnType = customerReturnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SenderBusinessSystemName</b>
     * </p>
     *
     * @param senderBusinessSystemName
     *            External Business System ID
     */
    public void setSenderBusinessSystemName( @Nullable final String senderBusinessSystemName )
    {
        rememberChangedField("SenderBusinessSystemName", this.senderBusinessSystemName);
        this.senderBusinessSystemName = senderBusinessSystemName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @param customerPurchaseOrderType
     *            Customer Purchase Order Type
     */
    public void setCustomerPurchaseOrderType( @Nullable final String customerPurchaseOrderType )
    {
        rememberChangedField("CustomerPurchaseOrderType", this.customerPurchaseOrderType);
        this.customerPurchaseOrderType = customerPurchaseOrderType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Customer Reference Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnDate</b>
     * </p>
     *
     * @param customerReturnDate
     *            Document Date (Date Received/Sent)
     */
    public void setCustomerReturnDate( @Nullable final LocalDateTime customerReturnDate )
    {
        rememberChangedField("CustomerReturnDate", this.customerReturnDate);
        this.customerReturnDate = customerReturnDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value of the Sales Order in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @param headerBillingBlockReason
     *            Billing Block in SD Document
     */
    public void setHeaderBillingBlockReason( @Nullable final String headerBillingBlockReason )
    {
        rememberChangedField("HeaderBillingBlockReason", this.headerBillingBlockReason);
        this.headerBillingBlockReason = headerBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @param deliveryBlockReason
     *            Delivery Block (Document Header)
     */
    public void setDeliveryBlockReason( @Nullable final String deliveryBlockReason )
    {
        rememberChangedField("DeliveryBlockReason", this.deliveryBlockReason);
        this.deliveryBlockReason = deliveryBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @param customerTaxClassification1
     *            Alternative Tax Classification
     */
    public void setCustomerTaxClassification1( @Nullable final String customerTaxClassification1 )
    {
        rememberChangedField("CustomerTaxClassification1", this.customerTaxClassification1);
        this.customerTaxClassification1 = customerTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @param customerTaxClassification2
     *            Tax Classification 2 for Customer
     */
    public void setCustomerTaxClassification2( @Nullable final String customerTaxClassification2 )
    {
        rememberChangedField("CustomerTaxClassification2", this.customerTaxClassification2);
        this.customerTaxClassification2 = customerTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @param customerTaxClassification3
     *            Tax Classification 3 for Customer
     */
    public void setCustomerTaxClassification3( @Nullable final String customerTaxClassification3 )
    {
        rememberChangedField("CustomerTaxClassification3", this.customerTaxClassification3);
        this.customerTaxClassification3 = customerTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @param customerTaxClassification4
     *            Tax Classification 4 for Customer
     */
    public void setCustomerTaxClassification4( @Nullable final String customerTaxClassification4 )
    {
        rememberChangedField("CustomerTaxClassification4", this.customerTaxClassification4);
        this.customerTaxClassification4 = customerTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @param customerTaxClassification5
     *            Tax Classification 5 for Customer
     */
    public void setCustomerTaxClassification5( @Nullable final String customerTaxClassification5 )
    {
        rememberChangedField("CustomerTaxClassification5", this.customerTaxClassification5);
        this.customerTaxClassification5 = customerTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @param customerTaxClassification6
     *            Tax Classification 6 for Customer
     */
    public void setCustomerTaxClassification6( @Nullable final String customerTaxClassification6 )
    {
        rememberChangedField("CustomerTaxClassification6", this.customerTaxClassification6);
        this.customerTaxClassification6 = customerTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @param customerTaxClassification7
     *            Tax Classification 7 for Customer
     */
    public void setCustomerTaxClassification7( @Nullable final String customerTaxClassification7 )
    {
        rememberChangedField("CustomerTaxClassification7", this.customerTaxClassification7);
        this.customerTaxClassification7 = customerTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @param customerTaxClassification8
     *            Tax Classification 8 for Customer
     */
    public void setCustomerTaxClassification8( @Nullable final String customerTaxClassification8 )
    {
        rememberChangedField("CustomerTaxClassification8", this.customerTaxClassification8);
        this.customerTaxClassification8 = customerTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @param customerTaxClassification9
     *            Tax Classification 9 for Customer
     */
    public void setCustomerTaxClassification9( @Nullable final String customerTaxClassification9 )
    {
        rememberChangedField("CustomerTaxClassification9", this.customerTaxClassification9);
        this.customerTaxClassification9 = customerTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @param retsMgmtProcess
     *            Process Identification Number
     */
    public void setRetsMgmtProcess( @Nullable final String retsMgmtProcess )
    {
        rememberChangedField("RetsMgmtProcess", this.retsMgmtProcess);
        this.retsMgmtProcess = retsMgmtProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @param referenceSDDocumentCategory
     *            Document Category of Preceding SD Document
     */
    public void setReferenceSDDocumentCategory( @Nullable final String referenceSDDocumentCategory )
    {
        rememberChangedField("ReferenceSDDocumentCategory", this.referenceSDDocumentCategory);
        this.referenceSDDocumentCategory = referenceSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @param accountingDocExternalReference
     *            Reference Document Number
     */
    public void setAccountingDocExternalReference( @Nullable final String accountingDocExternalReference )
    {
        rememberChangedField("AccountingDocExternalReference", this.accountingDocExternalReference);
        this.accountingDocExternalReference = accountingDocExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnApprovalReason</b>
     * </p>
     *
     * @param customerReturnApprovalReason
     *            Approval Request Reason ID
     */
    public void setCustomerReturnApprovalReason( @Nullable final String customerReturnApprovalReason )
    {
        rememberChangedField("CustomerReturnApprovalReason", this.customerReturnApprovalReason);
        this.customerReturnApprovalReason = customerReturnApprovalReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocApprovalStatus</b>
     * </p>
     *
     * @param salesDocApprovalStatus
     *            Document Approval Status
     */
    public void setSalesDocApprovalStatus( @Nullable final String salesDocApprovalStatus )
    {
        rememberChangedField("SalesDocApprovalStatus", this.salesDocApprovalStatus);
        this.salesDocApprovalStatus = salesDocApprovalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtLogProcgStatus</b>
     * </p>
     *
     * @param retsMgmtLogProcgStatus
     *            Logistical Processing Status of a Return
     */
    public void setRetsMgmtLogProcgStatus( @Nullable final String retsMgmtLogProcgStatus )
    {
        rememberChangedField("RetsMgmtLogProcgStatus", this.retsMgmtLogProcgStatus);
        this.retsMgmtLogProcgStatus = retsMgmtLogProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtCompnProcgStatus</b>
     * </p>
     *
     * @param retsMgmtCompnProcgStatus
     *            Status of Returns Refund Determination
     */
    public void setRetsMgmtCompnProcgStatus( @Nullable final String retsMgmtCompnProcgStatus )
    {
        rememberChangedField("RetsMgmtCompnProcgStatus", this.retsMgmtCompnProcgStatus);
        this.retsMgmtCompnProcgStatus = retsMgmtCompnProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessingStatus</b>
     * </p>
     *
     * @param retsMgmtProcessingStatus
     *            Processing Status
     */
    public void setRetsMgmtProcessingStatus( @Nullable final String retsMgmtProcessingStatus )
    {
        rememberChangedField("RetsMgmtProcessingStatus", this.retsMgmtProcessingStatus);
        this.retsMgmtProcessingStatus = retsMgmtProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @param totalCreditCheckStatus
     *            Overall Status of Credit Checks
     */
    public void setTotalCreditCheckStatus( @Nullable final String totalCreditCheckStatus )
    {
        rememberChangedField("TotalCreditCheckStatus", this.totalCreditCheckStatus);
        this.totalCreditCheckStatus = totalCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocumentRejectionSts</b>
     * </p>
     *
     * @param overallSDDocumentRejectionSts
     *            Rejection Status (All Items)
     */
    public void setOverallSDDocumentRejectionSts( @Nullable final String overallSDDocumentRejectionSts )
    {
        rememberChangedField("OverallSDDocumentRejectionSts", this.overallSDDocumentRejectionSts);
        this.overallSDDocumentRejectionSts = overallSDDocumentRejectionSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturn";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("CustomerReturnType", getCustomerReturnType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SoldToParty", getSoldToParty());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("SenderBusinessSystemName", getSenderBusinessSystemName());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderType", getCustomerPurchaseOrderType());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("CustomerReturnDate", getCustomerReturnDate());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("PricingDate", getPricingDate());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("ShippingType", getShippingType());
        values.put("HeaderBillingBlockReason", getHeaderBillingBlockReason());
        values.put("DeliveryBlockReason", getDeliveryBlockReason());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("CustomerTaxClassification1", getCustomerTaxClassification1());
        values.put("CustomerTaxClassification2", getCustomerTaxClassification2());
        values.put("CustomerTaxClassification3", getCustomerTaxClassification3());
        values.put("CustomerTaxClassification4", getCustomerTaxClassification4());
        values.put("CustomerTaxClassification5", getCustomerTaxClassification5());
        values.put("CustomerTaxClassification6", getCustomerTaxClassification6());
        values.put("CustomerTaxClassification7", getCustomerTaxClassification7());
        values.put("CustomerTaxClassification8", getCustomerTaxClassification8());
        values.put("CustomerTaxClassification9", getCustomerTaxClassification9());
        values.put("RetsMgmtProcess", getRetsMgmtProcess());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentCategory", getReferenceSDDocumentCategory());
        values.put("AccountingDocExternalReference", getAccountingDocExternalReference());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("CustomerReturnApprovalReason", getCustomerReturnApprovalReason());
        values.put("SalesDocApprovalStatus", getSalesDocApprovalStatus());
        values.put("RetsMgmtLogProcgStatus", getRetsMgmtLogProcgStatus());
        values.put("RetsMgmtCompnProcgStatus", getRetsMgmtCompnProcgStatus());
        values.put("RetsMgmtProcessingStatus", getRetsMgmtProcessingStatus());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("TotalCreditCheckStatus", getTotalCreditCheckStatus());
        values.put("OverallSDDocumentRejectionSts", getOverallSDDocumentRejectionSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnType") ) {
                final Object value = values.remove("CustomerReturnType");
                if( (value == null) || (!value.equals(getCustomerReturnType())) ) {
                    setCustomerReturnType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SenderBusinessSystemName") ) {
                final Object value = values.remove("SenderBusinessSystemName");
                if( (value == null) || (!value.equals(getSenderBusinessSystemName())) ) {
                    setSenderBusinessSystemName(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderType") ) {
                final Object value = values.remove("CustomerPurchaseOrderType");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderType())) ) {
                    setCustomerPurchaseOrderType(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustomerReturnDate") ) {
                final Object value = values.remove("CustomerReturnDate");
                if( (value == null) || (!value.equals(getCustomerReturnDate())) ) {
                    setCustomerReturnDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("HeaderBillingBlockReason") ) {
                final Object value = values.remove("HeaderBillingBlockReason");
                if( (value == null) || (!value.equals(getHeaderBillingBlockReason())) ) {
                    setHeaderBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("DeliveryBlockReason") ) {
                final Object value = values.remove("DeliveryBlockReason");
                if( (value == null) || (!value.equals(getDeliveryBlockReason())) ) {
                    setDeliveryBlockReason(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification1") ) {
                final Object value = values.remove("CustomerTaxClassification1");
                if( (value == null) || (!value.equals(getCustomerTaxClassification1())) ) {
                    setCustomerTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification2") ) {
                final Object value = values.remove("CustomerTaxClassification2");
                if( (value == null) || (!value.equals(getCustomerTaxClassification2())) ) {
                    setCustomerTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification3") ) {
                final Object value = values.remove("CustomerTaxClassification3");
                if( (value == null) || (!value.equals(getCustomerTaxClassification3())) ) {
                    setCustomerTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification4") ) {
                final Object value = values.remove("CustomerTaxClassification4");
                if( (value == null) || (!value.equals(getCustomerTaxClassification4())) ) {
                    setCustomerTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification5") ) {
                final Object value = values.remove("CustomerTaxClassification5");
                if( (value == null) || (!value.equals(getCustomerTaxClassification5())) ) {
                    setCustomerTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification6") ) {
                final Object value = values.remove("CustomerTaxClassification6");
                if( (value == null) || (!value.equals(getCustomerTaxClassification6())) ) {
                    setCustomerTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification7") ) {
                final Object value = values.remove("CustomerTaxClassification7");
                if( (value == null) || (!value.equals(getCustomerTaxClassification7())) ) {
                    setCustomerTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification8") ) {
                final Object value = values.remove("CustomerTaxClassification8");
                if( (value == null) || (!value.equals(getCustomerTaxClassification8())) ) {
                    setCustomerTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification9") ) {
                final Object value = values.remove("CustomerTaxClassification9");
                if( (value == null) || (!value.equals(getCustomerTaxClassification9())) ) {
                    setCustomerTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcess") ) {
                final Object value = values.remove("RetsMgmtProcess");
                if( (value == null) || (!value.equals(getRetsMgmtProcess())) ) {
                    setRetsMgmtProcess(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentCategory") ) {
                final Object value = values.remove("ReferenceSDDocumentCategory");
                if( (value == null) || (!value.equals(getReferenceSDDocumentCategory())) ) {
                    setReferenceSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("AccountingDocExternalReference") ) {
                final Object value = values.remove("AccountingDocExternalReference");
                if( (value == null) || (!value.equals(getAccountingDocExternalReference())) ) {
                    setAccountingDocExternalReference(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnApprovalReason") ) {
                final Object value = values.remove("CustomerReturnApprovalReason");
                if( (value == null) || (!value.equals(getCustomerReturnApprovalReason())) ) {
                    setCustomerReturnApprovalReason(((String) value));
                }
            }
            if( values.containsKey("SalesDocApprovalStatus") ) {
                final Object value = values.remove("SalesDocApprovalStatus");
                if( (value == null) || (!value.equals(getSalesDocApprovalStatus())) ) {
                    setSalesDocApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtLogProcgStatus") ) {
                final Object value = values.remove("RetsMgmtLogProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtLogProcgStatus())) ) {
                    setRetsMgmtLogProcgStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtCompnProcgStatus") ) {
                final Object value = values.remove("RetsMgmtCompnProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtCompnProcgStatus())) ) {
                    setRetsMgmtCompnProcgStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcessingStatus") ) {
                final Object value = values.remove("RetsMgmtProcessingStatus");
                if( (value == null) || (!value.equals(getRetsMgmtProcessingStatus())) ) {
                    setRetsMgmtProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("TotalCreditCheckStatus") ) {
                final Object value = values.remove("TotalCreditCheckStatus");
                if( (value == null) || (!value.equals(getTotalCreditCheckStatus())) ) {
                    setTotalCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDDocumentRejectionSts") ) {
                final Object value = values.remove("OverallSDDocumentRejectionSts");
                if( (value == null) || (!value.equals(getOverallSDDocumentRejectionSts())) ) {
                    setOverallSDDocumentRejectionSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturnOverviewStatus") ) {
                final Object value = (values).remove("to_CustomerReturnOverviewStatus");
                if( value instanceof Map ) {
                    if( toCustomerReturnOverviewStatus == null ) {
                        toCustomerReturnOverviewStatus = new CustomerReturnOverviewStatus();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturnOverviewStatus.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new CustomerReturnItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new CustomerReturnPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new CustomerReturnPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RelatedObject") ) {
                final Object value = (values).remove("to_RelatedObject");
                if( value instanceof Iterable ) {
                    if( toRelatedObject == null ) {
                        toRelatedObject = Lists.newArrayList();
                    } else {
                        toRelatedObject = Lists.newArrayList(toRelatedObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnRelatedObject entity;
                        if( toRelatedObject.size() > i ) {
                            entity = toRelatedObject.get(i);
                        } else {
                            entity = new CustomerReturnRelatedObject();
                            toRelatedObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new CustomerReturnText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerReturnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturnOverviewStatus != null ) {
            (values).put("to_CustomerReturnOverviewStatus", toCustomerReturnOverviewStatus);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toRelatedObject != null ) {
            (values).put("to_RelatedObject", toRelatedObject);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturnOverviewStatus</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CustomerReturnOverviewStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturnOverviewStatus</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnOverviewStatus fetchCustomerReturnOverviewStatus()
    {
        return fetchFieldAsSingle("to_CustomerReturnOverviewStatus", CustomerReturnOverviewStatus.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnOverviewStatus</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CustomerReturnOverviewStatus</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturnOverviewStatus</b> of a queried <b>CustomerReturn</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnOverviewStatus</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnOverviewStatus getCustomerReturnOverviewStatusOrFetch()
    {
        if( toCustomerReturnOverviewStatus == null ) {
            toCustomerReturnOverviewStatus = fetchCustomerReturnOverviewStatus();
        }
        return toCustomerReturnOverviewStatus;
    }

    /**
     * Retrieval of associated <b>CustomerReturnOverviewStatus</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CustomerReturnOverviewStatus</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturn</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturnOverviewStatus</b> is already loaded, the
     *         result will contain the <b>CustomerReturnOverviewStatus</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturnOverviewStatus> getCustomerReturnOverviewStatusIfPresent()
    {
        return Option.of(toCustomerReturnOverviewStatus);
    }

    /**
     * Overwrites the associated <b>CustomerReturnOverviewStatus</b> entity for the loaded navigation property
     * <b>to_CustomerReturnOverviewStatus</b>.
     *
     * @param value
     *            New <b>CustomerReturnOverviewStatus</b> entity.
     */
    public void setCustomerReturnOverviewStatus( final CustomerReturnOverviewStatus value )
    {
        toCustomerReturnOverviewStatus = value;
    }

    /**
     * Fetches the <b>CustomerReturnItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", CustomerReturnItem.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturn</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>CustomerReturnItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnItem</b> entities.
     */
    public void setItem( @Nonnull final List<CustomerReturnItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnItem</b> entities.
     */
    public void addItem( CustomerReturnItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", CustomerReturnPartner.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>CustomerReturnPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturn</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>CustomerReturnPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<CustomerReturnPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnPartner</b> entities.
     */
    public void addPartner( CustomerReturnPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnPrcgElmnt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", CustomerReturnPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>CustomerReturnPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturn</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>CustomerReturnPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<CustomerReturnPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnPrcgElmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnPrcgElmnt</b> entities.
     */
    public void addPricingElement( CustomerReturnPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnRelatedObject</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnRelatedObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnRelatedObject> fetchRelatedObject()
    {
        return fetchFieldAsList("to_RelatedObject", CustomerReturnRelatedObject.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnRelatedObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnRelatedObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnRelatedObject> getRelatedObjectOrFetch()
    {
        if( toRelatedObject == null ) {
            toRelatedObject = fetchRelatedObject();
        }
        return toRelatedObject;
    }

    /**
     * Retrieval of associated <b>CustomerReturnRelatedObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturn</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RelatedObject</b> is already loaded, the result will
     *         contain the <b>CustomerReturnRelatedObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnRelatedObject>> getRelatedObjectIfPresent()
    {
        return Option.of(toRelatedObject);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnRelatedObject</b> entities for the loaded navigation property
     * <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnRelatedObject</b> entities.
     */
    public void setRelatedObject( @Nonnull final List<CustomerReturnRelatedObject> value )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.clear();
        toRelatedObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnRelatedObject</b> entities. This corresponds to the
     * OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnRelatedObject</b> entities.
     */
    public void addRelatedObject( CustomerReturnRelatedObject... entity )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnText> fetchText()
    {
        return fetchFieldAsList("to_Text", CustomerReturnText.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>CustomerReturnText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturn</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>CustomerReturnText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnText</b> entities.
     */
    public void setText( @Nonnull final List<CustomerReturnText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CustomerReturn</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnText</b> entities.
     */
    public void addText( CustomerReturnText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturn instances.
     *
     */
    public final static class CustomerReturnBuilder
    {

        private CustomerReturnOverviewStatus toCustomerReturnOverviewStatus;
        private List<CustomerReturnItem> toItem = Lists.newArrayList();
        private List<CustomerReturnPartner> toPartner = Lists.newArrayList();
        private List<CustomerReturnPrcgElmnt> toPricingElement = Lists.newArrayList();
        private List<CustomerReturnRelatedObject> toRelatedObject = Lists.newArrayList();
        private List<CustomerReturnText> toText = Lists.newArrayList();

        private CustomerReturn.CustomerReturnBuilder toCustomerReturnOverviewStatus(
            final CustomerReturnOverviewStatus value )
        {
            toCustomerReturnOverviewStatus = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturnOverviewStatus</b> for <b>CustomerReturn</b> to single
         * <b>CustomerReturnOverviewStatus</b>.
         *
         * @param value
         *            The CustomerReturnOverviewStatus to build this CustomerReturn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturn.CustomerReturnBuilder customerReturnOverviewStatus(
            final CustomerReturnOverviewStatus value )
        {
            return toCustomerReturnOverviewStatus(value);
        }

        private CustomerReturn.CustomerReturnBuilder toItem( final List<CustomerReturnItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>CustomerReturn</b> to multiple <b>CustomerReturnItem</b>.
         *
         * @param value
         *            The CustomerReturnItems to build this CustomerReturn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturn.CustomerReturnBuilder item( CustomerReturnItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private CustomerReturn.CustomerReturnBuilder toPartner( final List<CustomerReturnPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>CustomerReturn</b> to multiple <b>CustomerReturnPartner</b>.
         *
         * @param value
         *            The CustomerReturnPartners to build this CustomerReturn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturn.CustomerReturnBuilder partner( CustomerReturnPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private CustomerReturn.CustomerReturnBuilder toPricingElement( final List<CustomerReturnPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>CustomerReturn</b> to multiple
         * <b>CustomerReturnPrcgElmnt</b>.
         *
         * @param value
         *            The CustomerReturnPrcgElmnts to build this CustomerReturn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturn.CustomerReturnBuilder pricingElement( CustomerReturnPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private CustomerReturn.CustomerReturnBuilder toRelatedObject( final List<CustomerReturnRelatedObject> value )
        {
            toRelatedObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RelatedObject</b> for <b>CustomerReturn</b> to multiple
         * <b>CustomerReturnRelatedObject</b>.
         *
         * @param value
         *            The CustomerReturnRelatedObjects to build this CustomerReturn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturn.CustomerReturnBuilder relatedObject( CustomerReturnRelatedObject... value )
        {
            return toRelatedObject(Lists.newArrayList(value));
        }

        private CustomerReturn.CustomerReturnBuilder toText( final List<CustomerReturnText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>CustomerReturn</b> to multiple <b>CustomerReturnText</b>.
         *
         * @param value
         *            The CustomerReturnTexts to build this CustomerReturn with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturn.CustomerReturnBuilder text( CustomerReturnText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
