/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Returns Order Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnItem extends VdmEntity<CustomerReturnItem>
{

    /**
     * Selector for all available fields of CustomerReturnItem.
     *
     */
    public final static CustomerReturnItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Customer Return
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUSTOMER_RETURN =
        new CustomerReturnItemField<String>("CustomerReturn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @return Customer Return Item
     */
    @Key
    @SerializedName( "CustomerReturnItem" )
    @JsonProperty( "CustomerReturnItem" )
    @Nullable
    @ODataField( odataName = "CustomerReturnItem" )
    private String customerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnItem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUSTOMER_RETURN_ITEM =
        new CustomerReturnItemField<String>("CustomerReturnItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> HIGHER_LEVEL_ITEM =
        new CustomerReturnItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "CustomerReturnItemCategory" )
    @JsonProperty( "CustomerReturnItemCategory" )
    @Nullable
    @ODataField( odataName = "CustomerReturnItemCategory" )
    private String customerReturnItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnItemCategory</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUSTOMER_RETURN_ITEM_CATEGORY =
        new CustomerReturnItemField<String>("CustomerReturnItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "CustomerReturnItemText" )
    @JsonProperty( "CustomerReturnItemText" )
    @Nullable
    @ODataField( odataName = "CustomerReturnItemText" )
    private String customerReturnItemText;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnItemText</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUSTOMER_RETURN_ITEM_TEXT =
        new CustomerReturnItemField<String>("CustomerReturnItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new CustomerReturnItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> MATERIAL = new CustomerReturnItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> MATERIAL_BY_CUSTOMER =
        new CustomerReturnItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<BigDecimal> REQUESTED_QUANTITY =
        new CustomerReturnItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REQUESTED_QUANTITY_UNIT =
        new CustomerReturnItemField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new CustomerReturnItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<BigDecimal> ITEM_NET_WEIGHT =
        new CustomerReturnItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> ITEM_WEIGHT_UNIT =
        new CustomerReturnItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<BigDecimal> ITEM_VOLUME =
        new CustomerReturnItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> ITEM_VOLUME_UNIT =
        new CustomerReturnItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> TRANSACTION_CURRENCY =
        new CustomerReturnItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<BigDecimal> NET_AMOUNT =
        new CustomerReturnItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> MATERIAL_GROUP =
        new CustomerReturnItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> BATCH = new CustomerReturnItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCTION_PLANT =
        new CustomerReturnItemField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> STORAGE_LOCATION =
        new CustomerReturnItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SHIPPING_POINT =
        new CustomerReturnItemField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SHIPPING_TYPE =
        new CustomerReturnItemField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> DELIVERY_PRIORITY =
        new CustomerReturnItemField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> INCOTERMS_CLASSIFICATION =
        new CustomerReturnItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new CustomerReturnItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> INCOTERMS_LOCATION1 =
        new CustomerReturnItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> INCOTERMS_LOCATION2 =
        new CustomerReturnItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUSTOMER_PAYMENT_TERMS =
        new CustomerReturnItemField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new CustomerReturnItemField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new CustomerReturnItemField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new CustomerReturnItemField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new CustomerReturnItemField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new CustomerReturnItemField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new CustomerReturnItemField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new CustomerReturnItemField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new CustomerReturnItemField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new CustomerReturnItemField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new CustomerReturnItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Item
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> ITEM_BILLING_BLOCK_REASON =
        new CustomerReturnItemField<String>("ItemBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PROFIT_CENTER =
        new CustomerReturnItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @return Process Identification Number
     */
    @SerializedName( "RetsMgmtProcess" )
    @JsonProperty( "RetsMgmtProcess" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcess" )
    private String retsMgmtProcess;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcess</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_MGMT_PROCESS =
        new CustomerReturnItemField<String>("RetsMgmtProcess");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessItem</b>
     * </p>
     *
     * @return Item Number
     */
    @SerializedName( "RetsMgmtProcessItem" )
    @JsonProperty( "RetsMgmtProcessItem" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcessItem" )
    private String retsMgmtProcessItem;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcessItem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_MGMT_PROCESS_ITEM =
        new CustomerReturnItemField<String>("RetsMgmtProcessItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnReason</b>
     * </p>
     *
     * @return Return Reason
     */
    @SerializedName( "ReturnReason" )
    @JsonProperty( "ReturnReason" )
    @Nullable
    @ODataField( odataName = "ReturnReason" )
    private String returnReason;
    /**
     * Use with available fluent helpers to apply the <b>ReturnReason</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURN_REASON =
        new CustomerReturnItemField<String>("ReturnReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessingBlock</b>
     * </p>
     *
     * @return Approval Block
     */
    @SerializedName( "RetsMgmtProcessingBlock" )
    @JsonProperty( "RetsMgmtProcessingBlock" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcessingBlock" )
    private String retsMgmtProcessingBlock;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcessingBlock</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_MGMT_PROCESSING_BLOCK =
        new CustomerReturnItemField<String>("RetsMgmtProcessingBlock");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustRetItmFollowUpActivity</b>
     * </p>
     *
     * @return Follow-Up Activity Code
     */
    @SerializedName( "CustRetItmFollowUpActivity" )
    @JsonProperty( "CustRetItmFollowUpActivity" )
    @Nullable
    @ODataField( odataName = "CustRetItmFollowUpActivity" )
    private String custRetItmFollowUpActivity;
    /**
     * Use with available fluent helpers to apply the <b>CustRetItmFollowUpActivity</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUST_RET_ITM_FOLLOW_UP_ACTIVITY =
        new CustomerReturnItemField<String>("CustRetItmFollowUpActivity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsMaterialHasBeenReceived</b>
     * </p>
     *
     * @return The returnsMaterialHasBeenReceived contained in this entity.
     */
    @SerializedName( "ReturnsMaterialHasBeenReceived" )
    @JsonProperty( "ReturnsMaterialHasBeenReceived" )
    @Nullable
    @ODataField( odataName = "ReturnsMaterialHasBeenReceived" )
    private String returnsMaterialHasBeenReceived;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsMaterialHasBeenReceived</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_MATERIAL_HAS_BEEN_RECEIVED =
        new CustomerReturnItemField<String>("ReturnsMaterialHasBeenReceived");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundType</b>
     * </p>
     *
     * @return Refund Type
     */
    @SerializedName( "ReturnsRefundType" )
    @JsonProperty( "ReturnsRefundType" )
    @Nullable
    @ODataField( odataName = "ReturnsRefundType" )
    private String returnsRefundType;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsRefundType</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_REFUND_TYPE =
        new CustomerReturnItemField<String>("ReturnsRefundType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundProcgMode</b>
     * </p>
     *
     * @return Refund Processing Mode for a Return
     */
    @SerializedName( "ReturnsRefundProcgMode" )
    @JsonProperty( "ReturnsRefundProcgMode" )
    @Nullable
    @ODataField( odataName = "ReturnsRefundProcgMode" )
    private String returnsRefundProcgMode;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsRefundProcgMode</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_REFUND_PROCG_MODE =
        new CustomerReturnItemField<String>("ReturnsRefundProcgMode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsProdValnIsSuspended</b>
     * </p>
     *
     * @return The retsProdValnIsSuspended contained in this entity.
     */
    @SerializedName( "RetsProdValnIsSuspended" )
    @JsonProperty( "RetsProdValnIsSuspended" )
    @Nullable
    @ODataField( odataName = "RetsProdValnIsSuspended" )
    private String retsProdValnIsSuspended;
    /**
     * Use with available fluent helpers to apply the <b>RetsProdValnIsSuspended</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_PROD_VALN_IS_SUSPENDED =
        new CustomerReturnItemField<String>("RetsProdValnIsSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundExtent</b>
     * </p>
     *
     * @return Returns Refund Code
     */
    @SerializedName( "ReturnsRefundExtent" )
    @JsonProperty( "ReturnsRefundExtent" )
    @Nullable
    @ODataField( odataName = "ReturnsRefundExtent" )
    private String returnsRefundExtent;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsRefundExtent</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_REFUND_EXTENT =
        new CustomerReturnItemField<String>("ReturnsRefundExtent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrelimRefundIsDetermined</b>
     * </p>
     *
     * @return The prelimRefundIsDetermined contained in this entity.
     */
    @SerializedName( "PrelimRefundIsDetermined" )
    @JsonProperty( "PrelimRefundIsDetermined" )
    @Nullable
    @ODataField( odataName = "PrelimRefundIsDetermined" )
    private String prelimRefundIsDetermined;
    /**
     * Use with available fluent helpers to apply the <b>PrelimRefundIsDetermined</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRELIM_REFUND_IS_DETERMINED =
        new CustomerReturnItemField<String>("PrelimRefundIsDetermined");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundRjcnReason</b>
     * </p>
     *
     * @return Rejection Reason for Credit Memo Request
     */
    @SerializedName( "ReturnsRefundRjcnReason" )
    @JsonProperty( "ReturnsRefundRjcnReason" )
    @Nullable
    @ODataField( odataName = "ReturnsRefundRjcnReason" )
    private String returnsRefundRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsRefundRjcnReason</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_REFUND_RJCN_REASON =
        new CustomerReturnItemField<String>("ReturnsRefundRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterial</b>
     * </p>
     *
     * @return Replacement Material
     */
    @SerializedName( "ReplacementMaterial" )
    @JsonProperty( "ReplacementMaterial" )
    @Nullable
    @ODataField( odataName = "ReplacementMaterial" )
    private String replacementMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementMaterial</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REPLACEMENT_MATERIAL =
        new CustomerReturnItemField<String>("ReplacementMaterial");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterialQuantity</b>
     * </p>
     *
     * @return Replacement Material Quantity
     */
    @SerializedName( "ReplacementMaterialQuantity" )
    @JsonProperty( "ReplacementMaterialQuantity" )
    @Nullable
    @ODataField( odataName = "ReplacementMaterialQuantity" )
    private BigDecimal replacementMaterialQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementMaterialQuantity</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<BigDecimal> REPLACEMENT_MATERIAL_QUANTITY =
        new CustomerReturnItemField<BigDecimal>("ReplacementMaterialQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterialQtyUnit</b>
     * </p>
     *
     * @return Replacement Material Unit of Measure
     */
    @SerializedName( "ReplacementMaterialQtyUnit" )
    @JsonProperty( "ReplacementMaterialQtyUnit" )
    @Nullable
    @ODataField( odataName = "ReplacementMaterialQtyUnit" )
    private String replacementMaterialQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementMaterialQtyUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REPLACEMENT_MATERIAL_QTY_UNIT =
        new CustomerReturnItemField<String>("ReplacementMaterialQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterialIsRequested</b>
     * </p>
     *
     * @return The replacementMaterialIsRequested contained in this entity.
     */
    @SerializedName( "ReplacementMaterialIsRequested" )
    @JsonProperty( "ReplacementMaterialIsRequested" )
    @Nullable
    @ODataField( odataName = "ReplacementMaterialIsRequested" )
    private String replacementMaterialIsRequested;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementMaterialIsRequested</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REPLACEMENT_MATERIAL_IS_REQUESTED =
        new CustomerReturnItemField<String>("ReplacementMaterialIsRequested");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMatlSupplyingPlant</b>
     * </p>
     *
     * @return Supplying Plant for Replacement Material
     */
    @SerializedName( "ReplacementMatlSupplyingPlant" )
    @JsonProperty( "ReplacementMatlSupplyingPlant" )
    @Nullable
    @ODataField( odataName = "ReplacementMatlSupplyingPlant" )
    private String replacementMatlSupplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>ReplacementMatlSupplyingPlant</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REPLACEMENT_MATL_SUPPLYING_PLANT =
        new CustomerReturnItemField<String>("ReplacementMatlSupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NextPlantForFollowUpActivity</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "NextPlantForFollowUpActivity" )
    @JsonProperty( "NextPlantForFollowUpActivity" )
    @Nullable
    @ODataField( odataName = "NextPlantForFollowUpActivity" )
    private String nextPlantForFollowUpActivity;
    /**
     * Use with available fluent helpers to apply the <b>NextPlantForFollowUpActivity</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> NEXT_PLANT_FOR_FOLLOW_UP_ACTIVITY =
        new CustomerReturnItemField<String>("NextPlantForFollowUpActivity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsTransshipmentPlant</b>
     * </p>
     *
     * @return Transshipment Plant
     */
    @SerializedName( "ReturnsTransshipmentPlant" )
    @JsonProperty( "ReturnsTransshipmentPlant" )
    @Nullable
    @ODataField( odataName = "ReturnsTransshipmentPlant" )
    private String returnsTransshipmentPlant;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsTransshipmentPlant</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_TRANSSHIPMENT_PLANT =
        new CustomerReturnItemField<String>("ReturnsTransshipmentPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SUPPLIER = new CustomerReturnItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRetMatlAuthzn</b>
     * </p>
     *
     * @return Supplier RMA Number
     */
    @SerializedName( "SupplierRetMatlAuthzn" )
    @JsonProperty( "SupplierRetMatlAuthzn" )
    @Nullable
    @ODataField( odataName = "SupplierRetMatlAuthzn" )
    private String supplierRetMatlAuthzn;
    /**
     * Use with available fluent helpers to apply the <b>SupplierRetMatlAuthzn</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SUPPLIER_RET_MATL_AUTHZN =
        new CustomerReturnItemField<String>("SupplierRetMatlAuthzn");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrRetMatlAuthznIsRequired</b>
     * </p>
     *
     * @return The suplrRetMatlAuthznIsRequired contained in this entity.
     */
    @SerializedName( "SuplrRetMatlAuthznIsRequired" )
    @JsonProperty( "SuplrRetMatlAuthznIsRequired" )
    @Nullable
    @ODataField( odataName = "SuplrRetMatlAuthznIsRequired" )
    private String suplrRetMatlAuthznIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>SuplrRetMatlAuthznIsRequired</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SUPLR_RET_MATL_AUTHZN_IS_REQUIRED =
        new CustomerReturnItemField<String>("SuplrRetMatlAuthznIsRequired");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerRetMatlInspResultCode</b>
     * </p>
     *
     * @return Customer Inspection Code
     */
    @SerializedName( "CustomerRetMatlInspResultCode" )
    @JsonProperty( "CustomerRetMatlInspResultCode" )
    @Nullable
    @ODataField( odataName = "CustomerRetMatlInspResultCode" )
    private String customerRetMatlInspResultCode;
    /**
     * Use with available fluent helpers to apply the <b>CustomerRetMatlInspResultCode</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUSTOMER_RET_MATL_INSP_RESULT_CODE =
        new CustomerReturnItemField<String>("CustomerRetMatlInspResultCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NextFllwUpActivityForMatlInsp</b>
     * </p>
     *
     * @return Default for Next Follow-Up Activity in Material Inspection
     */
    @SerializedName( "NextFllwUpActivityForMatlInsp" )
    @JsonProperty( "NextFllwUpActivityForMatlInsp" )
    @Nullable
    @ODataField( odataName = "NextFllwUpActivityForMatlInsp" )
    private String nextFllwUpActivityForMatlInsp;
    /**
     * Use with available fluent helpers to apply the <b>NextFllwUpActivityForMatlInsp</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> NEXT_FLLW_UP_ACTIVITY_FOR_MATL_INSP =
        new CustomerReturnItemField<String>("NextFllwUpActivityForMatlInsp");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RetMatlInspResultCode</b>
     * </p>
     *
     * @return Inspection Code
     */
    @SerializedName( "RetMatlInspResultCode" )
    @JsonProperty( "RetMatlInspResultCode" )
    @Nullable
    @ODataField( odataName = "RetMatlInspResultCode" )
    private String retMatlInspResultCode;
    /**
     * Use with available fluent helpers to apply the <b>RetMatlInspResultCode</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RET_MATL_INSP_RESULT_CODE =
        new CustomerReturnItemField<String>("RetMatlInspResultCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsInspectedAtCustSite</b>
     * </p>
     *
     * @return The productIsInspectedAtCustSite contained in this entity.
     */
    @SerializedName( "ProductIsInspectedAtCustSite" )
    @JsonProperty( "ProductIsInspectedAtCustSite" )
    @Nullable
    @ODataField( odataName = "ProductIsInspectedAtCustSite" )
    private String productIsInspectedAtCustSite;
    /**
     * Use with available fluent helpers to apply the <b>ProductIsInspectedAtCustSite</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> PRODUCT_IS_INSPECTED_AT_CUST_SITE =
        new CustomerReturnItemField<String>("ProductIsInspectedAtCustSite");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustRetMatlAuthzn</b>
     * </p>
     *
     * @return Customer RMA Number
     */
    @SerializedName( "CustRetMatlAuthzn" )
    @JsonProperty( "CustRetMatlAuthzn" )
    @Nullable
    @ODataField( odataName = "CustRetMatlAuthzn" )
    private String custRetMatlAuthzn;
    /**
     * Use with available fluent helpers to apply the <b>CustRetMatlAuthzn</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CUST_RET_MATL_AUTHZN =
        new CustomerReturnItemField<String>("CustRetMatlAuthzn");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CRMLogicalSystem</b>
     * </p>
     *
     * @return CRM Logical System
     */
    @SerializedName( "CRMLogicalSystem" )
    @JsonProperty( "CRMLogicalSystem" )
    @Nullable
    @ODataField( odataName = "CRMLogicalSystem" )
    private String cRMLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>CRMLogicalSystem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CRM_LOGICAL_SYSTEM =
        new CustomerReturnItemField<String>("CRMLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CRMObjectUUID</b>
     * </p>
     *
     * @return CRM Object GUID
     */
    @SerializedName( "CRMObjectUUID" )
    @JsonProperty( "CRMObjectUUID" )
    @Nullable
    @ODataField( odataName = "CRMObjectUUID" )
    private String cRMObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>CRMObjectUUID</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CRM_OBJECT_UUID =
        new CustomerReturnItemField<String>("CRMObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CRMObjectID</b>
     * </p>
     *
     * @return CRM Object ID
     */
    @SerializedName( "CRMObjectID" )
    @JsonProperty( "CRMObjectID" )
    @Nullable
    @ODataField( odataName = "CRMObjectID" )
    private String cRMObjectID;
    /**
     * Use with available fluent helpers to apply the <b>CRMObjectID</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CRM_OBJECT_ID =
        new CustomerReturnItemField<String>("CRMObjectID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CRMObjectType</b>
     * </p>
     *
     * @return CRM Object Type
     */
    @SerializedName( "CRMObjectType" )
    @JsonProperty( "CRMObjectType" )
    @Nullable
    @ODataField( odataName = "CRMObjectType" )
    private String cRMObjectType;
    /**
     * Use with available fluent helpers to apply the <b>CRMObjectType</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> CRM_OBJECT_TYPE =
        new CustomerReturnItemField<String>("CRMObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtItmLogProcgStatus</b>
     * </p>
     *
     * @return Logistical Processing Status of a Return
     */
    @SerializedName( "RetsMgmtItmLogProcgStatus" )
    @JsonProperty( "RetsMgmtItmLogProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtItmLogProcgStatus" )
    private String retsMgmtItmLogProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtItmLogProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_MGMT_ITM_LOG_PROCG_STATUS =
        new CustomerReturnItemField<String>("RetsMgmtItmLogProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtItmCompnProcgStatus</b>
     * </p>
     *
     * @return Status of Returns Refund Determination
     */
    @SerializedName( "RetsMgmtItmCompnProcgStatus" )
    @JsonProperty( "RetsMgmtItmCompnProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtItmCompnProcgStatus" )
    private String retsMgmtItmCompnProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtItmCompnProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_MGMT_ITM_COMPN_PROCG_STATUS =
        new CustomerReturnItemField<String>("RetsMgmtItmCompnProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtItmProcgStatus</b>
     * </p>
     *
     * @return Processing Status
     */
    @SerializedName( "RetsMgmtItmProcgStatus" )
    @JsonProperty( "RetsMgmtItmProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtItmProcgStatus" )
    private String retsMgmtItmProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtItmProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETS_MGMT_ITM_PROCG_STATUS =
        new CustomerReturnItemField<String>("RetsMgmtItmProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentStatus</b>
     * </p>
     *
     * @return Status of Document Item
     */
    @SerializedName( "ReturnsDocumentStatus" )
    @JsonProperty( "ReturnsDocumentStatus" )
    @Nullable
    @ODataField( odataName = "ReturnsDocumentStatus" )
    private String returnsDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocumentStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_DOCUMENT_STATUS =
        new CustomerReturnItemField<String>("ReturnsDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentApprovalStatus</b>
     * </p>
     *
     * @return Approval Status of Returns Process
     */
    @SerializedName( "ReturnsDocumentApprovalStatus" )
    @JsonProperty( "ReturnsDocumentApprovalStatus" )
    @Nullable
    @ODataField( odataName = "ReturnsDocumentApprovalStatus" )
    private String returnsDocumentApprovalStatus;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocumentApprovalStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> RETURNS_DOCUMENT_APPROVAL_STATUS =
        new CustomerReturnItemField<String>("ReturnsDocumentApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SD_PROCESS_STATUS =
        new CustomerReturnItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REFERENCE_SD_DOCUMENT =
        new CustomerReturnItemField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new CustomerReturnItemField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Preceding SD Document
     */
    @SerializedName( "ReferenceSDDocumentCategory" )
    @JsonProperty( "ReferenceSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentCategory" )
    private String referenceSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentCategory</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> REFERENCE_SD_DOCUMENT_CATEGORY =
        new CustomerReturnItemField<String>("ReferenceSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRejectionStatus</b>
     * </p>
     *
     * @return Rejection Status (Item)
     */
    @SerializedName( "SDDocumentRejectionStatus" )
    @JsonProperty( "SDDocumentRejectionStatus" )
    @Nullable
    @ODataField( odataName = "SDDocumentRejectionStatus" )
    private String sDDocumentRejectionStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentRejectionStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnItemField<String> SD_DOCUMENT_REJECTION_STATUS =
        new CustomerReturnItemField<String>("SDDocumentRejectionStatus");
    /**
     * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnItem</b> to single <b>CustomerReturn</b>.
     *
     */
    @SerializedName( "to_CustomerReturn" )
    @JsonProperty( "to_CustomerReturn" )
    @ODataField( odataName = "to_CustomerReturn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturn toCustomerReturn;
    /**
     * Navigation property <b>to_Partner</b> for <b>CustomerReturnItem</b> to multiple <b>CustomerReturnItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>CustomerReturnItem</b> to multiple
     * <b>CustomerReturnItemPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnItemPrcgElmnt> toPricingElement;
    /**
     * Navigation property <b>to_ProcessStep</b> for <b>CustomerReturnItem</b> to multiple
     * <b>CustomerReturnProcessStep</b>.
     *
     */
    @SerializedName( "to_ProcessStep" )
    @JsonProperty( "to_ProcessStep" )
    @ODataField( odataName = "to_ProcessStep" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnProcessStep> toProcessStep;
    /**
     * Navigation property <b>to_RelatedObject</b> for <b>CustomerReturnItem</b> to multiple
     * <b>CustomerReturnItemRelatedObj</b>.
     *
     */
    @SerializedName( "to_RelatedObject" )
    @JsonProperty( "to_RelatedObject" )
    @ODataField( odataName = "to_RelatedObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnItemRelatedObj> toRelatedObject;
    /**
     * Navigation property <b>to_ScheduleLine</b> for <b>CustomerReturnItem</b> to multiple
     * <b>CustomerReturnScheduleLine</b>.
     *
     */
    @SerializedName( "to_ScheduleLine" )
    @JsonProperty( "to_ScheduleLine" )
    @ODataField( odataName = "to_ScheduleLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnScheduleLine> toScheduleLine;
    /**
     * Navigation property <b>to_SerialNumber</b> for <b>CustomerReturnItem</b> to multiple
     * <b>CustomerReturnSerialNumber</b>.
     *
     */
    @SerializedName( "to_SerialNumber" )
    @JsonProperty( "to_SerialNumber" )
    @ODataField( odataName = "to_SerialNumber" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnSerialNumber> toSerialNumber;
    /**
     * Navigation property <b>to_Text</b> for <b>CustomerReturnItem</b> to multiple <b>CustomerReturnItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustomerReturnItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturn</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemOneToOneLink<CustomerReturn> TO_CUSTOMER_RETURN =
        new CustomerReturnItemOneToOneLink<CustomerReturn>("to_CustomerReturn");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnItemPartner> TO_PARTNER =
        new CustomerReturnItemLink<CustomerReturnItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnItemPrcgElmnt> TO_PRICING_ELEMENT =
        new CustomerReturnItemLink<CustomerReturnItemPrcgElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ProcessStep</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnProcessStep> TO_PROCESS_STEP =
        new CustomerReturnItemLink<CustomerReturnProcessStep>("to_ProcessStep");
    /**
     * Use with available fluent helpers to apply the <b>to_RelatedObject</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnItemRelatedObj> TO_RELATED_OBJECT =
        new CustomerReturnItemLink<CustomerReturnItemRelatedObj>("to_RelatedObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ScheduleLine</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnScheduleLine> TO_SCHEDULE_LINE =
        new CustomerReturnItemLink<CustomerReturnScheduleLine>("to_ScheduleLine");
    /**
     * Use with available fluent helpers to apply the <b>to_SerialNumber</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnSerialNumber> TO_SERIAL_NUMBER =
        new CustomerReturnItemLink<CustomerReturnSerialNumber>("to_SerialNumber");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemLink<CustomerReturnItemText> TO_TEXT =
        new CustomerReturnItemLink<CustomerReturnItemText>("to_Text");

    @Nonnull
    @Override
    public Class<CustomerReturnItem> getType()
    {
        return CustomerReturnItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Customer Return
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @param customerReturnItem
     *            Customer Return Item
     */
    public void setCustomerReturnItem( @Nullable final String customerReturnItem )
    {
        rememberChangedField("CustomerReturnItem", this.customerReturnItem);
        this.customerReturnItem = customerReturnItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItemCategory</b>
     * </p>
     *
     * @param customerReturnItemCategory
     *            Sales Document Item Category
     */
    public void setCustomerReturnItemCategory( @Nullable final String customerReturnItemCategory )
    {
        rememberChangedField("CustomerReturnItemCategory", this.customerReturnItemCategory);
        this.customerReturnItemCategory = customerReturnItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItemText</b>
     * </p>
     *
     * @param customerReturnItemText
     *            Short Text for Sales Order Item
     */
    public void setCustomerReturnItemText( @Nullable final String customerReturnItemText )
    {
        rememberChangedField("CustomerReturnItemText", this.customerReturnItemText);
        this.customerReturnItemText = customerReturnItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Plant (Own or External)
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification for Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block for Item
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @param retsMgmtProcess
     *            Process Identification Number
     */
    public void setRetsMgmtProcess( @Nullable final String retsMgmtProcess )
    {
        rememberChangedField("RetsMgmtProcess", this.retsMgmtProcess);
        this.retsMgmtProcess = retsMgmtProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessItem</b>
     * </p>
     *
     * @param retsMgmtProcessItem
     *            Item Number
     */
    public void setRetsMgmtProcessItem( @Nullable final String retsMgmtProcessItem )
    {
        rememberChangedField("RetsMgmtProcessItem", this.retsMgmtProcessItem);
        this.retsMgmtProcessItem = retsMgmtProcessItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnReason</b>
     * </p>
     *
     * @param returnReason
     *            Return Reason
     */
    public void setReturnReason( @Nullable final String returnReason )
    {
        rememberChangedField("ReturnReason", this.returnReason);
        this.returnReason = returnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessingBlock</b>
     * </p>
     *
     * @param retsMgmtProcessingBlock
     *            Approval Block
     */
    public void setRetsMgmtProcessingBlock( @Nullable final String retsMgmtProcessingBlock )
    {
        rememberChangedField("RetsMgmtProcessingBlock", this.retsMgmtProcessingBlock);
        this.retsMgmtProcessingBlock = retsMgmtProcessingBlock;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustRetItmFollowUpActivity</b>
     * </p>
     *
     * @param custRetItmFollowUpActivity
     *            Follow-Up Activity Code
     */
    public void setCustRetItmFollowUpActivity( @Nullable final String custRetItmFollowUpActivity )
    {
        rememberChangedField("CustRetItmFollowUpActivity", this.custRetItmFollowUpActivity);
        this.custRetItmFollowUpActivity = custRetItmFollowUpActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsMaterialHasBeenReceived</b>
     * </p>
     *
     * @param returnsMaterialHasBeenReceived
     *            The returnsMaterialHasBeenReceived to set.
     */
    public void setReturnsMaterialHasBeenReceived( @Nullable final String returnsMaterialHasBeenReceived )
    {
        rememberChangedField("ReturnsMaterialHasBeenReceived", this.returnsMaterialHasBeenReceived);
        this.returnsMaterialHasBeenReceived = returnsMaterialHasBeenReceived;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundType</b>
     * </p>
     *
     * @param returnsRefundType
     *            Refund Type
     */
    public void setReturnsRefundType( @Nullable final String returnsRefundType )
    {
        rememberChangedField("ReturnsRefundType", this.returnsRefundType);
        this.returnsRefundType = returnsRefundType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundProcgMode</b>
     * </p>
     *
     * @param returnsRefundProcgMode
     *            Refund Processing Mode for a Return
     */
    public void setReturnsRefundProcgMode( @Nullable final String returnsRefundProcgMode )
    {
        rememberChangedField("ReturnsRefundProcgMode", this.returnsRefundProcgMode);
        this.returnsRefundProcgMode = returnsRefundProcgMode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsProdValnIsSuspended</b>
     * </p>
     *
     * @param retsProdValnIsSuspended
     *            The retsProdValnIsSuspended to set.
     */
    public void setRetsProdValnIsSuspended( @Nullable final String retsProdValnIsSuspended )
    {
        rememberChangedField("RetsProdValnIsSuspended", this.retsProdValnIsSuspended);
        this.retsProdValnIsSuspended = retsProdValnIsSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundExtent</b>
     * </p>
     *
     * @param returnsRefundExtent
     *            Returns Refund Code
     */
    public void setReturnsRefundExtent( @Nullable final String returnsRefundExtent )
    {
        rememberChangedField("ReturnsRefundExtent", this.returnsRefundExtent);
        this.returnsRefundExtent = returnsRefundExtent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrelimRefundIsDetermined</b>
     * </p>
     *
     * @param prelimRefundIsDetermined
     *            The prelimRefundIsDetermined to set.
     */
    public void setPrelimRefundIsDetermined( @Nullable final String prelimRefundIsDetermined )
    {
        rememberChangedField("PrelimRefundIsDetermined", this.prelimRefundIsDetermined);
        this.prelimRefundIsDetermined = prelimRefundIsDetermined;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsRefundRjcnReason</b>
     * </p>
     *
     * @param returnsRefundRjcnReason
     *            Rejection Reason for Credit Memo Request
     */
    public void setReturnsRefundRjcnReason( @Nullable final String returnsRefundRjcnReason )
    {
        rememberChangedField("ReturnsRefundRjcnReason", this.returnsRefundRjcnReason);
        this.returnsRefundRjcnReason = returnsRefundRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterial</b>
     * </p>
     *
     * @param replacementMaterial
     *            Replacement Material
     */
    public void setReplacementMaterial( @Nullable final String replacementMaterial )
    {
        rememberChangedField("ReplacementMaterial", this.replacementMaterial);
        this.replacementMaterial = replacementMaterial;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterialQuantity</b>
     * </p>
     *
     * @param replacementMaterialQuantity
     *            Replacement Material Quantity
     */
    public void setReplacementMaterialQuantity( @Nullable final BigDecimal replacementMaterialQuantity )
    {
        rememberChangedField("ReplacementMaterialQuantity", this.replacementMaterialQuantity);
        this.replacementMaterialQuantity = replacementMaterialQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterialQtyUnit</b>
     * </p>
     *
     * @param replacementMaterialQtyUnit
     *            Replacement Material Unit of Measure
     */
    public void setReplacementMaterialQtyUnit( @Nullable final String replacementMaterialQtyUnit )
    {
        rememberChangedField("ReplacementMaterialQtyUnit", this.replacementMaterialQtyUnit);
        this.replacementMaterialQtyUnit = replacementMaterialQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMaterialIsRequested</b>
     * </p>
     *
     * @param replacementMaterialIsRequested
     *            The replacementMaterialIsRequested to set.
     */
    public void setReplacementMaterialIsRequested( @Nullable final String replacementMaterialIsRequested )
    {
        rememberChangedField("ReplacementMaterialIsRequested", this.replacementMaterialIsRequested);
        this.replacementMaterialIsRequested = replacementMaterialIsRequested;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReplacementMatlSupplyingPlant</b>
     * </p>
     *
     * @param replacementMatlSupplyingPlant
     *            Supplying Plant for Replacement Material
     */
    public void setReplacementMatlSupplyingPlant( @Nullable final String replacementMatlSupplyingPlant )
    {
        rememberChangedField("ReplacementMatlSupplyingPlant", this.replacementMatlSupplyingPlant);
        this.replacementMatlSupplyingPlant = replacementMatlSupplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NextPlantForFollowUpActivity</b>
     * </p>
     *
     * @param nextPlantForFollowUpActivity
     *            Plant
     */
    public void setNextPlantForFollowUpActivity( @Nullable final String nextPlantForFollowUpActivity )
    {
        rememberChangedField("NextPlantForFollowUpActivity", this.nextPlantForFollowUpActivity);
        this.nextPlantForFollowUpActivity = nextPlantForFollowUpActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsTransshipmentPlant</b>
     * </p>
     *
     * @param returnsTransshipmentPlant
     *            Transshipment Plant
     */
    public void setReturnsTransshipmentPlant( @Nullable final String returnsTransshipmentPlant )
    {
        rememberChangedField("ReturnsTransshipmentPlant", this.returnsTransshipmentPlant);
        this.returnsTransshipmentPlant = returnsTransshipmentPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRetMatlAuthzn</b>
     * </p>
     *
     * @param supplierRetMatlAuthzn
     *            Supplier RMA Number
     */
    public void setSupplierRetMatlAuthzn( @Nullable final String supplierRetMatlAuthzn )
    {
        rememberChangedField("SupplierRetMatlAuthzn", this.supplierRetMatlAuthzn);
        this.supplierRetMatlAuthzn = supplierRetMatlAuthzn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrRetMatlAuthznIsRequired</b>
     * </p>
     *
     * @param suplrRetMatlAuthznIsRequired
     *            The suplrRetMatlAuthznIsRequired to set.
     */
    public void setSuplrRetMatlAuthznIsRequired( @Nullable final String suplrRetMatlAuthznIsRequired )
    {
        rememberChangedField("SuplrRetMatlAuthznIsRequired", this.suplrRetMatlAuthznIsRequired);
        this.suplrRetMatlAuthznIsRequired = suplrRetMatlAuthznIsRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerRetMatlInspResultCode</b>
     * </p>
     *
     * @param customerRetMatlInspResultCode
     *            Customer Inspection Code
     */
    public void setCustomerRetMatlInspResultCode( @Nullable final String customerRetMatlInspResultCode )
    {
        rememberChangedField("CustomerRetMatlInspResultCode", this.customerRetMatlInspResultCode);
        this.customerRetMatlInspResultCode = customerRetMatlInspResultCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NextFllwUpActivityForMatlInsp</b>
     * </p>
     *
     * @param nextFllwUpActivityForMatlInsp
     *            Default for Next Follow-Up Activity in Material Inspection
     */
    public void setNextFllwUpActivityForMatlInsp( @Nullable final String nextFllwUpActivityForMatlInsp )
    {
        rememberChangedField("NextFllwUpActivityForMatlInsp", this.nextFllwUpActivityForMatlInsp);
        this.nextFllwUpActivityForMatlInsp = nextFllwUpActivityForMatlInsp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RetMatlInspResultCode</b>
     * </p>
     *
     * @param retMatlInspResultCode
     *            Inspection Code
     */
    public void setRetMatlInspResultCode( @Nullable final String retMatlInspResultCode )
    {
        rememberChangedField("RetMatlInspResultCode", this.retMatlInspResultCode);
        this.retMatlInspResultCode = retMatlInspResultCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductIsInspectedAtCustSite</b>
     * </p>
     *
     * @param productIsInspectedAtCustSite
     *            The productIsInspectedAtCustSite to set.
     */
    public void setProductIsInspectedAtCustSite( @Nullable final String productIsInspectedAtCustSite )
    {
        rememberChangedField("ProductIsInspectedAtCustSite", this.productIsInspectedAtCustSite);
        this.productIsInspectedAtCustSite = productIsInspectedAtCustSite;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustRetMatlAuthzn</b>
     * </p>
     *
     * @param custRetMatlAuthzn
     *            Customer RMA Number
     */
    public void setCustRetMatlAuthzn( @Nullable final String custRetMatlAuthzn )
    {
        rememberChangedField("CustRetMatlAuthzn", this.custRetMatlAuthzn);
        this.custRetMatlAuthzn = custRetMatlAuthzn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CRMLogicalSystem</b>
     * </p>
     *
     * @param cRMLogicalSystem
     *            CRM Logical System
     */
    public void setCRMLogicalSystem( @Nullable final String cRMLogicalSystem )
    {
        rememberChangedField("CRMLogicalSystem", this.cRMLogicalSystem);
        this.cRMLogicalSystem = cRMLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CRMObjectUUID</b>
     * </p>
     *
     * @param cRMObjectUUID
     *            CRM Object GUID
     */
    public void setCRMObjectUUID( @Nullable final String cRMObjectUUID )
    {
        rememberChangedField("CRMObjectUUID", this.cRMObjectUUID);
        this.cRMObjectUUID = cRMObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CRMObjectID</b>
     * </p>
     *
     * @param cRMObjectID
     *            CRM Object ID
     */
    public void setCRMObjectID( @Nullable final String cRMObjectID )
    {
        rememberChangedField("CRMObjectID", this.cRMObjectID);
        this.cRMObjectID = cRMObjectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CRMObjectType</b>
     * </p>
     *
     * @param cRMObjectType
     *            CRM Object Type
     */
    public void setCRMObjectType( @Nullable final String cRMObjectType )
    {
        rememberChangedField("CRMObjectType", this.cRMObjectType);
        this.cRMObjectType = cRMObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtItmLogProcgStatus</b>
     * </p>
     *
     * @param retsMgmtItmLogProcgStatus
     *            Logistical Processing Status of a Return
     */
    public void setRetsMgmtItmLogProcgStatus( @Nullable final String retsMgmtItmLogProcgStatus )
    {
        rememberChangedField("RetsMgmtItmLogProcgStatus", this.retsMgmtItmLogProcgStatus);
        this.retsMgmtItmLogProcgStatus = retsMgmtItmLogProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtItmCompnProcgStatus</b>
     * </p>
     *
     * @param retsMgmtItmCompnProcgStatus
     *            Status of Returns Refund Determination
     */
    public void setRetsMgmtItmCompnProcgStatus( @Nullable final String retsMgmtItmCompnProcgStatus )
    {
        rememberChangedField("RetsMgmtItmCompnProcgStatus", this.retsMgmtItmCompnProcgStatus);
        this.retsMgmtItmCompnProcgStatus = retsMgmtItmCompnProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtItmProcgStatus</b>
     * </p>
     *
     * @param retsMgmtItmProcgStatus
     *            Processing Status
     */
    public void setRetsMgmtItmProcgStatus( @Nullable final String retsMgmtItmProcgStatus )
    {
        rememberChangedField("RetsMgmtItmProcgStatus", this.retsMgmtItmProcgStatus);
        this.retsMgmtItmProcgStatus = retsMgmtItmProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentStatus</b>
     * </p>
     *
     * @param returnsDocumentStatus
     *            Status of Document Item
     */
    public void setReturnsDocumentStatus( @Nullable final String returnsDocumentStatus )
    {
        rememberChangedField("ReturnsDocumentStatus", this.returnsDocumentStatus);
        this.returnsDocumentStatus = returnsDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentApprovalStatus</b>
     * </p>
     *
     * @param returnsDocumentApprovalStatus
     *            Approval Status of Returns Process
     */
    public void setReturnsDocumentApprovalStatus( @Nullable final String returnsDocumentApprovalStatus )
    {
        rememberChangedField("ReturnsDocumentApprovalStatus", this.returnsDocumentApprovalStatus);
        this.returnsDocumentApprovalStatus = returnsDocumentApprovalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @param referenceSDDocumentCategory
     *            Document Category of Preceding SD Document
     */
    public void setReferenceSDDocumentCategory( @Nullable final String referenceSDDocumentCategory )
    {
        rememberChangedField("ReferenceSDDocumentCategory", this.referenceSDDocumentCategory);
        this.referenceSDDocumentCategory = referenceSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRejectionStatus</b>
     * </p>
     *
     * @param sDDocumentRejectionStatus
     *            Rejection Status (Item)
     */
    public void setSDDocumentRejectionStatus( @Nullable final String sDDocumentRejectionStatus )
    {
        rememberChangedField("SDDocumentRejectionStatus", this.sDDocumentRejectionStatus);
        this.sDDocumentRejectionStatus = sDDocumentRejectionStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        result.put("CustomerReturnItem", getCustomerReturnItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("CustomerReturnItem", getCustomerReturnItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("CustomerReturnItemCategory", getCustomerReturnItemCategory());
        values.put("CustomerReturnItemText", getCustomerReturnItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Batch", getBatch());
        values.put("ProductionPlant", getProductionPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ShippingType", getShippingType());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        values.put("ProfitCenter", getProfitCenter());
        values.put("RetsMgmtProcess", getRetsMgmtProcess());
        values.put("RetsMgmtProcessItem", getRetsMgmtProcessItem());
        values.put("ReturnReason", getReturnReason());
        values.put("RetsMgmtProcessingBlock", getRetsMgmtProcessingBlock());
        values.put("CustRetItmFollowUpActivity", getCustRetItmFollowUpActivity());
        values.put("ReturnsMaterialHasBeenReceived", getReturnsMaterialHasBeenReceived());
        values.put("ReturnsRefundType", getReturnsRefundType());
        values.put("ReturnsRefundProcgMode", getReturnsRefundProcgMode());
        values.put("RetsProdValnIsSuspended", getRetsProdValnIsSuspended());
        values.put("ReturnsRefundExtent", getReturnsRefundExtent());
        values.put("PrelimRefundIsDetermined", getPrelimRefundIsDetermined());
        values.put("ReturnsRefundRjcnReason", getReturnsRefundRjcnReason());
        values.put("ReplacementMaterial", getReplacementMaterial());
        values.put("ReplacementMaterialQuantity", getReplacementMaterialQuantity());
        values.put("ReplacementMaterialQtyUnit", getReplacementMaterialQtyUnit());
        values.put("ReplacementMaterialIsRequested", getReplacementMaterialIsRequested());
        values.put("ReplacementMatlSupplyingPlant", getReplacementMatlSupplyingPlant());
        values.put("NextPlantForFollowUpActivity", getNextPlantForFollowUpActivity());
        values.put("ReturnsTransshipmentPlant", getReturnsTransshipmentPlant());
        values.put("Supplier", getSupplier());
        values.put("SupplierRetMatlAuthzn", getSupplierRetMatlAuthzn());
        values.put("SuplrRetMatlAuthznIsRequired", getSuplrRetMatlAuthznIsRequired());
        values.put("CustomerRetMatlInspResultCode", getCustomerRetMatlInspResultCode());
        values.put("NextFllwUpActivityForMatlInsp", getNextFllwUpActivityForMatlInsp());
        values.put("RetMatlInspResultCode", getRetMatlInspResultCode());
        values.put("ProductIsInspectedAtCustSite", getProductIsInspectedAtCustSite());
        values.put("CustRetMatlAuthzn", getCustRetMatlAuthzn());
        values.put("CRMLogicalSystem", getCRMLogicalSystem());
        values.put("CRMObjectUUID", getCRMObjectUUID());
        values.put("CRMObjectID", getCRMObjectID());
        values.put("CRMObjectType", getCRMObjectType());
        values.put("RetsMgmtItmLogProcgStatus", getRetsMgmtItmLogProcgStatus());
        values.put("RetsMgmtItmCompnProcgStatus", getRetsMgmtItmCompnProcgStatus());
        values.put("RetsMgmtItmProcgStatus", getRetsMgmtItmProcgStatus());
        values.put("ReturnsDocumentStatus", getReturnsDocumentStatus());
        values.put("ReturnsDocumentApprovalStatus", getReturnsDocumentApprovalStatus());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("ReferenceSDDocumentCategory", getReferenceSDDocumentCategory());
        values.put("SDDocumentRejectionStatus", getSDDocumentRejectionStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnItem") ) {
                final Object value = values.remove("CustomerReturnItem");
                if( (value == null) || (!value.equals(getCustomerReturnItem())) ) {
                    setCustomerReturnItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnItemCategory") ) {
                final Object value = values.remove("CustomerReturnItemCategory");
                if( (value == null) || (!value.equals(getCustomerReturnItemCategory())) ) {
                    setCustomerReturnItemCategory(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnItemText") ) {
                final Object value = values.remove("CustomerReturnItemText");
                if( (value == null) || (!value.equals(getCustomerReturnItemText())) ) {
                    setCustomerReturnItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcess") ) {
                final Object value = values.remove("RetsMgmtProcess");
                if( (value == null) || (!value.equals(getRetsMgmtProcess())) ) {
                    setRetsMgmtProcess(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcessItem") ) {
                final Object value = values.remove("RetsMgmtProcessItem");
                if( (value == null) || (!value.equals(getRetsMgmtProcessItem())) ) {
                    setRetsMgmtProcessItem(((String) value));
                }
            }
            if( values.containsKey("ReturnReason") ) {
                final Object value = values.remove("ReturnReason");
                if( (value == null) || (!value.equals(getReturnReason())) ) {
                    setReturnReason(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcessingBlock") ) {
                final Object value = values.remove("RetsMgmtProcessingBlock");
                if( (value == null) || (!value.equals(getRetsMgmtProcessingBlock())) ) {
                    setRetsMgmtProcessingBlock(((String) value));
                }
            }
            if( values.containsKey("CustRetItmFollowUpActivity") ) {
                final Object value = values.remove("CustRetItmFollowUpActivity");
                if( (value == null) || (!value.equals(getCustRetItmFollowUpActivity())) ) {
                    setCustRetItmFollowUpActivity(((String) value));
                }
            }
            if( values.containsKey("ReturnsMaterialHasBeenReceived") ) {
                final Object value = values.remove("ReturnsMaterialHasBeenReceived");
                if( (value == null) || (!value.equals(getReturnsMaterialHasBeenReceived())) ) {
                    setReturnsMaterialHasBeenReceived(((String) value));
                }
            }
            if( values.containsKey("ReturnsRefundType") ) {
                final Object value = values.remove("ReturnsRefundType");
                if( (value == null) || (!value.equals(getReturnsRefundType())) ) {
                    setReturnsRefundType(((String) value));
                }
            }
            if( values.containsKey("ReturnsRefundProcgMode") ) {
                final Object value = values.remove("ReturnsRefundProcgMode");
                if( (value == null) || (!value.equals(getReturnsRefundProcgMode())) ) {
                    setReturnsRefundProcgMode(((String) value));
                }
            }
            if( values.containsKey("RetsProdValnIsSuspended") ) {
                final Object value = values.remove("RetsProdValnIsSuspended");
                if( (value == null) || (!value.equals(getRetsProdValnIsSuspended())) ) {
                    setRetsProdValnIsSuspended(((String) value));
                }
            }
            if( values.containsKey("ReturnsRefundExtent") ) {
                final Object value = values.remove("ReturnsRefundExtent");
                if( (value == null) || (!value.equals(getReturnsRefundExtent())) ) {
                    setReturnsRefundExtent(((String) value));
                }
            }
            if( values.containsKey("PrelimRefundIsDetermined") ) {
                final Object value = values.remove("PrelimRefundIsDetermined");
                if( (value == null) || (!value.equals(getPrelimRefundIsDetermined())) ) {
                    setPrelimRefundIsDetermined(((String) value));
                }
            }
            if( values.containsKey("ReturnsRefundRjcnReason") ) {
                final Object value = values.remove("ReturnsRefundRjcnReason");
                if( (value == null) || (!value.equals(getReturnsRefundRjcnReason())) ) {
                    setReturnsRefundRjcnReason(((String) value));
                }
            }
            if( values.containsKey("ReplacementMaterial") ) {
                final Object value = values.remove("ReplacementMaterial");
                if( (value == null) || (!value.equals(getReplacementMaterial())) ) {
                    setReplacementMaterial(((String) value));
                }
            }
            if( values.containsKey("ReplacementMaterialQuantity") ) {
                final Object value = values.remove("ReplacementMaterialQuantity");
                if( (value == null) || (!value.equals(getReplacementMaterialQuantity())) ) {
                    setReplacementMaterialQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReplacementMaterialQtyUnit") ) {
                final Object value = values.remove("ReplacementMaterialQtyUnit");
                if( (value == null) || (!value.equals(getReplacementMaterialQtyUnit())) ) {
                    setReplacementMaterialQtyUnit(((String) value));
                }
            }
            if( values.containsKey("ReplacementMaterialIsRequested") ) {
                final Object value = values.remove("ReplacementMaterialIsRequested");
                if( (value == null) || (!value.equals(getReplacementMaterialIsRequested())) ) {
                    setReplacementMaterialIsRequested(((String) value));
                }
            }
            if( values.containsKey("ReplacementMatlSupplyingPlant") ) {
                final Object value = values.remove("ReplacementMatlSupplyingPlant");
                if( (value == null) || (!value.equals(getReplacementMatlSupplyingPlant())) ) {
                    setReplacementMatlSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("NextPlantForFollowUpActivity") ) {
                final Object value = values.remove("NextPlantForFollowUpActivity");
                if( (value == null) || (!value.equals(getNextPlantForFollowUpActivity())) ) {
                    setNextPlantForFollowUpActivity(((String) value));
                }
            }
            if( values.containsKey("ReturnsTransshipmentPlant") ) {
                final Object value = values.remove("ReturnsTransshipmentPlant");
                if( (value == null) || (!value.equals(getReturnsTransshipmentPlant())) ) {
                    setReturnsTransshipmentPlant(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierRetMatlAuthzn") ) {
                final Object value = values.remove("SupplierRetMatlAuthzn");
                if( (value == null) || (!value.equals(getSupplierRetMatlAuthzn())) ) {
                    setSupplierRetMatlAuthzn(((String) value));
                }
            }
            if( values.containsKey("SuplrRetMatlAuthznIsRequired") ) {
                final Object value = values.remove("SuplrRetMatlAuthznIsRequired");
                if( (value == null) || (!value.equals(getSuplrRetMatlAuthznIsRequired())) ) {
                    setSuplrRetMatlAuthznIsRequired(((String) value));
                }
            }
            if( values.containsKey("CustomerRetMatlInspResultCode") ) {
                final Object value = values.remove("CustomerRetMatlInspResultCode");
                if( (value == null) || (!value.equals(getCustomerRetMatlInspResultCode())) ) {
                    setCustomerRetMatlInspResultCode(((String) value));
                }
            }
            if( values.containsKey("NextFllwUpActivityForMatlInsp") ) {
                final Object value = values.remove("NextFllwUpActivityForMatlInsp");
                if( (value == null) || (!value.equals(getNextFllwUpActivityForMatlInsp())) ) {
                    setNextFllwUpActivityForMatlInsp(((String) value));
                }
            }
            if( values.containsKey("RetMatlInspResultCode") ) {
                final Object value = values.remove("RetMatlInspResultCode");
                if( (value == null) || (!value.equals(getRetMatlInspResultCode())) ) {
                    setRetMatlInspResultCode(((String) value));
                }
            }
            if( values.containsKey("ProductIsInspectedAtCustSite") ) {
                final Object value = values.remove("ProductIsInspectedAtCustSite");
                if( (value == null) || (!value.equals(getProductIsInspectedAtCustSite())) ) {
                    setProductIsInspectedAtCustSite(((String) value));
                }
            }
            if( values.containsKey("CustRetMatlAuthzn") ) {
                final Object value = values.remove("CustRetMatlAuthzn");
                if( (value == null) || (!value.equals(getCustRetMatlAuthzn())) ) {
                    setCustRetMatlAuthzn(((String) value));
                }
            }
            if( values.containsKey("CRMLogicalSystem") ) {
                final Object value = values.remove("CRMLogicalSystem");
                if( (value == null) || (!value.equals(getCRMLogicalSystem())) ) {
                    setCRMLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("CRMObjectUUID") ) {
                final Object value = values.remove("CRMObjectUUID");
                if( (value == null) || (!value.equals(getCRMObjectUUID())) ) {
                    setCRMObjectUUID(((String) value));
                }
            }
            if( values.containsKey("CRMObjectID") ) {
                final Object value = values.remove("CRMObjectID");
                if( (value == null) || (!value.equals(getCRMObjectID())) ) {
                    setCRMObjectID(((String) value));
                }
            }
            if( values.containsKey("CRMObjectType") ) {
                final Object value = values.remove("CRMObjectType");
                if( (value == null) || (!value.equals(getCRMObjectType())) ) {
                    setCRMObjectType(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtItmLogProcgStatus") ) {
                final Object value = values.remove("RetsMgmtItmLogProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtItmLogProcgStatus())) ) {
                    setRetsMgmtItmLogProcgStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtItmCompnProcgStatus") ) {
                final Object value = values.remove("RetsMgmtItmCompnProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtItmCompnProcgStatus())) ) {
                    setRetsMgmtItmCompnProcgStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtItmProcgStatus") ) {
                final Object value = values.remove("RetsMgmtItmProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtItmProcgStatus())) ) {
                    setRetsMgmtItmProcgStatus(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocumentStatus") ) {
                final Object value = values.remove("ReturnsDocumentStatus");
                if( (value == null) || (!value.equals(getReturnsDocumentStatus())) ) {
                    setReturnsDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocumentApprovalStatus") ) {
                final Object value = values.remove("ReturnsDocumentApprovalStatus");
                if( (value == null) || (!value.equals(getReturnsDocumentApprovalStatus())) ) {
                    setReturnsDocumentApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentCategory") ) {
                final Object value = values.remove("ReferenceSDDocumentCategory");
                if( (value == null) || (!value.equals(getReferenceSDDocumentCategory())) ) {
                    setReferenceSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("SDDocumentRejectionStatus") ) {
                final Object value = values.remove("SDDocumentRejectionStatus");
                if( (value == null) || (!value.equals(getSDDocumentRejectionStatus())) ) {
                    setSDDocumentRejectionStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturn") ) {
                final Object value = (values).remove("to_CustomerReturn");
                if( value instanceof Map ) {
                    if( toCustomerReturn == null ) {
                        toCustomerReturn = new CustomerReturn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturn.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new CustomerReturnItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnItemPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new CustomerReturnItemPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProcessStep") ) {
                final Object value = (values).remove("to_ProcessStep");
                if( value instanceof Iterable ) {
                    if( toProcessStep == null ) {
                        toProcessStep = Lists.newArrayList();
                    } else {
                        toProcessStep = Lists.newArrayList(toProcessStep);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnProcessStep entity;
                        if( toProcessStep.size() > i ) {
                            entity = toProcessStep.get(i);
                        } else {
                            entity = new CustomerReturnProcessStep();
                            toProcessStep.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RelatedObject") ) {
                final Object value = (values).remove("to_RelatedObject");
                if( value instanceof Iterable ) {
                    if( toRelatedObject == null ) {
                        toRelatedObject = Lists.newArrayList();
                    } else {
                        toRelatedObject = Lists.newArrayList(toRelatedObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnItemRelatedObj entity;
                        if( toRelatedObject.size() > i ) {
                            entity = toRelatedObject.get(i);
                        } else {
                            entity = new CustomerReturnItemRelatedObj();
                            toRelatedObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ScheduleLine") ) {
                final Object value = (values).remove("to_ScheduleLine");
                if( value instanceof Iterable ) {
                    if( toScheduleLine == null ) {
                        toScheduleLine = Lists.newArrayList();
                    } else {
                        toScheduleLine = Lists.newArrayList(toScheduleLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnScheduleLine entity;
                        if( toScheduleLine.size() > i ) {
                            entity = toScheduleLine.get(i);
                        } else {
                            entity = new CustomerReturnScheduleLine();
                            toScheduleLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SerialNumber") ) {
                final Object value = (values).remove("to_SerialNumber");
                if( value instanceof Iterable ) {
                    if( toSerialNumber == null ) {
                        toSerialNumber = Lists.newArrayList();
                    } else {
                        toSerialNumber = Lists.newArrayList(toSerialNumber);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnSerialNumber entity;
                        if( toSerialNumber.size() > i ) {
                            entity = toSerialNumber.get(i);
                        } else {
                            entity = new CustomerReturnSerialNumber();
                            toSerialNumber.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustomerReturnItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new CustomerReturnItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerReturnItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturn != null ) {
            (values).put("to_CustomerReturn", toCustomerReturn);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toProcessStep != null ) {
            (values).put("to_ProcessStep", toProcessStep);
        }
        if( toRelatedObject != null ) {
            (values).put("to_RelatedObject", toRelatedObject);
        }
        if( toScheduleLine != null ) {
            (values).put("to_ScheduleLine", toScheduleLine);
        }
        if( toSerialNumber != null ) {
            (values).put("to_SerialNumber", toSerialNumber);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturn</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerReturn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn fetchCustomerReturn()
    {
        return fetchFieldAsSingle("to_CustomerReturn", CustomerReturn.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturn</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn getCustomerReturnOrFetch()
    {
        if( toCustomerReturn == null ) {
            toCustomerReturn = fetchCustomerReturn();
        }
        return toCustomerReturn;
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturn</b> is already loaded, the result will
     *         contain the <b>CustomerReturn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturn> getCustomerReturnIfPresent()
    {
        return Option.of(toCustomerReturn);
    }

    /**
     * Overwrites the associated <b>CustomerReturn</b> entity for the loaded navigation property
     * <b>to_CustomerReturn</b>.
     *
     * @param value
     *            New <b>CustomerReturn</b> entity.
     */
    public void setCustomerReturn( final CustomerReturn value )
    {
        toCustomerReturn = value;
    }

    /**
     * Fetches the <b>CustomerReturnItemPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", CustomerReturnItemPartner.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>CustomerReturnItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<CustomerReturnItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnItemPartner</b> entities.
     */
    public void addPartner( CustomerReturnItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnItemPrcgElmnt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnItemPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", CustomerReturnItemPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItemPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>CustomerReturnItemPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnItemPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnItemPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnItemPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<CustomerReturnItemPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnItemPrcgElmnt</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnItemPrcgElmnt</b> entities.
     */
    public void addPricingElement( CustomerReturnItemPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnProcessStep</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProcessStep</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnProcessStep</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnProcessStep> fetchProcessStep()
    {
        return fetchFieldAsList("to_ProcessStep", CustomerReturnProcessStep.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnProcessStep</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessStep</b>.
     * <p>
     * If the navigation property <b>to_ProcessStep</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnProcessStep</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnProcessStep> getProcessStepOrFetch()
    {
        if( toProcessStep == null ) {
            toProcessStep = fetchProcessStep();
        }
        return toProcessStep;
    }

    /**
     * Retrieval of associated <b>CustomerReturnProcessStep</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessStep</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProcessStep</b> is already loaded, the result will
     *         contain the <b>CustomerReturnProcessStep</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnProcessStep>> getProcessStepIfPresent()
    {
        return Option.of(toProcessStep);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnProcessStep</b> entities for the loaded navigation property
     * <b>to_ProcessStep</b>.
     * <p>
     * If the navigation property <b>to_ProcessStep</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnProcessStep</b> entities.
     */
    public void setProcessStep( @Nonnull final List<CustomerReturnProcessStep> value )
    {
        if( toProcessStep == null ) {
            toProcessStep = Lists.newArrayList();
        }
        toProcessStep.clear();
        toProcessStep.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnProcessStep</b> entities. This corresponds to the OData
     * navigation property <b>to_ProcessStep</b>.
     * <p>
     * If the navigation property <b>to_ProcessStep</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnProcessStep</b> entities.
     */
    public void addProcessStep( CustomerReturnProcessStep... entity )
    {
        if( toProcessStep == null ) {
            toProcessStep = Lists.newArrayList();
        }
        toProcessStep.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnItemRelatedObj</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnItemRelatedObj</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemRelatedObj> fetchRelatedObject()
    {
        return fetchFieldAsList("to_RelatedObject", CustomerReturnItemRelatedObj.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemRelatedObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItemRelatedObj</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemRelatedObj> getRelatedObjectOrFetch()
    {
        if( toRelatedObject == null ) {
            toRelatedObject = fetchRelatedObject();
        }
        return toRelatedObject;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemRelatedObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RelatedObject</b> is already loaded, the result will
     *         contain the <b>CustomerReturnItemRelatedObj</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnItemRelatedObj>> getRelatedObjectIfPresent()
    {
        return Option.of(toRelatedObject);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnItemRelatedObj</b> entities for the loaded navigation property
     * <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnItemRelatedObj</b> entities.
     */
    public void setRelatedObject( @Nonnull final List<CustomerReturnItemRelatedObj> value )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.clear();
        toRelatedObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnItemRelatedObj</b> entities. This corresponds to the
     * OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnItemRelatedObj</b> entities.
     */
    public void addRelatedObject( CustomerReturnItemRelatedObj... entity )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnScheduleLine</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnScheduleLine</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnScheduleLine> fetchScheduleLine()
    {
        return fetchFieldAsList("to_ScheduleLine", CustomerReturnScheduleLine.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnScheduleLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnScheduleLine> getScheduleLineOrFetch()
    {
        if( toScheduleLine == null ) {
            toScheduleLine = fetchScheduleLine();
        }
        return toScheduleLine;
    }

    /**
     * Retrieval of associated <b>CustomerReturnScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ScheduleLine</b> is already loaded, the result will
     *         contain the <b>CustomerReturnScheduleLine</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnScheduleLine>> getScheduleLineIfPresent()
    {
        return Option.of(toScheduleLine);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnScheduleLine</b> entities for the loaded navigation property
     * <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnScheduleLine</b> entities.
     */
    public void setScheduleLine( @Nonnull final List<CustomerReturnScheduleLine> value )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.clear();
        toScheduleLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnScheduleLine</b> entities. This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnScheduleLine</b> entities.
     */
    public void addScheduleLine( CustomerReturnScheduleLine... entity )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnSerialNumber</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SerialNumber</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnSerialNumber</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnSerialNumber> fetchSerialNumber()
    {
        return fetchFieldAsList("to_SerialNumber", CustomerReturnSerialNumber.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnSerialNumber</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SerialNumber</b>.
     * <p>
     * If the navigation property <b>to_SerialNumber</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnSerialNumber</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnSerialNumber> getSerialNumberOrFetch()
    {
        if( toSerialNumber == null ) {
            toSerialNumber = fetchSerialNumber();
        }
        return toSerialNumber;
    }

    /**
     * Retrieval of associated <b>CustomerReturnSerialNumber</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SerialNumber</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SerialNumber</b> is already loaded, the result will
     *         contain the <b>CustomerReturnSerialNumber</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnSerialNumber>> getSerialNumberIfPresent()
    {
        return Option.of(toSerialNumber);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnSerialNumber</b> entities for the loaded navigation property
     * <b>to_SerialNumber</b>.
     * <p>
     * If the navigation property <b>to_SerialNumber</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnSerialNumber</b> entities.
     */
    public void setSerialNumber( @Nonnull final List<CustomerReturnSerialNumber> value )
    {
        if( toSerialNumber == null ) {
            toSerialNumber = Lists.newArrayList();
        }
        toSerialNumber.clear();
        toSerialNumber.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnSerialNumber</b> entities. This corresponds to the OData
     * navigation property <b>to_SerialNumber</b>.
     * <p>
     * If the navigation property <b>to_SerialNumber</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnSerialNumber</b> entities.
     */
    public void addSerialNumber( CustomerReturnSerialNumber... entity )
    {
        if( toSerialNumber == null ) {
            toSerialNumber = Lists.newArrayList();
        }
        toSerialNumber.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustomerReturnItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustomerReturnItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", CustomerReturnItemText.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustomerReturnItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>CustomerReturnItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustomerReturnItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>CustomerReturnItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustomerReturnItemText</b> entities.
     */
    public void setText( @Nonnull final List<CustomerReturnItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustomerReturnItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CustomerReturnItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustomerReturnItemText</b> entities.
     */
    public void addText( CustomerReturnItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturnItem instances.
     *
     */
    public final static class CustomerReturnItemBuilder
    {

        private CustomerReturn toCustomerReturn;
        private String customerReturn = null;
        private List<CustomerReturnItemPartner> toPartner = Lists.newArrayList();
        private List<CustomerReturnItemPrcgElmnt> toPricingElement = Lists.newArrayList();
        private List<CustomerReturnProcessStep> toProcessStep = Lists.newArrayList();
        private List<CustomerReturnItemRelatedObj> toRelatedObject = Lists.newArrayList();
        private List<CustomerReturnScheduleLine> toScheduleLine = Lists.newArrayList();
        private List<CustomerReturnSerialNumber> toSerialNumber = Lists.newArrayList();
        private List<CustomerReturnItemText> toText = Lists.newArrayList();

        private CustomerReturnItem.CustomerReturnItemBuilder toCustomerReturn( final CustomerReturn value )
        {
            toCustomerReturn = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnItem</b> to single <b>CustomerReturn</b>.
         *
         * @param value
         *            The CustomerReturn to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder customerReturn( final CustomerReturn value )
        {
            return toCustomerReturn(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturn</b>
         * </p>
         *
         * @param value
         *            The customerReturn to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder customerReturn( final String value )
        {
            customerReturn = value;
            return this;
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toPartner( final List<CustomerReturnItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>CustomerReturnItem</b> to multiple
         * <b>CustomerReturnItemPartner</b>.
         *
         * @param value
         *            The CustomerReturnItemPartners to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder partner( CustomerReturnItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toPricingElement(
            final List<CustomerReturnItemPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>CustomerReturnItem</b> to multiple
         * <b>CustomerReturnItemPrcgElmnt</b>.
         *
         * @param value
         *            The CustomerReturnItemPrcgElmnts to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder pricingElement( CustomerReturnItemPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toProcessStep(
            final List<CustomerReturnProcessStep> value )
        {
            toProcessStep.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProcessStep</b> for <b>CustomerReturnItem</b> to multiple
         * <b>CustomerReturnProcessStep</b>.
         *
         * @param value
         *            The CustomerReturnProcessSteps to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder processStep( CustomerReturnProcessStep... value )
        {
            return toProcessStep(Lists.newArrayList(value));
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toRelatedObject(
            final List<CustomerReturnItemRelatedObj> value )
        {
            toRelatedObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RelatedObject</b> for <b>CustomerReturnItem</b> to multiple
         * <b>CustomerReturnItemRelatedObj</b>.
         *
         * @param value
         *            The CustomerReturnItemRelatedObjs to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder relatedObject( CustomerReturnItemRelatedObj... value )
        {
            return toRelatedObject(Lists.newArrayList(value));
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toScheduleLine(
            final List<CustomerReturnScheduleLine> value )
        {
            toScheduleLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ScheduleLine</b> for <b>CustomerReturnItem</b> to multiple
         * <b>CustomerReturnScheduleLine</b>.
         *
         * @param value
         *            The CustomerReturnScheduleLines to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder scheduleLine( CustomerReturnScheduleLine... value )
        {
            return toScheduleLine(Lists.newArrayList(value));
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toSerialNumber(
            final List<CustomerReturnSerialNumber> value )
        {
            toSerialNumber.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SerialNumber</b> for <b>CustomerReturnItem</b> to multiple
         * <b>CustomerReturnSerialNumber</b>.
         *
         * @param value
         *            The CustomerReturnSerialNumbers to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder serialNumber( CustomerReturnSerialNumber... value )
        {
            return toSerialNumber(Lists.newArrayList(value));
        }

        private CustomerReturnItem.CustomerReturnItemBuilder toText( final List<CustomerReturnItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>CustomerReturnItem</b> to multiple <b>CustomerReturnItemText</b>.
         *
         * @param value
         *            The CustomerReturnItemTexts to build this CustomerReturnItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItem.CustomerReturnItemBuilder text( CustomerReturnItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
