/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem CustomerReturnItem}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class CustomerReturnItemByKeyFluentHelper
    extends
    FluentHelperByKey<CustomerReturnItemByKeyFluentHelper, CustomerReturnItem, CustomerReturnItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem CustomerReturnItem}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CustomerReturnItem}
     * @param customerReturnItem
     *            Customer Return Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CustomerReturnItem}
     * @param customerReturn
     *            Customer Return
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CustomerReturnItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String customerReturn,
        final String customerReturnItem )
    {
        super(servicePath, entityCollection);
        this.key.put("CustomerReturn", customerReturn);
        this.key.put("CustomerReturnItem", customerReturnItem);
    }

    @Override
    @Nonnull
    protected Class<CustomerReturnItem> getEntityClass()
    {
        return CustomerReturnItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
