/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnItemRelatedObjField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnItemRelatedObjOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnItemRelatedObjSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Related Object
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnItemRelatedObjType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnItemRelatedObj extends VdmEntity<CustomerReturnItemRelatedObj>
{

    /**
     * Selector for all available fields of CustomerReturnItemRelatedObj.
     *
     */
    public final static CustomerReturnItemRelatedObjSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> CUSTOMER_RETURN =
        new CustomerReturnItemRelatedObjField<String>("CustomerReturn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "CustomerReturnItem" )
    @JsonProperty( "CustomerReturnItem" )
    @Nullable
    @ODataField( odataName = "CustomerReturnItem" )
    private String customerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnItem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> CUSTOMER_RETURN_ITEM =
        new CustomerReturnItemRelatedObjField<String>("CustomerReturnItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSequenceNmbr</b>
     * </p>
     *
     * @return Sequence Number of the Related Object of an SD Document
     */
    @Key
    @SerializedName( "SDDocRelatedObjectSequenceNmbr" )
    @JsonProperty( "SDDocRelatedObjectSequenceNmbr" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectSequenceNmbr" )
    private String sDDocRelatedObjectSequenceNmbr;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectSequenceNmbr</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR =
        new CustomerReturnItemRelatedObjField<String>("SDDocRelatedObjectSequenceNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRelatedObjectType</b>
     * </p>
     *
     * @return Type of the Related Object of an SD Document
     */
    @SerializedName( "SDDocumentRelatedObjectType" )
    @JsonProperty( "SDDocumentRelatedObjectType" )
    @Nullable
    @ODataField( odataName = "SDDocumentRelatedObjectType" )
    private String sDDocumentRelatedObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentRelatedObjectType</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> SD_DOCUMENT_RELATED_OBJECT_TYPE =
        new CustomerReturnItemRelatedObjField<String>("SDDocumentRelatedObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSystem</b>
     * </p>
     *
     * @return System of the Related Object of an SD Document
     */
    @SerializedName( "SDDocRelatedObjectSystem" )
    @JsonProperty( "SDDocRelatedObjectSystem" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectSystem" )
    private String sDDocRelatedObjectSystem;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectSystem</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> SD_DOC_RELATED_OBJECT_SYSTEM =
        new CustomerReturnItemRelatedObjField<String>("SDDocRelatedObjectSystem");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference1</b>
     * </p>
     *
     * @return Reference of the Related Object of an SD Document
     */
    @SerializedName( "SDDocRelatedObjectReference1" )
    @JsonProperty( "SDDocRelatedObjectReference1" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectReference1" )
    private String sDDocRelatedObjectReference1;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectReference1</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> SD_DOC_RELATED_OBJECT_REFERENCE1 =
        new CustomerReturnItemRelatedObjField<String>("SDDocRelatedObjectReference1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference2</b>
     * </p>
     *
     * @return Reference of the Related Object of an SD Document
     */
    @SerializedName( "SDDocRelatedObjectReference2" )
    @JsonProperty( "SDDocRelatedObjectReference2" )
    @Nullable
    @ODataField( odataName = "SDDocRelatedObjectReference2" )
    private String sDDocRelatedObjectReference2;
    /**
     * Use with available fluent helpers to apply the <b>SDDocRelatedObjectReference2</b> field to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjField<String> SD_DOC_RELATED_OBJECT_REFERENCE2 =
        new CustomerReturnItemRelatedObjField<String>("SDDocRelatedObjectReference2");
    /**
     * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnItemRelatedObj</b> to single
     * <b>CustomerReturn</b>.
     *
     */
    @SerializedName( "to_CustomerReturn" )
    @JsonProperty( "to_CustomerReturn" )
    @ODataField( odataName = "to_CustomerReturn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturn toCustomerReturn;
    /**
     * Navigation property <b>to_CustomerReturnItem</b> for <b>CustomerReturnItemRelatedObj</b> to single
     * <b>CustomerReturnItem</b>.
     *
     */
    @SerializedName( "to_CustomerReturnItem" )
    @JsonProperty( "to_CustomerReturnItem" )
    @ODataField( odataName = "to_CustomerReturnItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturnItem toCustomerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturn</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnItemRelatedObjOneToOneLink<CustomerReturn> TO_CUSTOMER_RETURN =
        new CustomerReturnItemRelatedObjOneToOneLink<CustomerReturn>("to_CustomerReturn");
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturnItem</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerReturnItemRelatedObjOneToOneLink<CustomerReturnItem> TO_CUSTOMER_RETURN_ITEM =
        new CustomerReturnItemRelatedObjOneToOneLink<CustomerReturnItem>("to_CustomerReturnItem");

    @Nonnull
    @Override
    public Class<CustomerReturnItemRelatedObj> getType()
    {
        return CustomerReturnItemRelatedObj.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Sales Order
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @param customerReturnItem
     *            Sales Order Item
     */
    public void setCustomerReturnItem( @Nullable final String customerReturnItem )
    {
        rememberChangedField("CustomerReturnItem", this.customerReturnItem);
        this.customerReturnItem = customerReturnItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSequenceNmbr</b>
     * </p>
     *
     * @param sDDocRelatedObjectSequenceNmbr
     *            Sequence Number of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectSequenceNmbr( @Nullable final String sDDocRelatedObjectSequenceNmbr )
    {
        rememberChangedField("SDDocRelatedObjectSequenceNmbr", this.sDDocRelatedObjectSequenceNmbr);
        this.sDDocRelatedObjectSequenceNmbr = sDDocRelatedObjectSequenceNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRelatedObjectType</b>
     * </p>
     *
     * @param sDDocumentRelatedObjectType
     *            Type of the Related Object of an SD Document
     */
    public void setSDDocumentRelatedObjectType( @Nullable final String sDDocumentRelatedObjectType )
    {
        rememberChangedField("SDDocumentRelatedObjectType", this.sDDocumentRelatedObjectType);
        this.sDDocumentRelatedObjectType = sDDocumentRelatedObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectSystem</b>
     * </p>
     *
     * @param sDDocRelatedObjectSystem
     *            System of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectSystem( @Nullable final String sDDocRelatedObjectSystem )
    {
        rememberChangedField("SDDocRelatedObjectSystem", this.sDDocRelatedObjectSystem);
        this.sDDocRelatedObjectSystem = sDDocRelatedObjectSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference1</b>
     * </p>
     *
     * @param sDDocRelatedObjectReference1
     *            Reference of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectReference1( @Nullable final String sDDocRelatedObjectReference1 )
    {
        rememberChangedField("SDDocRelatedObjectReference1", this.sDDocRelatedObjectReference1);
        this.sDDocRelatedObjectReference1 = sDDocRelatedObjectReference1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SDDocRelatedObjectReference2</b>
     * </p>
     *
     * @param sDDocRelatedObjectReference2
     *            Reference of the Related Object of an SD Document
     */
    public void setSDDocRelatedObjectReference2( @Nullable final String sDDocRelatedObjectReference2 )
    {
        rememberChangedField("SDDocRelatedObjectReference2", this.sDDocRelatedObjectReference2);
        this.sDDocRelatedObjectReference2 = sDDocRelatedObjectReference2;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnItemRelatedObj";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        result.put("CustomerReturnItem", getCustomerReturnItem());
        result.put("SDDocRelatedObjectSequenceNmbr", getSDDocRelatedObjectSequenceNmbr());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("CustomerReturnItem", getCustomerReturnItem());
        values.put("SDDocRelatedObjectSequenceNmbr", getSDDocRelatedObjectSequenceNmbr());
        values.put("SDDocumentRelatedObjectType", getSDDocumentRelatedObjectType());
        values.put("SDDocRelatedObjectSystem", getSDDocRelatedObjectSystem());
        values.put("SDDocRelatedObjectReference1", getSDDocRelatedObjectReference1());
        values.put("SDDocRelatedObjectReference2", getSDDocRelatedObjectReference2());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnItem") ) {
                final Object value = values.remove("CustomerReturnItem");
                if( (value == null) || (!value.equals(getCustomerReturnItem())) ) {
                    setCustomerReturnItem(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectSequenceNmbr") ) {
                final Object value = values.remove("SDDocRelatedObjectSequenceNmbr");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectSequenceNmbr())) ) {
                    setSDDocRelatedObjectSequenceNmbr(((String) value));
                }
            }
            if( values.containsKey("SDDocumentRelatedObjectType") ) {
                final Object value = values.remove("SDDocumentRelatedObjectType");
                if( (value == null) || (!value.equals(getSDDocumentRelatedObjectType())) ) {
                    setSDDocumentRelatedObjectType(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectSystem") ) {
                final Object value = values.remove("SDDocRelatedObjectSystem");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectSystem())) ) {
                    setSDDocRelatedObjectSystem(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectReference1") ) {
                final Object value = values.remove("SDDocRelatedObjectReference1");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectReference1())) ) {
                    setSDDocRelatedObjectReference1(((String) value));
                }
            }
            if( values.containsKey("SDDocRelatedObjectReference2") ) {
                final Object value = values.remove("SDDocRelatedObjectReference2");
                if( (value == null) || (!value.equals(getSDDocRelatedObjectReference2())) ) {
                    setSDDocRelatedObjectReference2(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturn") ) {
                final Object value = (values).remove("to_CustomerReturn");
                if( value instanceof Map ) {
                    if( toCustomerReturn == null ) {
                        toCustomerReturn = new CustomerReturn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturn.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CustomerReturnItem") ) {
                final Object value = (values).remove("to_CustomerReturnItem");
                if( value instanceof Map ) {
                    if( toCustomerReturnItem == null ) {
                        toCustomerReturnItem = new CustomerReturnItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturnItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerReturnItemRelatedObjField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnItemRelatedObjField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnItemRelatedObjField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnItemRelatedObjField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturn != null ) {
            (values).put("to_CustomerReturn", toCustomerReturn);
        }
        if( toCustomerReturnItem != null ) {
            (values).put("to_CustomerReturnItem", toCustomerReturnItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturn</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerReturn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn fetchCustomerReturn()
    {
        return fetchFieldAsSingle("to_CustomerReturn", CustomerReturn.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturn</b> of a queried <b>CustomerReturnItemRelatedObj</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn getCustomerReturnOrFetch()
    {
        if( toCustomerReturn == null ) {
            toCustomerReturn = fetchCustomerReturn();
        }
        return toCustomerReturn;
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItemRelatedObj</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturn</b> is already loaded, the result will
     *         contain the <b>CustomerReturn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturn> getCustomerReturnIfPresent()
    {
        return Option.of(toCustomerReturn);
    }

    /**
     * Overwrites the associated <b>CustomerReturn</b> entity for the loaded navigation property
     * <b>to_CustomerReturn</b>.
     *
     * @param value
     *            New <b>CustomerReturn</b> entity.
     */
    public void setCustomerReturn( final CustomerReturn value )
    {
        toCustomerReturn = value;
    }

    /**
     * Fetches the <b>CustomerReturnItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CustomerReturnItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturnItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnItem fetchCustomerReturnItem()
    {
        return fetchFieldAsSingle("to_CustomerReturnItem", CustomerReturnItem.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturnItem</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturnItem</b> of a queried <b>CustomerReturnItemRelatedObj</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnItem getCustomerReturnItemOrFetch()
    {
        if( toCustomerReturnItem == null ) {
            toCustomerReturnItem = fetchCustomerReturnItem();
        }
        return toCustomerReturnItem;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturnItem</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnItemRelatedObj</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturnItem</b> is already loaded, the result
     *         will contain the <b>CustomerReturnItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturnItem> getCustomerReturnItemIfPresent()
    {
        return Option.of(toCustomerReturnItem);
    }

    /**
     * Overwrites the associated <b>CustomerReturnItem</b> entity for the loaded navigation property
     * <b>to_CustomerReturnItem</b>.
     *
     * @param value
     *            New <b>CustomerReturnItem</b> entity.
     */
    public void setCustomerReturnItem( final CustomerReturnItem value )
    {
        toCustomerReturnItem = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturnItemRelatedObj instances.
     *
     */
    public final static class CustomerReturnItemRelatedObjBuilder
    {

        private CustomerReturn toCustomerReturn;
        private String customerReturn = null;
        private CustomerReturnItem toCustomerReturnItem;
        private String customerReturnItem = null;

        private CustomerReturnItemRelatedObj.CustomerReturnItemRelatedObjBuilder toCustomerReturn(
            final CustomerReturn value )
        {
            toCustomerReturn = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnItemRelatedObj</b> to single
         * <b>CustomerReturn</b>.
         *
         * @param value
         *            The CustomerReturn to build this CustomerReturnItemRelatedObj with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItemRelatedObj.CustomerReturnItemRelatedObjBuilder customerReturn(
            final CustomerReturn value )
        {
            return toCustomerReturn(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturn</b>
         * </p>
         *
         * @param value
         *            The customerReturn to build this CustomerReturnItemRelatedObj with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItemRelatedObj.CustomerReturnItemRelatedObjBuilder customerReturn( final String value )
        {
            customerReturn = value;
            return this;
        }

        private CustomerReturnItemRelatedObj.CustomerReturnItemRelatedObjBuilder toCustomerReturnItem(
            final CustomerReturnItem value )
        {
            toCustomerReturnItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturnItem</b> for <b>CustomerReturnItemRelatedObj</b> to single
         * <b>CustomerReturnItem</b>.
         *
         * @param value
         *            The CustomerReturnItem to build this CustomerReturnItemRelatedObj with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItemRelatedObj.CustomerReturnItemRelatedObjBuilder customerReturnItem(
            final CustomerReturnItem value )
        {
            return toCustomerReturnItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
         * </p>
         *
         * @param value
         *            The customerReturnItem to build this CustomerReturnItemRelatedObj with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnItemRelatedObj.CustomerReturnItemRelatedObjBuilder customerReturnItem( final String value )
        {
            customerReturnItem = value;
            return this;
        }

    }

}
