/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnOverviewStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnOverviewStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Return Overview Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnOverviewStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnOverviewStatus extends VdmEntity<CustomerReturnOverviewStatus>
{

    /**
     * Selector for all available fields of CustomerReturnOverviewStatus.
     *
     */
    public final static CustomerReturnOverviewStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @return Process Identification Number
     */
    @Key
    @SerializedName( "RetsMgmtProcess" )
    @JsonProperty( "RetsMgmtProcess" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcess" )
    private String retsMgmtProcess;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcess</b> field to query operations.
     *
     */
    public final static CustomerReturnOverviewStatusField<String> RETS_MGMT_PROCESS =
        new CustomerReturnOverviewStatusField<String>("RetsMgmtProcess");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocument</b>
     * </p>
     *
     * @return Document Number
     */
    @SerializedName( "ReturnsDocument" )
    @JsonProperty( "ReturnsDocument" )
    @Nullable
    @ODataField( odataName = "ReturnsDocument" )
    private String returnsDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocument</b> field to query operations.
     *
     */
    public final static CustomerReturnOverviewStatusField<String> RETURNS_DOCUMENT =
        new CustomerReturnOverviewStatusField<String>("ReturnsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtLogProcgStatus</b>
     * </p>
     *
     * @return Logistical Processing Status of a Return
     */
    @SerializedName( "RetsMgmtLogProcgStatus" )
    @JsonProperty( "RetsMgmtLogProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtLogProcgStatus" )
    private String retsMgmtLogProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtLogProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnOverviewStatusField<String> RETS_MGMT_LOG_PROCG_STATUS =
        new CustomerReturnOverviewStatusField<String>("RetsMgmtLogProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtCompnProcgStatus</b>
     * </p>
     *
     * @return Status of Returns Refund Determination
     */
    @SerializedName( "RetsMgmtCompnProcgStatus" )
    @JsonProperty( "RetsMgmtCompnProcgStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtCompnProcgStatus" )
    private String retsMgmtCompnProcgStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtCompnProcgStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnOverviewStatusField<String> RETS_MGMT_COMPN_PROCG_STATUS =
        new CustomerReturnOverviewStatusField<String>("RetsMgmtCompnProcgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessingStatus</b>
     * </p>
     *
     * @return Processing Status
     */
    @SerializedName( "RetsMgmtProcessingStatus" )
    @JsonProperty( "RetsMgmtProcessingStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcessingStatus" )
    private String retsMgmtProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcessingStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnOverviewStatusField<String> RETS_MGMT_PROCESSING_STATUS =
        new CustomerReturnOverviewStatusField<String>("RetsMgmtProcessingStatus");

    @Nonnull
    @Override
    public Class<CustomerReturnOverviewStatus> getType()
    {
        return CustomerReturnOverviewStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @param retsMgmtProcess
     *            Process Identification Number
     */
    public void setRetsMgmtProcess( @Nullable final String retsMgmtProcess )
    {
        rememberChangedField("RetsMgmtProcess", this.retsMgmtProcess);
        this.retsMgmtProcess = retsMgmtProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocument</b>
     * </p>
     *
     * @param returnsDocument
     *            Document Number
     */
    public void setReturnsDocument( @Nullable final String returnsDocument )
    {
        rememberChangedField("ReturnsDocument", this.returnsDocument);
        this.returnsDocument = returnsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtLogProcgStatus</b>
     * </p>
     *
     * @param retsMgmtLogProcgStatus
     *            Logistical Processing Status of a Return
     */
    public void setRetsMgmtLogProcgStatus( @Nullable final String retsMgmtLogProcgStatus )
    {
        rememberChangedField("RetsMgmtLogProcgStatus", this.retsMgmtLogProcgStatus);
        this.retsMgmtLogProcgStatus = retsMgmtLogProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtCompnProcgStatus</b>
     * </p>
     *
     * @param retsMgmtCompnProcgStatus
     *            Status of Returns Refund Determination
     */
    public void setRetsMgmtCompnProcgStatus( @Nullable final String retsMgmtCompnProcgStatus )
    {
        rememberChangedField("RetsMgmtCompnProcgStatus", this.retsMgmtCompnProcgStatus);
        this.retsMgmtCompnProcgStatus = retsMgmtCompnProcgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessingStatus</b>
     * </p>
     *
     * @param retsMgmtProcessingStatus
     *            Processing Status
     */
    public void setRetsMgmtProcessingStatus( @Nullable final String retsMgmtProcessingStatus )
    {
        rememberChangedField("RetsMgmtProcessingStatus", this.retsMgmtProcessingStatus);
        this.retsMgmtProcessingStatus = retsMgmtProcessingStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnOverviewStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RetsMgmtProcess", getRetsMgmtProcess());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RetsMgmtProcess", getRetsMgmtProcess());
        values.put("ReturnsDocument", getReturnsDocument());
        values.put("RetsMgmtLogProcgStatus", getRetsMgmtLogProcgStatus());
        values.put("RetsMgmtCompnProcgStatus", getRetsMgmtCompnProcgStatus());
        values.put("RetsMgmtProcessingStatus", getRetsMgmtProcessingStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RetsMgmtProcess") ) {
                final Object value = values.remove("RetsMgmtProcess");
                if( (value == null) || (!value.equals(getRetsMgmtProcess())) ) {
                    setRetsMgmtProcess(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocument") ) {
                final Object value = values.remove("ReturnsDocument");
                if( (value == null) || (!value.equals(getReturnsDocument())) ) {
                    setReturnsDocument(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtLogProcgStatus") ) {
                final Object value = values.remove("RetsMgmtLogProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtLogProcgStatus())) ) {
                    setRetsMgmtLogProcgStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtCompnProcgStatus") ) {
                final Object value = values.remove("RetsMgmtCompnProcgStatus");
                if( (value == null) || (!value.equals(getRetsMgmtCompnProcgStatus())) ) {
                    setRetsMgmtCompnProcgStatus(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcessingStatus") ) {
                final Object value = values.remove("RetsMgmtProcessingStatus");
                if( (value == null) || (!value.equals(getRetsMgmtProcessingStatus())) ) {
                    setRetsMgmtProcessingStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerReturnOverviewStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnOverviewStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnOverviewStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnOverviewStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

}
