/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnOverviewStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
 * CustomerReturnOverviewStatus} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CustomerReturnOverviewStatusByKeyFluentHelper
    extends
    FluentHelperByKey<CustomerReturnOverviewStatusByKeyFluentHelper, CustomerReturnOverviewStatus, CustomerReturnOverviewStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
     * CustomerReturnOverviewStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CustomerReturnOverviewStatus}
     * @param retsMgmtProcess
     *            Process Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CustomerReturnOverviewStatus}
     */
    public CustomerReturnOverviewStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String retsMgmtProcess )
    {
        super(servicePath, entityCollection);
        this.key.put("RetsMgmtProcess", retsMgmtProcess);
    }

    @Override
    @Nonnull
    protected Class<CustomerReturnOverviewStatus> getEntityClass()
    {
        return CustomerReturnOverviewStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
