/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnPrcgElmntField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnPrcgElmntOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnPrcgElmntSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Pricing Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnPrcgElmntType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnPrcgElmnt extends VdmEntity<CustomerReturnPrcgElmnt>
{

    /**
     * Selector for all available fields of CustomerReturnPrcgElmnt.
     *
     */
    public final static CustomerReturnPrcgElmntSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CUSTOMER_RETURN =
        new CustomerReturnPrcgElmntField<String>("CustomerReturn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> PRICING_PROCEDURE_STEP =
        new CustomerReturnPrcgElmntField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> PRICING_PROCEDURE_COUNTER =
        new CustomerReturnPrcgElmntField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_TYPE =
        new CustomerReturnPrcgElmntField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateTime</b>
     * </p>
     *
     * @return Timestamp for Pricing
     */
    @SerializedName( "PricingDateTime" )
    @JsonProperty( "PricingDateTime" )
    @Nullable
    @ODataField( odataName = "PricingDateTime" )
    private String pricingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PricingDateTime</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> PRICING_DATE_TIME =
        new CustomerReturnPrcgElmntField<String>("PricingDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_CALCULATION_TYPE =
        new CustomerReturnPrcgElmntField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseValue</b>
     * </p>
     *
     * @return Condition Basis
     */
    @SerializedName( "ConditionBaseValue" )
    @JsonProperty( "ConditionBaseValue" )
    @Nullable
    @ODataField( odataName = "ConditionBaseValue" )
    private BigDecimal conditionBaseValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionBaseValue</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<BigDecimal> CONDITION_BASE_VALUE =
        new CustomerReturnPrcgElmntField<BigDecimal>("ConditionBaseValue");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<BigDecimal> CONDITION_RATE_VALUE =
        new CustomerReturnPrcgElmntField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_CURRENCY =
        new CustomerReturnPrcgElmntField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<BigDecimal> CONDITION_QUANTITY =
        new CustomerReturnPrcgElmntField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit in the Document
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_QUANTITY_UNIT =
        new CustomerReturnPrcgElmntField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @return Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    @SerializedName( "ConditionCategory" )
    @JsonProperty( "ConditionCategory" )
    @Nullable
    @ODataField( odataName = "ConditionCategory" )
    private String conditionCategory;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCategory</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_CATEGORY =
        new CustomerReturnPrcgElmntField<String>("ConditionCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @return Condition is used for statistics
     */
    @SerializedName( "ConditionIsForStatistics" )
    @JsonProperty( "ConditionIsForStatistics" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForStatistics" )
    private Boolean conditionIsForStatistics;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForStatistics</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<Boolean> CONDITION_IS_FOR_STATISTICS =
        new CustomerReturnPrcgElmntField<Boolean>("ConditionIsForStatistics");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> PRICING_SCALE_TYPE =
        new CustomerReturnPrcgElmntField<String>("PricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     *
     * @return Origin of the Condition
     */
    @SerializedName( "ConditionOrigin" )
    @JsonProperty( "ConditionOrigin" )
    @Nullable
    @ODataField( odataName = "ConditionOrigin" )
    private String conditionOrigin;
    /**
     * Use with available fluent helpers to apply the <b>ConditionOrigin</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_ORIGIN =
        new CustomerReturnPrcgElmntField<String>("ConditionOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @return Group Condition
     */
    @SerializedName( "IsGroupCondition" )
    @JsonProperty( "IsGroupCondition" )
    @Nullable
    @ODataField( odataName = "IsGroupCondition" )
    private String isGroupCondition;
    /**
     * Use with available fluent helpers to apply the <b>IsGroupCondition</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> IS_GROUP_CONDITION =
        new CustomerReturnPrcgElmntField<String>("IsGroupCondition");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_RECORD =
        new CustomerReturnPrcgElmntField<String>("ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential Number of the Condition
     */
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_SEQUENTIAL_NUMBER =
        new CustomerReturnPrcgElmntField<String>("ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> TAX_CODE =
        new CustomerReturnPrcgElmntField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @return Withholding tax code
     */
    @SerializedName( "WithholdingTaxCode" )
    @JsonProperty( "WithholdingTaxCode" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxCode" )
    private String withholdingTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxCode</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> WITHHOLDING_TAX_CODE =
        new CustomerReturnPrcgElmntField<String>("WithholdingTaxCode");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnRoundingOffDiffAmount</b>
     * </p>
     *
     * @return Rounding-Off Difference of the Condition
     */
    @SerializedName( "CndnRoundingOffDiffAmount" )
    @JsonProperty( "CndnRoundingOffDiffAmount" )
    @Nullable
    @ODataField( odataName = "CndnRoundingOffDiffAmount" )
    private BigDecimal cndnRoundingOffDiffAmount;
    /**
     * Use with available fluent helpers to apply the <b>CndnRoundingOffDiffAmount</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<BigDecimal> CNDN_ROUNDING_OFF_DIFF_AMOUNT =
        new CustomerReturnPrcgElmntField<BigDecimal>("CndnRoundingOffDiffAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     *
     * @return Condition Value
     */
    @SerializedName( "ConditionAmount" )
    @JsonProperty( "ConditionAmount" )
    @Nullable
    @ODataField( odataName = "ConditionAmount" )
    private BigDecimal conditionAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAmount</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<BigDecimal> CONDITION_AMOUNT =
        new CustomerReturnPrcgElmntField<BigDecimal>("ConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> TRANSACTION_CURRENCY =
        new CustomerReturnPrcgElmntField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     *
     * @return Condition Control
     */
    @SerializedName( "ConditionControl" )
    @JsonProperty( "ConditionControl" )
    @Nullable
    @ODataField( odataName = "ConditionControl" )
    private String conditionControl;
    /**
     * Use with available fluent helpers to apply the <b>ConditionControl</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_CONTROL =
        new CustomerReturnPrcgElmntField<String>("ConditionControl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @return Condition is Inactive
     */
    @SerializedName( "ConditionInactiveReason" )
    @JsonProperty( "ConditionInactiveReason" )
    @Nullable
    @ODataField( odataName = "ConditionInactiveReason" )
    private String conditionInactiveReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionInactiveReason</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_INACTIVE_REASON =
        new CustomerReturnPrcgElmntField<String>("ConditionInactiveReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @return Condition Class
     */
    @SerializedName( "ConditionClass" )
    @JsonProperty( "ConditionClass" )
    @Nullable
    @ODataField( odataName = "ConditionClass" )
    private String conditionClass;
    /**
     * Use with available fluent helpers to apply the <b>ConditionClass</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_CLASS =
        new CustomerReturnPrcgElmntField<String>("ConditionClass");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedureCounterForHeader</b>
     * </p>
     *
     * @return Condition Counter (Header)
     */
    @SerializedName( "PrcgProcedureCounterForHeader" )
    @JsonProperty( "PrcgProcedureCounterForHeader" )
    @Nullable
    @ODataField( odataName = "PrcgProcedureCounterForHeader" )
    private String prcgProcedureCounterForHeader;
    /**
     * Use with available fluent helpers to apply the <b>PrcgProcedureCounterForHeader</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> PRCG_PROCEDURE_COUNTER_FOR_HEADER =
        new CustomerReturnPrcgElmntField<String>("PrcgProcedureCounterForHeader");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     *
     * @return Factor for Condition Base Value
     */
    @SerializedName( "FactorForConditionBasisValue" )
    @JsonProperty( "FactorForConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "FactorForConditionBasisValue" )
    private Double factorForConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>FactorForConditionBasisValue</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<Double> FACTOR_FOR_CONDITION_BASIS_VALUE =
        new CustomerReturnPrcgElmntField<Double>("FactorForConditionBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     *
     * @return Structure Condition
     */
    @SerializedName( "StructureCondition" )
    @JsonProperty( "StructureCondition" )
    @Nullable
    @ODataField( odataName = "StructureCondition" )
    private String structureCondition;
    /**
     * Use with available fluent helpers to apply the <b>StructureCondition</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> STRUCTURE_CONDITION =
        new CustomerReturnPrcgElmntField<String>("StructureCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PeriodFactorForCndnBasisValue</b>
     * </p>
     *
     * @return Factor for Condition Basis (Period)
     */
    @SerializedName( "PeriodFactorForCndnBasisValue" )
    @JsonProperty( "PeriodFactorForCndnBasisValue" )
    @Nullable
    @ODataField( odataName = "PeriodFactorForCndnBasisValue" )
    private Double periodFactorForCndnBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>PeriodFactorForCndnBasisValue</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<Double> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE =
        new CustomerReturnPrcgElmntField<Double>("PeriodFactorForCndnBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @return Scale Basis Indicator
     */
    @SerializedName( "PricingScaleBasis" )
    @JsonProperty( "PricingScaleBasis" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasis" )
    private String pricingScaleBasis;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasis</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> PRICING_SCALE_BASIS =
        new CustomerReturnPrcgElmntField<String>("PricingScaleBasis");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @return Scale Base Value
     */
    @SerializedName( "ConditionScaleBasisValue" )
    @JsonProperty( "ConditionScaleBasisValue" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisValue" )
    private BigDecimal conditionScaleBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisValue</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<BigDecimal> CONDITION_SCALE_BASIS_VALUE =
        new CustomerReturnPrcgElmntField<BigDecimal>("ConditionScaleBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleBasisUnit" )
    @JsonProperty( "ConditionScaleBasisUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisUnit" )
    private String conditionScaleBasisUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_SCALE_BASIS_UNIT =
        new CustomerReturnPrcgElmntField<String>("ConditionScaleBasisUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleBasisCurrency" )
    @JsonProperty( "ConditionScaleBasisCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisCurrency" )
    private String conditionScaleBasisCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisCurrency</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> CONDITION_SCALE_BASIS_CURRENCY =
        new CustomerReturnPrcgElmntField<String>("ConditionScaleBasisCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @return Condition for Intercompany Billing
     */
    @SerializedName( "CndnIsRelevantForIntcoBilling" )
    @JsonProperty( "CndnIsRelevantForIntcoBilling" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsRelevantForIntcoBilling" )
    private Boolean cndnIsRelevantForIntcoBilling;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForIntcoBilling</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<Boolean> CNDN_IS_RELEVANT_FOR_INTCO_BILLING =
        new CustomerReturnPrcgElmntField<Boolean>("CndnIsRelevantForIntcoBilling");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     *
     * @return Condition Changed Manually
     */
    @SerializedName( "ConditionIsManuallyChanged" )
    @JsonProperty( "ConditionIsManuallyChanged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsManuallyChanged" )
    private Boolean conditionIsManuallyChanged;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsManuallyChanged</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<Boolean> CONDITION_IS_MANUALLY_CHANGED =
        new CustomerReturnPrcgElmntField<Boolean>("ConditionIsManuallyChanged");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     *
     * @return Condition Used for Variant Configuration
     */
    @SerializedName( "ConditionIsForConfiguration" )
    @JsonProperty( "ConditionIsForConfiguration" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForConfiguration" )
    private Boolean conditionIsForConfiguration;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForConfiguration</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<Boolean> CONDITION_IS_FOR_CONFIGURATION =
        new CustomerReturnPrcgElmntField<Boolean>("ConditionIsForConfiguration");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @return Variant Condition Key
     */
    @SerializedName( "VariantCondition" )
    @JsonProperty( "VariantCondition" )
    @Nullable
    @ODataField( odataName = "VariantCondition" )
    private String variantCondition;
    /**
     * Use with available fluent helpers to apply the <b>VariantCondition</b> field to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntField<String> VARIANT_CONDITION =
        new CustomerReturnPrcgElmntField<String>("VariantCondition");
    /**
     * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnPrcgElmnt</b> to single <b>CustomerReturn</b>.
     *
     */
    @SerializedName( "to_CustomerReturn" )
    @JsonProperty( "to_CustomerReturn" )
    @ODataField( odataName = "to_CustomerReturn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturn toCustomerReturn;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturn</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnPrcgElmntOneToOneLink<CustomerReturn> TO_CUSTOMER_RETURN =
        new CustomerReturnPrcgElmntOneToOneLink<CustomerReturn>("to_CustomerReturn");

    @Nonnull
    @Override
    public Class<CustomerReturnPrcgElmnt> getType()
    {
        return CustomerReturnPrcgElmnt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Sales Document
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateTime</b>
     * </p>
     *
     * @param pricingDateTime
     *            Timestamp for Pricing
     */
    public void setPricingDateTime( @Nullable final String pricingDateTime )
    {
        rememberChangedField("PricingDateTime", this.pricingDateTime);
        this.pricingDateTime = pricingDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseValue</b>
     * </p>
     *
     * @param conditionBaseValue
     *            Condition Basis
     */
    public void setConditionBaseValue( @Nullable final BigDecimal conditionBaseValue )
    {
        rememberChangedField("ConditionBaseValue", this.conditionBaseValue);
        this.conditionBaseValue = conditionBaseValue;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Currency Key
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit in the Document
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @param conditionCategory
     *            Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    public void setConditionCategory( @Nullable final String conditionCategory )
    {
        rememberChangedField("ConditionCategory", this.conditionCategory);
        this.conditionCategory = conditionCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @param conditionIsForStatistics
     *            Condition is used for statistics
     */
    public void setConditionIsForStatistics( @Nullable final Boolean conditionIsForStatistics )
    {
        rememberChangedField("ConditionIsForStatistics", this.conditionIsForStatistics);
        this.conditionIsForStatistics = conditionIsForStatistics;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     *
     * @param conditionOrigin
     *            Origin of the Condition
     */
    public void setConditionOrigin( @Nullable final String conditionOrigin )
    {
        rememberChangedField("ConditionOrigin", this.conditionOrigin);
        this.conditionOrigin = conditionOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @param isGroupCondition
     *            Group Condition
     */
    public void setIsGroupCondition( @Nullable final String isGroupCondition )
    {
        rememberChangedField("IsGroupCondition", this.isGroupCondition);
        this.isGroupCondition = isGroupCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential Number of the Condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @param withholdingTaxCode
     *            Withholding tax code
     */
    public void setWithholdingTaxCode( @Nullable final String withholdingTaxCode )
    {
        rememberChangedField("WithholdingTaxCode", this.withholdingTaxCode);
        this.withholdingTaxCode = withholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnRoundingOffDiffAmount</b>
     * </p>
     *
     * @param cndnRoundingOffDiffAmount
     *            Rounding-Off Difference of the Condition
     */
    public void setCndnRoundingOffDiffAmount( @Nullable final BigDecimal cndnRoundingOffDiffAmount )
    {
        rememberChangedField("CndnRoundingOffDiffAmount", this.cndnRoundingOffDiffAmount);
        this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     *
     * @param conditionAmount
     *            Condition Value
     */
    public void setConditionAmount( @Nullable final BigDecimal conditionAmount )
    {
        rememberChangedField("ConditionAmount", this.conditionAmount);
        this.conditionAmount = conditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     *
     * @param conditionControl
     *            Condition Control
     */
    public void setConditionControl( @Nullable final String conditionControl )
    {
        rememberChangedField("ConditionControl", this.conditionControl);
        this.conditionControl = conditionControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @param conditionInactiveReason
     *            Condition is Inactive
     */
    public void setConditionInactiveReason( @Nullable final String conditionInactiveReason )
    {
        rememberChangedField("ConditionInactiveReason", this.conditionInactiveReason);
        this.conditionInactiveReason = conditionInactiveReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @param conditionClass
     *            Condition Class
     */
    public void setConditionClass( @Nullable final String conditionClass )
    {
        rememberChangedField("ConditionClass", this.conditionClass);
        this.conditionClass = conditionClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedureCounterForHeader</b>
     * </p>
     *
     * @param prcgProcedureCounterForHeader
     *            Condition Counter (Header)
     */
    public void setPrcgProcedureCounterForHeader( @Nullable final String prcgProcedureCounterForHeader )
    {
        rememberChangedField("PrcgProcedureCounterForHeader", this.prcgProcedureCounterForHeader);
        this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     *
     * @param factorForConditionBasisValue
     *            Factor for Condition Base Value
     */
    public void setFactorForConditionBasisValue( @Nullable final Double factorForConditionBasisValue )
    {
        rememberChangedField("FactorForConditionBasisValue", this.factorForConditionBasisValue);
        this.factorForConditionBasisValue = factorForConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     *
     * @param structureCondition
     *            Structure Condition
     */
    public void setStructureCondition( @Nullable final String structureCondition )
    {
        rememberChangedField("StructureCondition", this.structureCondition);
        this.structureCondition = structureCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PeriodFactorForCndnBasisValue</b>
     * </p>
     *
     * @param periodFactorForCndnBasisValue
     *            Factor for Condition Basis (Period)
     */
    public void setPeriodFactorForCndnBasisValue( @Nullable final Double periodFactorForCndnBasisValue )
    {
        rememberChangedField("PeriodFactorForCndnBasisValue", this.periodFactorForCndnBasisValue);
        this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @param pricingScaleBasis
     *            Scale Basis Indicator
     */
    public void setPricingScaleBasis( @Nullable final String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @param conditionScaleBasisValue
     *            Scale Base Value
     */
    public void setConditionScaleBasisValue( @Nullable final BigDecimal conditionScaleBasisValue )
    {
        rememberChangedField("ConditionScaleBasisValue", this.conditionScaleBasisValue);
        this.conditionScaleBasisValue = conditionScaleBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     *
     * @param conditionScaleBasisUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleBasisUnit( @Nullable final String conditionScaleBasisUnit )
    {
        rememberChangedField("ConditionScaleBasisUnit", this.conditionScaleBasisUnit);
        this.conditionScaleBasisUnit = conditionScaleBasisUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     *
     * @param conditionScaleBasisCurrency
     *            Scale Currency
     */
    public void setConditionScaleBasisCurrency( @Nullable final String conditionScaleBasisCurrency )
    {
        rememberChangedField("ConditionScaleBasisCurrency", this.conditionScaleBasisCurrency);
        this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @param cndnIsRelevantForIntcoBilling
     *            Condition for Intercompany Billing
     */
    public void setCndnIsRelevantForIntcoBilling( @Nullable final Boolean cndnIsRelevantForIntcoBilling )
    {
        rememberChangedField("CndnIsRelevantForIntcoBilling", this.cndnIsRelevantForIntcoBilling);
        this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     *
     * @param conditionIsManuallyChanged
     *            Condition Changed Manually
     */
    public void setConditionIsManuallyChanged( @Nullable final Boolean conditionIsManuallyChanged )
    {
        rememberChangedField("ConditionIsManuallyChanged", this.conditionIsManuallyChanged);
        this.conditionIsManuallyChanged = conditionIsManuallyChanged;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     *
     * @param conditionIsForConfiguration
     *            Condition Used for Variant Configuration
     */
    public void setConditionIsForConfiguration( @Nullable final Boolean conditionIsForConfiguration )
    {
        rememberChangedField("ConditionIsForConfiguration", this.conditionIsForConfiguration);
        this.conditionIsForConfiguration = conditionIsForConfiguration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @param variantCondition
     *            Variant Condition Key
     */
    public void setVariantCondition( @Nullable final String variantCondition )
    {
        rememberChangedField("VariantCondition", this.variantCondition);
        this.variantCondition = variantCondition;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnPrcgElmnt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionType", getConditionType());
        values.put("PricingDateTime", getPricingDateTime());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionBaseValue", getConditionBaseValue());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionCategory", getConditionCategory());
        values.put("ConditionIsForStatistics", getConditionIsForStatistics());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("ConditionOrigin", getConditionOrigin());
        values.put("IsGroupCondition", getIsGroupCondition());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("TaxCode", getTaxCode());
        values.put("WithholdingTaxCode", getWithholdingTaxCode());
        values.put("CndnRoundingOffDiffAmount", getCndnRoundingOffDiffAmount());
        values.put("ConditionAmount", getConditionAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ConditionControl", getConditionControl());
        values.put("ConditionInactiveReason", getConditionInactiveReason());
        values.put("ConditionClass", getConditionClass());
        values.put("PrcgProcedureCounterForHeader", getPrcgProcedureCounterForHeader());
        values.put("FactorForConditionBasisValue", getFactorForConditionBasisValue());
        values.put("StructureCondition", getStructureCondition());
        values.put("PeriodFactorForCndnBasisValue", getPeriodFactorForCndnBasisValue());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionScaleBasisValue", getConditionScaleBasisValue());
        values.put("ConditionScaleBasisUnit", getConditionScaleBasisUnit());
        values.put("ConditionScaleBasisCurrency", getConditionScaleBasisCurrency());
        values.put("CndnIsRelevantForIntcoBilling", getCndnIsRelevantForIntcoBilling());
        values.put("ConditionIsManuallyChanged", getConditionIsManuallyChanged());
        values.put("ConditionIsForConfiguration", getConditionIsForConfiguration());
        values.put("VariantCondition", getVariantCondition());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("PricingDateTime") ) {
                final Object value = values.remove("PricingDateTime");
                if( (value == null) || (!value.equals(getPricingDateTime())) ) {
                    setPricingDateTime(((String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionBaseValue") ) {
                final Object value = values.remove("ConditionBaseValue");
                if( (value == null) || (!value.equals(getConditionBaseValue())) ) {
                    setConditionBaseValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionCategory") ) {
                final Object value = values.remove("ConditionCategory");
                if( (value == null) || (!value.equals(getConditionCategory())) ) {
                    setConditionCategory(((String) value));
                }
            }
            if( values.containsKey("ConditionIsForStatistics") ) {
                final Object value = values.remove("ConditionIsForStatistics");
                if( (value == null) || (!value.equals(getConditionIsForStatistics())) ) {
                    setConditionIsForStatistics(((Boolean) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("ConditionOrigin") ) {
                final Object value = values.remove("ConditionOrigin");
                if( (value == null) || (!value.equals(getConditionOrigin())) ) {
                    setConditionOrigin(((String) value));
                }
            }
            if( values.containsKey("IsGroupCondition") ) {
                final Object value = values.remove("IsGroupCondition");
                if( (value == null) || (!value.equals(getIsGroupCondition())) ) {
                    setIsGroupCondition(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCode") ) {
                final Object value = values.remove("WithholdingTaxCode");
                if( (value == null) || (!value.equals(getWithholdingTaxCode())) ) {
                    setWithholdingTaxCode(((String) value));
                }
            }
            if( values.containsKey("CndnRoundingOffDiffAmount") ) {
                final Object value = values.remove("CndnRoundingOffDiffAmount");
                if( (value == null) || (!value.equals(getCndnRoundingOffDiffAmount())) ) {
                    setCndnRoundingOffDiffAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAmount") ) {
                final Object value = values.remove("ConditionAmount");
                if( (value == null) || (!value.equals(getConditionAmount())) ) {
                    setConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionControl") ) {
                final Object value = values.remove("ConditionControl");
                if( (value == null) || (!value.equals(getConditionControl())) ) {
                    setConditionControl(((String) value));
                }
            }
            if( values.containsKey("ConditionInactiveReason") ) {
                final Object value = values.remove("ConditionInactiveReason");
                if( (value == null) || (!value.equals(getConditionInactiveReason())) ) {
                    setConditionInactiveReason(((String) value));
                }
            }
            if( values.containsKey("ConditionClass") ) {
                final Object value = values.remove("ConditionClass");
                if( (value == null) || (!value.equals(getConditionClass())) ) {
                    setConditionClass(((String) value));
                }
            }
            if( values.containsKey("PrcgProcedureCounterForHeader") ) {
                final Object value = values.remove("PrcgProcedureCounterForHeader");
                if( (value == null) || (!value.equals(getPrcgProcedureCounterForHeader())) ) {
                    setPrcgProcedureCounterForHeader(((String) value));
                }
            }
            if( values.containsKey("FactorForConditionBasisValue") ) {
                final Object value = values.remove("FactorForConditionBasisValue");
                if( (value == null) || (!value.equals(getFactorForConditionBasisValue())) ) {
                    setFactorForConditionBasisValue(((Double) value));
                }
            }
            if( values.containsKey("StructureCondition") ) {
                final Object value = values.remove("StructureCondition");
                if( (value == null) || (!value.equals(getStructureCondition())) ) {
                    setStructureCondition(((String) value));
                }
            }
            if( values.containsKey("PeriodFactorForCndnBasisValue") ) {
                final Object value = values.remove("PeriodFactorForCndnBasisValue");
                if( (value == null) || (!value.equals(getPeriodFactorForCndnBasisValue())) ) {
                    setPeriodFactorForCndnBasisValue(((Double) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisValue") ) {
                final Object value = values.remove("ConditionScaleBasisValue");
                if( (value == null) || (!value.equals(getConditionScaleBasisValue())) ) {
                    setConditionScaleBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisUnit") ) {
                final Object value = values.remove("ConditionScaleBasisUnit");
                if( (value == null) || (!value.equals(getConditionScaleBasisUnit())) ) {
                    setConditionScaleBasisUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisCurrency") ) {
                final Object value = values.remove("ConditionScaleBasisCurrency");
                if( (value == null) || (!value.equals(getConditionScaleBasisCurrency())) ) {
                    setConditionScaleBasisCurrency(((String) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForIntcoBilling") ) {
                final Object value = values.remove("CndnIsRelevantForIntcoBilling");
                if( (value == null) || (!value.equals(getCndnIsRelevantForIntcoBilling())) ) {
                    setCndnIsRelevantForIntcoBilling(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionIsManuallyChanged") ) {
                final Object value = values.remove("ConditionIsManuallyChanged");
                if( (value == null) || (!value.equals(getConditionIsManuallyChanged())) ) {
                    setConditionIsManuallyChanged(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionIsForConfiguration") ) {
                final Object value = values.remove("ConditionIsForConfiguration");
                if( (value == null) || (!value.equals(getConditionIsForConfiguration())) ) {
                    setConditionIsForConfiguration(((Boolean) value));
                }
            }
            if( values.containsKey("VariantCondition") ) {
                final Object value = values.remove("VariantCondition");
                if( (value == null) || (!value.equals(getVariantCondition())) ) {
                    setVariantCondition(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturn") ) {
                final Object value = (values).remove("to_CustomerReturn");
                if( value instanceof Map ) {
                    if( toCustomerReturn == null ) {
                        toCustomerReturn = new CustomerReturn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturn.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerReturnPrcgElmntField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnPrcgElmntField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnPrcgElmntField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnPrcgElmntField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturn != null ) {
            (values).put("to_CustomerReturn", toCustomerReturn);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturn</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerReturn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn fetchCustomerReturn()
    {
        return fetchFieldAsSingle("to_CustomerReturn", CustomerReturn.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturn</b> of a queried <b>CustomerReturnPrcgElmnt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn getCustomerReturnOrFetch()
    {
        if( toCustomerReturn == null ) {
            toCustomerReturn = fetchCustomerReturn();
        }
        return toCustomerReturn;
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnPrcgElmnt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturn</b> is already loaded, the result will
     *         contain the <b>CustomerReturn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturn> getCustomerReturnIfPresent()
    {
        return Option.of(toCustomerReturn);
    }

    /**
     * Overwrites the associated <b>CustomerReturn</b> entity for the loaded navigation property
     * <b>to_CustomerReturn</b>.
     *
     * @param value
     *            New <b>CustomerReturn</b> entity.
     */
    public void setCustomerReturn( final CustomerReturn value )
    {
        toCustomerReturn = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturnPrcgElmnt instances.
     *
     */
    public final static class CustomerReturnPrcgElmntBuilder
    {

        private CustomerReturn toCustomerReturn;
        private String customerReturn = null;

        private CustomerReturnPrcgElmnt.CustomerReturnPrcgElmntBuilder toCustomerReturn( final CustomerReturn value )
        {
            toCustomerReturn = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnPrcgElmnt</b> to single
         * <b>CustomerReturn</b>.
         *
         * @param value
         *            The CustomerReturn to build this CustomerReturnPrcgElmnt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnPrcgElmnt.CustomerReturnPrcgElmntBuilder customerReturn( final CustomerReturn value )
        {
            return toCustomerReturn(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturn</b>
         * </p>
         *
         * @param value
         *            The customerReturn to build this CustomerReturnPrcgElmnt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnPrcgElmnt.CustomerReturnPrcgElmntBuilder customerReturn( final String value )
        {
            customerReturn = value;
            return this;
        }

    }

}
