/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnProcessStepField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnProcessStepOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnProcessStepSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Return Process Step
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnProcessStepType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnProcessStep extends VdmEntity<CustomerReturnProcessStep>
{

    /**
     * Selector for all available fields of CustomerReturnProcessStep.
     *
     */
    public final static CustomerReturnProcessStepSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @return Process Identification Number
     */
    @Key
    @SerializedName( "RetsMgmtProcess" )
    @JsonProperty( "RetsMgmtProcess" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcess" )
    private String retsMgmtProcess;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcess</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETS_MGMT_PROCESS =
        new CustomerReturnProcessStepField<String>("RetsMgmtProcess");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessItem</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "RetsMgmtProcessItem" )
    @JsonProperty( "RetsMgmtProcessItem" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcessItem" )
    private String retsMgmtProcessItem;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcessItem</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETS_MGMT_PROCESS_ITEM =
        new CustomerReturnProcessStepField<String>("RetsMgmtProcessItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcItmQtySplit</b>
     * </p>
     *
     * @return Split Identification Number
     */
    @Key
    @SerializedName( "RetsMgmtProcItmQtySplit" )
    @JsonProperty( "RetsMgmtProcItmQtySplit" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcItmQtySplit" )
    private String retsMgmtProcItmQtySplit;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcItmQtySplit</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETS_MGMT_PROC_ITM_QTY_SPLIT =
        new CustomerReturnProcessStepField<String>("RetsMgmtProcItmQtySplit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessStep</b>
     * </p>
     *
     * @return Step ID
     */
    @Key
    @SerializedName( "RetsMgmtProcessStep" )
    @JsonProperty( "RetsMgmtProcessStep" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcessStep" )
    private String retsMgmtProcessStep;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcessStep</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETS_MGMT_PROCESS_STEP =
        new CustomerReturnProcessStepField<String>("RetsMgmtProcessStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "ReturnsDocumentType" )
    @JsonProperty( "ReturnsDocumentType" )
    @Nullable
    @ODataField( odataName = "ReturnsDocumentType" )
    private String returnsDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocumentType</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_DOCUMENT_TYPE =
        new CustomerReturnProcessStepField<String>("ReturnsDocumentType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocument</b>
     * </p>
     *
     * @return Document Number
     */
    @Key
    @SerializedName( "ReturnsDocument" )
    @JsonProperty( "ReturnsDocument" )
    @Nullable
    @ODataField( odataName = "ReturnsDocument" )
    private String returnsDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocument</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_DOCUMENT =
        new CustomerReturnProcessStepField<String>("ReturnsDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentItem</b>
     * </p>
     *
     * @return Document Item
     */
    @Key
    @SerializedName( "ReturnsDocumentItem" )
    @JsonProperty( "ReturnsDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReturnsDocumentItem" )
    private String returnsDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocumentItem</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_DOCUMENT_ITEM =
        new CustomerReturnProcessStepField<String>("ReturnsDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentStatus</b>
     * </p>
     *
     * @return Status of Document Item
     */
    @SerializedName( "ReturnsDocumentStatus" )
    @JsonProperty( "ReturnsDocumentStatus" )
    @Nullable
    @ODataField( odataName = "ReturnsDocumentStatus" )
    private String returnsDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocumentStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_DOCUMENT_STATUS =
        new CustomerReturnProcessStepField<String>("ReturnsDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentApprovalStatus</b>
     * </p>
     *
     * @return Approval Status of Returns Process
     */
    @SerializedName( "ReturnsDocumentApprovalStatus" )
    @JsonProperty( "ReturnsDocumentApprovalStatus" )
    @Nullable
    @ODataField( odataName = "ReturnsDocumentApprovalStatus" )
    private String returnsDocumentApprovalStatus;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsDocumentApprovalStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_DOCUMENT_APPROVAL_STATUS =
        new CustomerReturnProcessStepField<String>("ReturnsDocumentApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsReferenceDocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "ReturnsReferenceDocumentType" )
    @JsonProperty( "ReturnsReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReturnsReferenceDocumentType" )
    private String returnsReferenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsReferenceDocumentType</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_REFERENCE_DOCUMENT_TYPE =
        new CustomerReturnProcessStepField<String>("ReturnsReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsReferenceDocument</b>
     * </p>
     *
     * @return Document Number
     */
    @SerializedName( "ReturnsReferenceDocument" )
    @JsonProperty( "ReturnsReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReturnsReferenceDocument" )
    private String returnsReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsReferenceDocument</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_REFERENCE_DOCUMENT =
        new CustomerReturnProcessStepField<String>("ReturnsReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsReferenceDocumentItem</b>
     * </p>
     *
     * @return Document Item
     */
    @SerializedName( "ReturnsReferenceDocumentItem" )
    @JsonProperty( "ReturnsReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReturnsReferenceDocumentItem" )
    private String returnsReferenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReturnsReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETURNS_REFERENCE_DOCUMENT_ITEM =
        new CustomerReturnProcessStepField<String>("ReturnsReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcStepExecStatus</b>
     * </p>
     *
     * @return Execution Step Status
     */
    @SerializedName( "RetsMgmtProcStepExecStatus" )
    @JsonProperty( "RetsMgmtProcStepExecStatus" )
    @Nullable
    @ODataField( odataName = "RetsMgmtProcStepExecStatus" )
    private String retsMgmtProcStepExecStatus;
    /**
     * Use with available fluent helpers to apply the <b>RetsMgmtProcStepExecStatus</b> field to query operations.
     *
     */
    public final static CustomerReturnProcessStepField<String> RETS_MGMT_PROC_STEP_EXEC_STATUS =
        new CustomerReturnProcessStepField<String>("RetsMgmtProcStepExecStatus");
    /**
     * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnProcessStep</b> to single
     * <b>CustomerReturn</b>.
     *
     */
    @SerializedName( "to_CustomerReturn" )
    @JsonProperty( "to_CustomerReturn" )
    @ODataField( odataName = "to_CustomerReturn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturn toCustomerReturn;
    /**
     * Navigation property <b>to_CustomerReturnItem</b> for <b>CustomerReturnProcessStep</b> to single
     * <b>CustomerReturnItem</b>.
     *
     */
    @SerializedName( "to_CustomerReturnItem" )
    @JsonProperty( "to_CustomerReturnItem" )
    @ODataField( odataName = "to_CustomerReturnItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturnItem toCustomerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturn</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnProcessStepOneToOneLink<CustomerReturn> TO_CUSTOMER_RETURN =
        new CustomerReturnProcessStepOneToOneLink<CustomerReturn>("to_CustomerReturn");
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturnItem</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerReturnProcessStepOneToOneLink<CustomerReturnItem> TO_CUSTOMER_RETURN_ITEM =
        new CustomerReturnProcessStepOneToOneLink<CustomerReturnItem>("to_CustomerReturnItem");

    @Nonnull
    @Override
    public Class<CustomerReturnProcessStep> getType()
    {
        return CustomerReturnProcessStep.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcess</b>
     * </p>
     *
     * @param retsMgmtProcess
     *            Process Identification Number
     */
    public void setRetsMgmtProcess( @Nullable final String retsMgmtProcess )
    {
        rememberChangedField("RetsMgmtProcess", this.retsMgmtProcess);
        this.retsMgmtProcess = retsMgmtProcess;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessItem</b>
     * </p>
     *
     * @param retsMgmtProcessItem
     *            Item Number
     */
    public void setRetsMgmtProcessItem( @Nullable final String retsMgmtProcessItem )
    {
        rememberChangedField("RetsMgmtProcessItem", this.retsMgmtProcessItem);
        this.retsMgmtProcessItem = retsMgmtProcessItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcItmQtySplit</b>
     * </p>
     *
     * @param retsMgmtProcItmQtySplit
     *            Split Identification Number
     */
    public void setRetsMgmtProcItmQtySplit( @Nullable final String retsMgmtProcItmQtySplit )
    {
        rememberChangedField("RetsMgmtProcItmQtySplit", this.retsMgmtProcItmQtySplit);
        this.retsMgmtProcItmQtySplit = retsMgmtProcItmQtySplit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcessStep</b>
     * </p>
     *
     * @param retsMgmtProcessStep
     *            Step ID
     */
    public void setRetsMgmtProcessStep( @Nullable final String retsMgmtProcessStep )
    {
        rememberChangedField("RetsMgmtProcessStep", this.retsMgmtProcessStep);
        this.retsMgmtProcessStep = retsMgmtProcessStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentType</b>
     * </p>
     *
     * @param returnsDocumentType
     *            Document Type
     */
    public void setReturnsDocumentType( @Nullable final String returnsDocumentType )
    {
        rememberChangedField("ReturnsDocumentType", this.returnsDocumentType);
        this.returnsDocumentType = returnsDocumentType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocument</b>
     * </p>
     *
     * @param returnsDocument
     *            Document Number
     */
    public void setReturnsDocument( @Nullable final String returnsDocument )
    {
        rememberChangedField("ReturnsDocument", this.returnsDocument);
        this.returnsDocument = returnsDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentItem</b>
     * </p>
     *
     * @param returnsDocumentItem
     *            Document Item
     */
    public void setReturnsDocumentItem( @Nullable final String returnsDocumentItem )
    {
        rememberChangedField("ReturnsDocumentItem", this.returnsDocumentItem);
        this.returnsDocumentItem = returnsDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentStatus</b>
     * </p>
     *
     * @param returnsDocumentStatus
     *            Status of Document Item
     */
    public void setReturnsDocumentStatus( @Nullable final String returnsDocumentStatus )
    {
        rememberChangedField("ReturnsDocumentStatus", this.returnsDocumentStatus);
        this.returnsDocumentStatus = returnsDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsDocumentApprovalStatus</b>
     * </p>
     *
     * @param returnsDocumentApprovalStatus
     *            Approval Status of Returns Process
     */
    public void setReturnsDocumentApprovalStatus( @Nullable final String returnsDocumentApprovalStatus )
    {
        rememberChangedField("ReturnsDocumentApprovalStatus", this.returnsDocumentApprovalStatus);
        this.returnsDocumentApprovalStatus = returnsDocumentApprovalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsReferenceDocumentType</b>
     * </p>
     *
     * @param returnsReferenceDocumentType
     *            Document Type
     */
    public void setReturnsReferenceDocumentType( @Nullable final String returnsReferenceDocumentType )
    {
        rememberChangedField("ReturnsReferenceDocumentType", this.returnsReferenceDocumentType);
        this.returnsReferenceDocumentType = returnsReferenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsReferenceDocument</b>
     * </p>
     *
     * @param returnsReferenceDocument
     *            Document Number
     */
    public void setReturnsReferenceDocument( @Nullable final String returnsReferenceDocument )
    {
        rememberChangedField("ReturnsReferenceDocument", this.returnsReferenceDocument);
        this.returnsReferenceDocument = returnsReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReturnsReferenceDocumentItem</b>
     * </p>
     *
     * @param returnsReferenceDocumentItem
     *            Document Item
     */
    public void setReturnsReferenceDocumentItem( @Nullable final String returnsReferenceDocumentItem )
    {
        rememberChangedField("ReturnsReferenceDocumentItem", this.returnsReferenceDocumentItem);
        this.returnsReferenceDocumentItem = returnsReferenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetsMgmtProcStepExecStatus</b>
     * </p>
     *
     * @param retsMgmtProcStepExecStatus
     *            Execution Step Status
     */
    public void setRetsMgmtProcStepExecStatus( @Nullable final String retsMgmtProcStepExecStatus )
    {
        rememberChangedField("RetsMgmtProcStepExecStatus", this.retsMgmtProcStepExecStatus);
        this.retsMgmtProcStepExecStatus = retsMgmtProcStepExecStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnProcessStep";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RetsMgmtProcess", getRetsMgmtProcess());
        result.put("RetsMgmtProcessItem", getRetsMgmtProcessItem());
        result.put("RetsMgmtProcItmQtySplit", getRetsMgmtProcItmQtySplit());
        result.put("RetsMgmtProcessStep", getRetsMgmtProcessStep());
        result.put("ReturnsDocumentType", getReturnsDocumentType());
        result.put("ReturnsDocument", getReturnsDocument());
        result.put("ReturnsDocumentItem", getReturnsDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RetsMgmtProcess", getRetsMgmtProcess());
        values.put("RetsMgmtProcessItem", getRetsMgmtProcessItem());
        values.put("RetsMgmtProcItmQtySplit", getRetsMgmtProcItmQtySplit());
        values.put("RetsMgmtProcessStep", getRetsMgmtProcessStep());
        values.put("ReturnsDocumentType", getReturnsDocumentType());
        values.put("ReturnsDocument", getReturnsDocument());
        values.put("ReturnsDocumentItem", getReturnsDocumentItem());
        values.put("ReturnsDocumentStatus", getReturnsDocumentStatus());
        values.put("ReturnsDocumentApprovalStatus", getReturnsDocumentApprovalStatus());
        values.put("ReturnsReferenceDocumentType", getReturnsReferenceDocumentType());
        values.put("ReturnsReferenceDocument", getReturnsReferenceDocument());
        values.put("ReturnsReferenceDocumentItem", getReturnsReferenceDocumentItem());
        values.put("RetsMgmtProcStepExecStatus", getRetsMgmtProcStepExecStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RetsMgmtProcess") ) {
                final Object value = values.remove("RetsMgmtProcess");
                if( (value == null) || (!value.equals(getRetsMgmtProcess())) ) {
                    setRetsMgmtProcess(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcessItem") ) {
                final Object value = values.remove("RetsMgmtProcessItem");
                if( (value == null) || (!value.equals(getRetsMgmtProcessItem())) ) {
                    setRetsMgmtProcessItem(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcItmQtySplit") ) {
                final Object value = values.remove("RetsMgmtProcItmQtySplit");
                if( (value == null) || (!value.equals(getRetsMgmtProcItmQtySplit())) ) {
                    setRetsMgmtProcItmQtySplit(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcessStep") ) {
                final Object value = values.remove("RetsMgmtProcessStep");
                if( (value == null) || (!value.equals(getRetsMgmtProcessStep())) ) {
                    setRetsMgmtProcessStep(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocumentType") ) {
                final Object value = values.remove("ReturnsDocumentType");
                if( (value == null) || (!value.equals(getReturnsDocumentType())) ) {
                    setReturnsDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocument") ) {
                final Object value = values.remove("ReturnsDocument");
                if( (value == null) || (!value.equals(getReturnsDocument())) ) {
                    setReturnsDocument(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocumentItem") ) {
                final Object value = values.remove("ReturnsDocumentItem");
                if( (value == null) || (!value.equals(getReturnsDocumentItem())) ) {
                    setReturnsDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocumentStatus") ) {
                final Object value = values.remove("ReturnsDocumentStatus");
                if( (value == null) || (!value.equals(getReturnsDocumentStatus())) ) {
                    setReturnsDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("ReturnsDocumentApprovalStatus") ) {
                final Object value = values.remove("ReturnsDocumentApprovalStatus");
                if( (value == null) || (!value.equals(getReturnsDocumentApprovalStatus())) ) {
                    setReturnsDocumentApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("ReturnsReferenceDocumentType") ) {
                final Object value = values.remove("ReturnsReferenceDocumentType");
                if( (value == null) || (!value.equals(getReturnsReferenceDocumentType())) ) {
                    setReturnsReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReturnsReferenceDocument") ) {
                final Object value = values.remove("ReturnsReferenceDocument");
                if( (value == null) || (!value.equals(getReturnsReferenceDocument())) ) {
                    setReturnsReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReturnsReferenceDocumentItem") ) {
                final Object value = values.remove("ReturnsReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReturnsReferenceDocumentItem())) ) {
                    setReturnsReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("RetsMgmtProcStepExecStatus") ) {
                final Object value = values.remove("RetsMgmtProcStepExecStatus");
                if( (value == null) || (!value.equals(getRetsMgmtProcStepExecStatus())) ) {
                    setRetsMgmtProcStepExecStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturn") ) {
                final Object value = (values).remove("to_CustomerReturn");
                if( value instanceof Map ) {
                    if( toCustomerReturn == null ) {
                        toCustomerReturn = new CustomerReturn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturn.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CustomerReturnItem") ) {
                final Object value = (values).remove("to_CustomerReturnItem");
                if( value instanceof Map ) {
                    if( toCustomerReturnItem == null ) {
                        toCustomerReturnItem = new CustomerReturnItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturnItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerReturnProcessStepField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnProcessStepField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnProcessStepField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnProcessStepField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturn != null ) {
            (values).put("to_CustomerReturn", toCustomerReturn);
        }
        if( toCustomerReturnItem != null ) {
            (values).put("to_CustomerReturnItem", toCustomerReturnItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturn</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerReturn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn fetchCustomerReturn()
    {
        return fetchFieldAsSingle("to_CustomerReturn", CustomerReturn.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturn</b> of a queried <b>CustomerReturnProcessStep</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn getCustomerReturnOrFetch()
    {
        if( toCustomerReturn == null ) {
            toCustomerReturn = fetchCustomerReturn();
        }
        return toCustomerReturn;
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnProcessStep</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturn</b> is already loaded, the result will
     *         contain the <b>CustomerReturn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturn> getCustomerReturnIfPresent()
    {
        return Option.of(toCustomerReturn);
    }

    /**
     * Overwrites the associated <b>CustomerReturn</b> entity for the loaded navigation property
     * <b>to_CustomerReturn</b>.
     *
     * @param value
     *            New <b>CustomerReturn</b> entity.
     */
    public void setCustomerReturn( final CustomerReturn value )
    {
        toCustomerReturn = value;
    }

    /**
     * Fetches the <b>CustomerReturnItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CustomerReturnItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturnItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnItem fetchCustomerReturnItem()
    {
        return fetchFieldAsSingle("to_CustomerReturnItem", CustomerReturnItem.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturnItem</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturnItem</b> of a queried <b>CustomerReturnProcessStep</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnItem getCustomerReturnItemOrFetch()
    {
        if( toCustomerReturnItem == null ) {
            toCustomerReturnItem = fetchCustomerReturnItem();
        }
        return toCustomerReturnItem;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturnItem</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnProcessStep</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturnItem</b> is already loaded, the result
     *         will contain the <b>CustomerReturnItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturnItem> getCustomerReturnItemIfPresent()
    {
        return Option.of(toCustomerReturnItem);
    }

    /**
     * Overwrites the associated <b>CustomerReturnItem</b> entity for the loaded navigation property
     * <b>to_CustomerReturnItem</b>.
     *
     * @param value
     *            New <b>CustomerReturnItem</b> entity.
     */
    public void setCustomerReturnItem( final CustomerReturnItem value )
    {
        toCustomerReturnItem = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturnProcessStep instances.
     *
     */
    public final static class CustomerReturnProcessStepBuilder
    {

        private CustomerReturn toCustomerReturn;
        private CustomerReturnItem toCustomerReturnItem;

        private CustomerReturnProcessStep.CustomerReturnProcessStepBuilder toCustomerReturn(
            final CustomerReturn value )
        {
            toCustomerReturn = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnProcessStep</b> to single
         * <b>CustomerReturn</b>.
         *
         * @param value
         *            The CustomerReturn to build this CustomerReturnProcessStep with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnProcessStep.CustomerReturnProcessStepBuilder customerReturn( final CustomerReturn value )
        {
            return toCustomerReturn(value);
        }

        private CustomerReturnProcessStep.CustomerReturnProcessStepBuilder toCustomerReturnItem(
            final CustomerReturnItem value )
        {
            toCustomerReturnItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturnItem</b> for <b>CustomerReturnProcessStep</b> to single
         * <b>CustomerReturnItem</b>.
         *
         * @param value
         *            The CustomerReturnItem to build this CustomerReturnProcessStep with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnProcessStep.CustomerReturnProcessStepBuilder customerReturnItem(
            final CustomerReturnItem value )
        {
            return toCustomerReturnItem(value);
        }

    }

}
