/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnProcessStepSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
 * CustomerReturnProcessStep} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CustomerReturnProcessStepByKeyFluentHelper
    extends
    FluentHelperByKey<CustomerReturnProcessStepByKeyFluentHelper, CustomerReturnProcessStep, CustomerReturnProcessStepSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
     * CustomerReturnProcessStep} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CustomerReturnProcessStep}
     * @param returnsDocumentType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param retsMgmtProcessStep
     *            Step ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param returnsDocumentItem
     *            Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param retsMgmtProcess
     *            Process Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CustomerReturnProcessStep}
     * @param retsMgmtProcessItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param retsMgmtProcItmQtySplit
     *            Split Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param returnsDocument
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public CustomerReturnProcessStepByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String retsMgmtProcess,
        final String retsMgmtProcessItem,
        final String retsMgmtProcItmQtySplit,
        final String retsMgmtProcessStep,
        final String returnsDocumentType,
        final String returnsDocument,
        final String returnsDocumentItem )
    {
        super(servicePath, entityCollection);
        this.key.put("RetsMgmtProcess", retsMgmtProcess);
        this.key.put("RetsMgmtProcessItem", retsMgmtProcessItem);
        this.key.put("RetsMgmtProcItmQtySplit", retsMgmtProcItmQtySplit);
        this.key.put("RetsMgmtProcessStep", retsMgmtProcessStep);
        this.key.put("ReturnsDocumentType", returnsDocumentType);
        this.key.put("ReturnsDocument", returnsDocument);
        this.key.put("ReturnsDocumentItem", returnsDocumentItem);
    }

    @Override
    @Nonnull
    protected Class<CustomerReturnProcessStep> getEntityClass()
    {
        return CustomerReturnProcessStep.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
