/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnScheduleLineField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnScheduleLineOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnScheduleLineSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Schedule Line
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnScheduleLineType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnScheduleLine extends VdmEntity<CustomerReturnScheduleLine>
{

    /**
     * Selector for all available fields of CustomerReturnScheduleLine.
     *
     */
    public final static CustomerReturnScheduleLineSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<String> CUSTOMER_RETURN =
        new CustomerReturnScheduleLineField<String>("CustomerReturn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "CustomerReturnItem" )
    @JsonProperty( "CustomerReturnItem" )
    @Nullable
    @ODataField( odataName = "CustomerReturnItem" )
    private String customerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnItem</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<String> CUSTOMER_RETURN_ITEM =
        new CustomerReturnScheduleLineField<String>("CustomerReturnItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<String> SCHEDULE_LINE =
        new CustomerReturnScheduleLineField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<String> ORDER_QUANTITY_UNIT =
        new CustomerReturnScheduleLineField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @return Confirmed Quantity
     */
    @SerializedName( "ConfdOrderQtyByMatlAvailCheck" )
    @JsonProperty( "ConfdOrderQtyByMatlAvailCheck" )
    @Nullable
    @ODataField( odataName = "ConfdOrderQtyByMatlAvailCheck" )
    private BigDecimal confdOrderQtyByMatlAvailCheck;
    /**
     * Use with available fluent helpers to apply the <b>ConfdOrderQtyByMatlAvailCheck</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<BigDecimal> CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK =
        new CustomerReturnScheduleLineField<BigDecimal>("ConfdOrderQtyByMatlAvailCheck");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveredQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Delivered Quantity
     */
    @SerializedName( "DeliveredQtyInOrderQtyUnit" )
    @JsonProperty( "DeliveredQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "DeliveredQtyInOrderQtyUnit" )
    private BigDecimal deliveredQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>DeliveredQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<BigDecimal> DELIVERED_QTY_IN_ORDER_QTY_UNIT =
        new CustomerReturnScheduleLineField<BigDecimal>("DeliveredQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @return Open Confirmed Delivery Quantity
     */
    @SerializedName( "OpenConfdDelivQtyInOrdQtyUnit" )
    @JsonProperty( "OpenConfdDelivQtyInOrdQtyUnit" )
    @Nullable
    @ODataField( odataName = "OpenConfdDelivQtyInOrdQtyUnit" )
    private BigDecimal openConfdDelivQtyInOrdQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpenConfdDelivQtyInOrdQtyUnit</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<BigDecimal> OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT =
        new CustomerReturnScheduleLineField<BigDecimal>("OpenConfdDelivQtyInOrdQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @return Schedule Line Blocked for Delivery
     */
    @SerializedName( "DelivBlockReasonForSchedLine" )
    @JsonProperty( "DelivBlockReasonForSchedLine" )
    @Nullable
    @ODataField( odataName = "DelivBlockReasonForSchedLine" )
    private String delivBlockReasonForSchedLine;
    /**
     * Use with available fluent helpers to apply the <b>DelivBlockReasonForSchedLine</b> field to query operations.
     *
     */
    public final static CustomerReturnScheduleLineField<String> DELIV_BLOCK_REASON_FOR_SCHED_LINE =
        new CustomerReturnScheduleLineField<String>("DelivBlockReasonForSchedLine");
    /**
     * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnScheduleLine</b> to single
     * <b>CustomerReturn</b>.
     *
     */
    @SerializedName( "to_CustomerReturn" )
    @JsonProperty( "to_CustomerReturn" )
    @ODataField( odataName = "to_CustomerReturn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturn toCustomerReturn;
    /**
     * Navigation property <b>to_CustomerReturnItem</b> for <b>CustomerReturnScheduleLine</b> to single
     * <b>CustomerReturnItem</b>.
     *
     */
    @SerializedName( "to_CustomerReturnItem" )
    @JsonProperty( "to_CustomerReturnItem" )
    @ODataField( odataName = "to_CustomerReturnItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturnItem toCustomerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturn</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnScheduleLineOneToOneLink<CustomerReturn> TO_CUSTOMER_RETURN =
        new CustomerReturnScheduleLineOneToOneLink<CustomerReturn>("to_CustomerReturn");
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturnItem</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerReturnScheduleLineOneToOneLink<CustomerReturnItem> TO_CUSTOMER_RETURN_ITEM =
        new CustomerReturnScheduleLineOneToOneLink<CustomerReturnItem>("to_CustomerReturnItem");

    @Nonnull
    @Override
    public Class<CustomerReturnScheduleLine> getType()
    {
        return CustomerReturnScheduleLine.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Sales Document
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @param customerReturnItem
     *            Sales Document Item
     */
    public void setCustomerReturnItem( @Nullable final String customerReturnItem )
    {
        rememberChangedField("CustomerReturnItem", this.customerReturnItem);
        this.customerReturnItem = customerReturnItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line Number
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @param confdOrderQtyByMatlAvailCheck
     *            Confirmed Quantity
     */
    public void setConfdOrderQtyByMatlAvailCheck( @Nullable final BigDecimal confdOrderQtyByMatlAvailCheck )
    {
        rememberChangedField("ConfdOrderQtyByMatlAvailCheck", this.confdOrderQtyByMatlAvailCheck);
        this.confdOrderQtyByMatlAvailCheck = confdOrderQtyByMatlAvailCheck;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveredQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param deliveredQtyInOrderQtyUnit
     *            Delivered Quantity
     */
    public void setDeliveredQtyInOrderQtyUnit( @Nullable final BigDecimal deliveredQtyInOrderQtyUnit )
    {
        rememberChangedField("DeliveredQtyInOrderQtyUnit", this.deliveredQtyInOrderQtyUnit);
        this.deliveredQtyInOrderQtyUnit = deliveredQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @param openConfdDelivQtyInOrdQtyUnit
     *            Open Confirmed Delivery Quantity
     */
    public void setOpenConfdDelivQtyInOrdQtyUnit( @Nullable final BigDecimal openConfdDelivQtyInOrdQtyUnit )
    {
        rememberChangedField("OpenConfdDelivQtyInOrdQtyUnit", this.openConfdDelivQtyInOrdQtyUnit);
        this.openConfdDelivQtyInOrdQtyUnit = openConfdDelivQtyInOrdQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @param delivBlockReasonForSchedLine
     *            Schedule Line Blocked for Delivery
     */
    public void setDelivBlockReasonForSchedLine( @Nullable final String delivBlockReasonForSchedLine )
    {
        rememberChangedField("DelivBlockReasonForSchedLine", this.delivBlockReasonForSchedLine);
        this.delivBlockReasonForSchedLine = delivBlockReasonForSchedLine;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnScheduleLine";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        result.put("CustomerReturnItem", getCustomerReturnItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("CustomerReturnItem", getCustomerReturnItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("ConfdOrderQtyByMatlAvailCheck", getConfdOrderQtyByMatlAvailCheck());
        values.put("DeliveredQtyInOrderQtyUnit", getDeliveredQtyInOrderQtyUnit());
        values.put("OpenConfdDelivQtyInOrdQtyUnit", getOpenConfdDelivQtyInOrdQtyUnit());
        values.put("DelivBlockReasonForSchedLine", getDelivBlockReasonForSchedLine());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnItem") ) {
                final Object value = values.remove("CustomerReturnItem");
                if( (value == null) || (!value.equals(getCustomerReturnItem())) ) {
                    setCustomerReturnItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConfdOrderQtyByMatlAvailCheck") ) {
                final Object value = values.remove("ConfdOrderQtyByMatlAvailCheck");
                if( (value == null) || (!value.equals(getConfdOrderQtyByMatlAvailCheck())) ) {
                    setConfdOrderQtyByMatlAvailCheck(((BigDecimal) value));
                }
            }
            if( values.containsKey("DeliveredQtyInOrderQtyUnit") ) {
                final Object value = values.remove("DeliveredQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getDeliveredQtyInOrderQtyUnit())) ) {
                    setDeliveredQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenConfdDelivQtyInOrdQtyUnit") ) {
                final Object value = values.remove("OpenConfdDelivQtyInOrdQtyUnit");
                if( (value == null) || (!value.equals(getOpenConfdDelivQtyInOrdQtyUnit())) ) {
                    setOpenConfdDelivQtyInOrdQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("DelivBlockReasonForSchedLine") ) {
                final Object value = values.remove("DelivBlockReasonForSchedLine");
                if( (value == null) || (!value.equals(getDelivBlockReasonForSchedLine())) ) {
                    setDelivBlockReasonForSchedLine(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturn") ) {
                final Object value = (values).remove("to_CustomerReturn");
                if( value instanceof Map ) {
                    if( toCustomerReturn == null ) {
                        toCustomerReturn = new CustomerReturn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturn.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CustomerReturnItem") ) {
                final Object value = (values).remove("to_CustomerReturnItem");
                if( value instanceof Map ) {
                    if( toCustomerReturnItem == null ) {
                        toCustomerReturnItem = new CustomerReturnItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturnItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerReturnScheduleLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnScheduleLineField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnScheduleLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnScheduleLineField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturn != null ) {
            (values).put("to_CustomerReturn", toCustomerReturn);
        }
        if( toCustomerReturnItem != null ) {
            (values).put("to_CustomerReturnItem", toCustomerReturnItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturn</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerReturn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn fetchCustomerReturn()
    {
        return fetchFieldAsSingle("to_CustomerReturn", CustomerReturn.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturn</b> of a queried <b>CustomerReturnScheduleLine</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn getCustomerReturnOrFetch()
    {
        if( toCustomerReturn == null ) {
            toCustomerReturn = fetchCustomerReturn();
        }
        return toCustomerReturn;
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnScheduleLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturn</b> is already loaded, the result will
     *         contain the <b>CustomerReturn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturn> getCustomerReturnIfPresent()
    {
        return Option.of(toCustomerReturn);
    }

    /**
     * Overwrites the associated <b>CustomerReturn</b> entity for the loaded navigation property
     * <b>to_CustomerReturn</b>.
     *
     * @param value
     *            New <b>CustomerReturn</b> entity.
     */
    public void setCustomerReturn( final CustomerReturn value )
    {
        toCustomerReturn = value;
    }

    /**
     * Fetches the <b>CustomerReturnItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CustomerReturnItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturnItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnItem fetchCustomerReturnItem()
    {
        return fetchFieldAsSingle("to_CustomerReturnItem", CustomerReturnItem.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturnItem</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturnItem</b> of a queried <b>CustomerReturnScheduleLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturnItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturnItem getCustomerReturnItemOrFetch()
    {
        if( toCustomerReturnItem == null ) {
            toCustomerReturnItem = fetchCustomerReturnItem();
        }
        return toCustomerReturnItem;
    }

    /**
     * Retrieval of associated <b>CustomerReturnItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturnItem</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnScheduleLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturnItem</b> is already loaded, the result
     *         will contain the <b>CustomerReturnItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturnItem> getCustomerReturnItemIfPresent()
    {
        return Option.of(toCustomerReturnItem);
    }

    /**
     * Overwrites the associated <b>CustomerReturnItem</b> entity for the loaded navigation property
     * <b>to_CustomerReturnItem</b>.
     *
     * @param value
     *            New <b>CustomerReturnItem</b> entity.
     */
    public void setCustomerReturnItem( final CustomerReturnItem value )
    {
        toCustomerReturnItem = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturnScheduleLine instances.
     *
     */
    public final static class CustomerReturnScheduleLineBuilder
    {

        private CustomerReturn toCustomerReturn;
        private String customerReturn = null;
        private CustomerReturnItem toCustomerReturnItem;
        private String customerReturnItem = null;

        private CustomerReturnScheduleLine.CustomerReturnScheduleLineBuilder toCustomerReturn(
            final CustomerReturn value )
        {
            toCustomerReturn = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnScheduleLine</b> to single
         * <b>CustomerReturn</b>.
         *
         * @param value
         *            The CustomerReturn to build this CustomerReturnScheduleLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnScheduleLine.CustomerReturnScheduleLineBuilder customerReturn( final CustomerReturn value )
        {
            return toCustomerReturn(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturn</b>
         * </p>
         *
         * @param value
         *            The customerReturn to build this CustomerReturnScheduleLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnScheduleLine.CustomerReturnScheduleLineBuilder customerReturn( final String value )
        {
            customerReturn = value;
            return this;
        }

        private CustomerReturnScheduleLine.CustomerReturnScheduleLineBuilder toCustomerReturnItem(
            final CustomerReturnItem value )
        {
            toCustomerReturnItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturnItem</b> for <b>CustomerReturnScheduleLine</b> to single
         * <b>CustomerReturnItem</b>.
         *
         * @param value
         *            The CustomerReturnItem to build this CustomerReturnScheduleLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnScheduleLine.CustomerReturnScheduleLineBuilder customerReturnItem(
            final CustomerReturnItem value )
        {
            return toCustomerReturnItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
         * </p>
         *
         * @param value
         *            The customerReturnItem to build this CustomerReturnScheduleLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnScheduleLine.CustomerReturnScheduleLineBuilder customerReturnItem( final String value )
        {
            customerReturnItem = value;
            return this;
        }

    }

}
