/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnSerialNumberField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnSerialNumberSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Serial Number
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnSerialNumberType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnSerialNumber extends VdmEntity<CustomerReturnSerialNumber>
{

    /**
     * Selector for all available fields of CustomerReturnSerialNumber.
     *
     */
    public final static CustomerReturnSerialNumberSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnSerialNumberField<String> CUSTOMER_RETURN =
        new CustomerReturnSerialNumberField<String>("CustomerReturn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "CustomerReturnItem" )
    @JsonProperty( "CustomerReturnItem" )
    @Nullable
    @ODataField( odataName = "CustomerReturnItem" )
    private String customerReturnItem;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturnItem</b> field to query operations.
     *
     */
    public final static CustomerReturnSerialNumberField<String> CUSTOMER_RETURN_ITEM =
        new CustomerReturnSerialNumberField<String>("CustomerReturnItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @Key
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static CustomerReturnSerialNumberField<String> SERIAL_NUMBER =
        new CustomerReturnSerialNumberField<String>("SerialNumber");

    @Nonnull
    @Override
    public Class<CustomerReturnSerialNumber> getType()
    {
        return CustomerReturnSerialNumber.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Sales Document
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturnItem</b>
     * </p>
     *
     * @param customerReturnItem
     *            Sales Document Item
     */
    public void setCustomerReturnItem( @Nullable final String customerReturnItem )
    {
        rememberChangedField("CustomerReturnItem", this.customerReturnItem);
        this.customerReturnItem = customerReturnItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnSerialNumber";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        result.put("CustomerReturnItem", getCustomerReturnItem());
        result.put("SerialNumber", getSerialNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("CustomerReturnItem", getCustomerReturnItem());
        values.put("SerialNumber", getSerialNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("CustomerReturnItem") ) {
                final Object value = values.remove("CustomerReturnItem");
                if( (value == null) || (!value.equals(getCustomerReturnItem())) ) {
                    setCustomerReturnItem(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerReturnSerialNumberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnSerialNumberField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnSerialNumberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnSerialNumberField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

}
