/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnSerialNumberSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumber
 * CustomerReturnSerialNumber} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CustomerReturnSerialNumberByKeyFluentHelper
    extends
    FluentHelperByKey<CustomerReturnSerialNumberByKeyFluentHelper, CustomerReturnSerialNumber, CustomerReturnSerialNumberSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumber
     * CustomerReturnSerialNumber} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CustomerReturnSerialNumber}
     * @param customerReturnItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CustomerReturnSerialNumber}
     * @param customerReturn
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CustomerReturnSerialNumberByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String customerReturn,
        final String customerReturnItem,
        final String serialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("CustomerReturn", customerReturn);
        this.key.put("CustomerReturnItem", customerReturnItem);
        this.key.put("SerialNumber", serialNumber);
    }

    @Override
    @Nonnull
    protected Class<CustomerReturnSerialNumber> getEntityClass()
    {
        return CustomerReturnSerialNumber.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
