/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable.CustomerReturnTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerReturnTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerReturnText extends VdmEntity<CustomerReturnText>
{

    /**
     * Selector for all available fields of CustomerReturnText.
     *
     */
    public final static CustomerReturnTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @return Customer Return
     */
    @Key
    @SerializedName( "CustomerReturn" )
    @JsonProperty( "CustomerReturn" )
    @Nullable
    @ODataField( odataName = "CustomerReturn" )
    private String customerReturn;
    /**
     * Use with available fluent helpers to apply the <b>CustomerReturn</b> field to query operations.
     *
     */
    public final static CustomerReturnTextField<String> CUSTOMER_RETURN =
        new CustomerReturnTextField<String>("CustomerReturn");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CustomerReturnTextField<String> LANGUAGE = new CustomerReturnTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static CustomerReturnTextField<String> LONG_TEXT_ID =
        new CustomerReturnTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static CustomerReturnTextField<String> LONG_TEXT = new CustomerReturnTextField<String>("LongText");
    /**
     * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnText</b> to single <b>CustomerReturn</b>.
     *
     */
    @SerializedName( "to_CustomerReturn" )
    @JsonProperty( "to_CustomerReturn" )
    @ODataField( odataName = "to_CustomerReturn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerReturn toCustomerReturn;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerReturn</b> navigation property to query operations.
     *
     */
    public final static CustomerReturnTextOneToOneLink<CustomerReturn> TO_CUSTOMER_RETURN =
        new CustomerReturnTextOneToOneLink<CustomerReturn>("to_CustomerReturn");

    @Nonnull
    @Override
    public Class<CustomerReturnText> getType()
    {
        return CustomerReturnText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerReturn</b>
     * </p>
     *
     * @param customerReturn
     *            Customer Return
     */
    public void setCustomerReturn( @Nullable final String customerReturn )
    {
        rememberChangedField("CustomerReturn", this.customerReturn);
        this.customerReturn = customerReturn;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerReturnText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerReturn", getCustomerReturn());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerReturn", getCustomerReturn());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerReturn") ) {
                final Object value = values.remove("CustomerReturn");
                if( (value == null) || (!value.equals(getCustomerReturn())) ) {
                    setCustomerReturn(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerReturn") ) {
                final Object value = (values).remove("to_CustomerReturn");
                if( value instanceof Map ) {
                    if( toCustomerReturn == null ) {
                        toCustomerReturn = new CustomerReturn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerReturn.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerReturnTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerReturnTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerReturnTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerReturnTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerReturn != null ) {
            (values).put("to_CustomerReturn", toCustomerReturn);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerReturn</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerReturn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerReturn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn fetchCustomerReturn()
    {
        return fetchFieldAsSingle("to_CustomerReturn", CustomerReturn.class);
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property <b>to_CustomerReturn</b> of a queried <b>CustomerReturnText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerReturn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerReturn getCustomerReturnOrFetch()
    {
        if( toCustomerReturn == null ) {
            toCustomerReturn = fetchCustomerReturn();
        }
        return toCustomerReturn;
    }

    /**
     * Retrieval of associated <b>CustomerReturn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerReturn</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerReturnText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerReturn</b> is already loaded, the result will
     *         contain the <b>CustomerReturn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerReturn> getCustomerReturnIfPresent()
    {
        return Option.of(toCustomerReturn);
    }

    /**
     * Overwrites the associated <b>CustomerReturn</b> entity for the loaded navigation property
     * <b>to_CustomerReturn</b>.
     *
     * @param value
     *            New <b>CustomerReturn</b> entity.
     */
    public void setCustomerReturn( final CustomerReturn value )
    {
        toCustomerReturn = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerReturnText instances.
     *
     */
    public final static class CustomerReturnTextBuilder
    {

        private CustomerReturn toCustomerReturn;
        private String customerReturn = null;

        private CustomerReturnText.CustomerReturnTextBuilder toCustomerReturn( final CustomerReturn value )
        {
            toCustomerReturn = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerReturn</b> for <b>CustomerReturnText</b> to single <b>CustomerReturn</b>.
         *
         * @param value
         *            The CustomerReturn to build this CustomerReturnText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnText.CustomerReturnTextBuilder customerReturn( final CustomerReturn value )
        {
            return toCustomerReturn(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CustomerReturn</b>
         * </p>
         *
         * @param value
         *            The customerReturn to build this CustomerReturnText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerReturnText.CustomerReturnTextBuilder customerReturn( final String value )
        {
            customerReturn = value;
            return this;
        }

    }

}
