/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService CustomerReturnService}.
 *
 */
public interface CustomerReturnServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CustomerReturnServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CustomerReturnServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity and save it to the S/4HANA system.
     *
     * @param customerReturn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     *            CustomerReturn} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet createCustomerReturn( @Nonnull final CustomerReturn customerReturn );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity and save it to the S/4HANA system.
     *
     * @param customerReturn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     *            CustomerReturn} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet updateCustomerReturn( @Nonnull final CustomerReturn customerReturn );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity in the S/4HANA system.
     *
     * @param customerReturn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     *            CustomerReturn} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet deleteCustomerReturn( @Nonnull final CustomerReturn customerReturn );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *            CustomerReturnItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        createCustomerReturnItem( @Nonnull final CustomerReturnItem customerReturnItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *            CustomerReturnItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnItem( @Nonnull final CustomerReturnItem customerReturnItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity in the S/4HANA system.
     *
     * @param customerReturnItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *            CustomerReturnItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnItem( @Nonnull final CustomerReturnItem customerReturnItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     * CustomerReturnItemPartner} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *            CustomerReturnItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnItemPartner( @Nonnull final CustomerReturnItemPartner customerReturnItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     * CustomerReturnItemPartner} entity in the S/4HANA system.
     *
     * @param customerReturnItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *            CustomerReturnItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnItemPartner( @Nonnull final CustomerReturnItemPartner customerReturnItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     * CustomerReturnItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *            CustomerReturnItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnItemPrcgElmnt( @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     * CustomerReturnItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param customerReturnItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *            CustomerReturnItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnItemPrcgElmnt( @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     * CustomerReturnItemRelatedObj} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemRelatedObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *            CustomerReturnItemRelatedObj} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        createCustomerReturnItemRelatedObj( @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     * CustomerReturnItemRelatedObj} entity in the S/4HANA system.
     *
     * @param customerReturnItemRelatedObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *            CustomerReturnItemRelatedObj} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnItemRelatedObj( @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     * CustomerReturnItemText} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *            CustomerReturnItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnItemText( @Nonnull final CustomerReturnItemText customerReturnItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     * CustomerReturnItemText} entity in the S/4HANA system.
     *
     * @param customerReturnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *            CustomerReturnItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnItemText( @Nonnull final CustomerReturnItemText customerReturnItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     * CustomerReturnPartner} entity and save it to the S/4HANA system.
     *
     * @param customerReturnPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *            CustomerReturnPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnPartner( @Nonnull final CustomerReturnPartner customerReturnPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     * CustomerReturnPartner} entity in the S/4HANA system.
     *
     * @param customerReturnPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *            CustomerReturnPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnPartner( @Nonnull final CustomerReturnPartner customerReturnPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     * CustomerReturnPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param customerReturnPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *            CustomerReturnPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnPrcgElmnt( @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     * CustomerReturnPrcgElmnt} entity in the S/4HANA system.
     *
     * @param customerReturnPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *            CustomerReturnPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnPrcgElmnt( @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     * CustomerReturnRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param customerReturnRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *            CustomerReturnRelatedObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        createCustomerReturnRelatedObject( @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     * CustomerReturnRelatedObject} entity in the S/4HANA system.
     *
     * @param customerReturnRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *            CustomerReturnRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnRelatedObject( @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     * CustomerReturnText} entity and save it to the S/4HANA system.
     *
     * @param customerReturnText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *            CustomerReturnText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        updateCustomerReturnText( @Nonnull final CustomerReturnText customerReturnText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     * CustomerReturnText} entity in the S/4HANA system.
     *
     * @param customerReturnText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *            CustomerReturnText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnServiceBatchChangeSet
        deleteCustomerReturnText( @Nonnull final CustomerReturnText customerReturnText );

}
