/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CustomerReturnServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService CustomerReturnService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCustomerReturnServiceBatch
    extends
    BatchFluentHelperBasic<CustomerReturnServiceBatch, CustomerReturnServiceBatchChangeSet>
    implements
    CustomerReturnServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCustomerReturnServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerReturnServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCustomerReturnServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerReturnServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCustomerReturnServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCustomerReturnServiceBatchChangeSet(this, service);
    }

}
