/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText;

/**
 * Implementation of the {@link CustomerReturnServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService CustomerReturnService}.
 *
 */
public class DefaultCustomerReturnServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerReturnServiceBatch, CustomerReturnServiceBatchChangeSet>
    implements
    CustomerReturnServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerReturnServiceBatchChangeSet(
        @Nonnull final DefaultCustomerReturnServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerReturnServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet createCustomerReturn( @Nonnull final CustomerReturn customerReturn )
    {
        return addRequestCreate(service::createCustomerReturn, customerReturn);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturn( @Nonnull final CustomerReturn customerReturn )
    {
        return addRequestUpdate(service::updateCustomerReturn, customerReturn);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturn( @Nonnull final CustomerReturn customerReturn )
    {
        return addRequestDelete(service::deleteCustomerReturn, customerReturn);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet createCustomerReturnItem(
        @Nonnull final CustomerReturnItem customerReturnItem )
    {
        return addRequestCreate(service::createCustomerReturnItem, customerReturnItem);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnItem(
        @Nonnull final CustomerReturnItem customerReturnItem )
    {
        return addRequestUpdate(service::updateCustomerReturnItem, customerReturnItem);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnItem(
        @Nonnull final CustomerReturnItem customerReturnItem )
    {
        return addRequestDelete(service::deleteCustomerReturnItem, customerReturnItem);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnItemPartner(
        @Nonnull final CustomerReturnItemPartner customerReturnItemPartner )
    {
        return addRequestUpdate(service::updateCustomerReturnItemPartner, customerReturnItemPartner);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnItemPartner(
        @Nonnull final CustomerReturnItemPartner customerReturnItemPartner )
    {
        return addRequestDelete(service::deleteCustomerReturnItemPartner, customerReturnItemPartner);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnItemPrcgElmnt(
        @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt )
    {
        return addRequestUpdate(service::updateCustomerReturnItemPrcgElmnt, customerReturnItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnItemPrcgElmnt(
        @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt )
    {
        return addRequestDelete(service::deleteCustomerReturnItemPrcgElmnt, customerReturnItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet createCustomerReturnItemRelatedObj(
        @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj )
    {
        return addRequestCreate(service::createCustomerReturnItemRelatedObj, customerReturnItemRelatedObj);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnItemRelatedObj(
        @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj )
    {
        return addRequestDelete(service::deleteCustomerReturnItemRelatedObj, customerReturnItemRelatedObj);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnItemText(
        @Nonnull final CustomerReturnItemText customerReturnItemText )
    {
        return addRequestUpdate(service::updateCustomerReturnItemText, customerReturnItemText);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnItemText(
        @Nonnull final CustomerReturnItemText customerReturnItemText )
    {
        return addRequestDelete(service::deleteCustomerReturnItemText, customerReturnItemText);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnPartner(
        @Nonnull final CustomerReturnPartner customerReturnPartner )
    {
        return addRequestUpdate(service::updateCustomerReturnPartner, customerReturnPartner);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnPartner(
        @Nonnull final CustomerReturnPartner customerReturnPartner )
    {
        return addRequestDelete(service::deleteCustomerReturnPartner, customerReturnPartner);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnPrcgElmnt(
        @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt )
    {
        return addRequestUpdate(service::updateCustomerReturnPrcgElmnt, customerReturnPrcgElmnt);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnPrcgElmnt(
        @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt )
    {
        return addRequestDelete(service::deleteCustomerReturnPrcgElmnt, customerReturnPrcgElmnt);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet createCustomerReturnRelatedObject(
        @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject )
    {
        return addRequestCreate(service::createCustomerReturnRelatedObject, customerReturnRelatedObject);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnRelatedObject(
        @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject )
    {
        return addRequestDelete(service::deleteCustomerReturnRelatedObject, customerReturnRelatedObject);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet updateCustomerReturnText(
        @Nonnull final CustomerReturnText customerReturnText )
    {
        return addRequestUpdate(service::updateCustomerReturnText, customerReturnText);
    }

    @Nonnull
    @Override
    public CustomerReturnServiceBatchChangeSet deleteCustomerReturnText(
        @Nonnull final CustomerReturnText customerReturnText )
    {
        return addRequestDelete(service::deleteCustomerReturnText, customerReturnText);
    }

}
