/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
 * CustomerReturnItemRelatedObj}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnItemRelatedObjField
 * CustomerReturnItemRelatedObjField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnItemRelatedObjLink
 * CustomerReturnItemRelatedObjLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#CUSTOMER_RETURN_ITEM
 * CUSTOMER_RETURN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR
 * SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#SD_DOCUMENT_RELATED_OBJECT_TYPE
 * SD_DOCUMENT_RELATED_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#SD_DOC_RELATED_OBJECT_SYSTEM
 * SD_DOC_RELATED_OBJECT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#SD_DOC_RELATED_OBJECT_REFERENCE1
 * SD_DOC_RELATED_OBJECT_REFERENCE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#SD_DOC_RELATED_OBJECT_REFERENCE2
 * SD_DOC_RELATED_OBJECT_REFERENCE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj#TO_CUSTOMER_RETURN_ITEM
 * TO_CUSTOMER_RETURN_ITEM}</li>
 * </ul>
 *
 */
public interface CustomerReturnItemRelatedObjSelectable extends EntitySelectable<CustomerReturnItemRelatedObj>
{

}
