/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
 * CustomerReturnItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnItemTextField
 * CustomerReturnItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnItemTextLink
 * CustomerReturnItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#CUSTOMER_RETURN_ITEM
 * CUSTOMER_RETURN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText#TO_CUSTOMER_RETURN_ITEM
 * TO_CUSTOMER_RETURN_ITEM}</li>
 * </ul>
 *
 */
public interface CustomerReturnItemTextSelectable extends EntitySelectable<CustomerReturnItemText>
{

}
