/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
 * CustomerReturnOverviewStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnOverviewStatusField
 * CustomerReturnOverviewStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnOverviewStatusLink
 * CustomerReturnOverviewStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus#RETS_MGMT_PROCESS
 * RETS_MGMT_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus#RETURNS_DOCUMENT
 * RETURNS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus#RETS_MGMT_LOG_PROCG_STATUS
 * RETS_MGMT_LOG_PROCG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus#RETS_MGMT_COMPN_PROCG_STATUS
 * RETS_MGMT_COMPN_PROCG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus#RETS_MGMT_PROCESSING_STATUS
 * RETS_MGMT_PROCESSING_STATUS}</li>
 * </ul>
 *
 */
public interface CustomerReturnOverviewStatusSelectable extends EntitySelectable<CustomerReturnOverviewStatus>
{

}
