/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
 * CustomerReturnProcessStep}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.field.CustomerReturnProcessStepField
 * CustomerReturnProcessStepField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.link.CustomerReturnProcessStepLink
 * CustomerReturnProcessStepLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETS_MGMT_PROCESS
 * RETS_MGMT_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETS_MGMT_PROCESS_ITEM
 * RETS_MGMT_PROCESS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETS_MGMT_PROC_ITM_QTY_SPLIT
 * RETS_MGMT_PROC_ITM_QTY_SPLIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETS_MGMT_PROCESS_STEP
 * RETS_MGMT_PROCESS_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_DOCUMENT_TYPE
 * RETURNS_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_DOCUMENT
 * RETURNS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_DOCUMENT_ITEM
 * RETURNS_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_DOCUMENT_STATUS
 * RETURNS_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_DOCUMENT_APPROVAL_STATUS
 * RETURNS_DOCUMENT_APPROVAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_REFERENCE_DOCUMENT_TYPE
 * RETURNS_REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_REFERENCE_DOCUMENT
 * RETURNS_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETURNS_REFERENCE_DOCUMENT_ITEM
 * RETURNS_REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#RETS_MGMT_PROC_STEP_EXEC_STATUS
 * RETS_MGMT_PROC_STEP_EXEC_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep#TO_CUSTOMER_RETURN_ITEM
 * TO_CUSTOMER_RETURN_ITEM}</li>
 * </ul>
 *
 */
public interface CustomerReturnProcessStepSelectable extends EntitySelectable<CustomerReturnProcessStep>
{

}
