/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.field.ReturnsDeliveryPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.link.ReturnsDeliveryPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable.ReturnsDeliveryPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_ReturnsDeliveryPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReturnsDeliveryPartner extends VdmEntity<ReturnsDeliveryPartner>
{

    /**
     * Selector for all available fields of ReturnsDeliveryPartner.
     *
     */
    public final static ReturnsDeliveryPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> ADDRESS_ID =
        new ReturnsDeliveryPartnerField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> CONTACT_PERSON =
        new ReturnsDeliveryPartnerField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> CUSTOMER =
        new ReturnsDeliveryPartnerField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Functn
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> PARTNER_FUNCTION =
        new ReturnsDeliveryPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel No.
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> PERSONNEL =
        new ReturnsDeliveryPartnerField<String>("Personnel");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @return SD Document
     */
    @Key
    @SerializedName( "SDDocument" )
    @JsonProperty( "SDDocument" )
    @Nullable
    @ODataField( odataName = "SDDocument" )
    private String sDDocument;
    /**
     * Use with available fluent helpers to apply the <b>SDDocument</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> SD_DOCUMENT =
        new ReturnsDeliveryPartnerField<String>("SDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentItem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "SDDocumentItem" )
    @JsonProperty( "SDDocumentItem" )
    @Nullable
    @ODataField( odataName = "SDDocumentItem" )
    private String sDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentItem</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> SD_DOCUMENT_ITEM =
        new ReturnsDeliveryPartnerField<String>("SDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerField<String> SUPPLIER =
        new ReturnsDeliveryPartnerField<String>("Supplier");
    /**
     * Navigation property <b>to_Address</b> for <b>ReturnsDeliveryPartner</b> to single <b>ReturnsDeliveryAddress</b>.
     *
     */
    @SerializedName( "to_Address" )
    @JsonProperty( "to_Address" )
    @ODataField( odataName = "to_Address" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ReturnsDeliveryAddress toAddress;
    /**
     * Use with available fluent helpers to apply the <b>to_Address</b> navigation property to query operations.
     *
     */
    public final static ReturnsDeliveryPartnerOneToOneLink<ReturnsDeliveryAddress> TO_ADDRESS =
        new ReturnsDeliveryPartnerOneToOneLink<ReturnsDeliveryAddress>("to_Address");

    @Nonnull
    @Override
    public Class<ReturnsDeliveryPartner> getType()
    {
        return ReturnsDeliveryPartner.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Functn
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel No.
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @param sDDocument
     *            SD Document
     */
    public void setSDDocument( @Nullable final String sDDocument )
    {
        rememberChangedField("SDDocument", this.sDDocument);
        this.sDDocument = sDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentItem</b>
     * </p>
     *
     * @param sDDocumentItem
     *            Item
     */
    public void setSDDocumentItem( @Nullable final String sDDocumentItem )
    {
        rememberChangedField("SDDocumentItem", this.sDDocumentItem);
        this.sDDocumentItem = sDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ReturnsDeliveryPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerFunction", getPartnerFunction());
        result.put("SDDocument", getSDDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AddressID", getAddressID());
        values.put("ContactPerson", getContactPerson());
        values.put("Customer", getCustomer());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Personnel", getPersonnel());
        values.put("SDDocument", getSDDocument());
        values.put("SDDocumentItem", getSDDocumentItem());
        values.put("Supplier", getSupplier());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("SDDocument") ) {
                final Object value = values.remove("SDDocument");
                if( (value == null) || (!value.equals(getSDDocument())) ) {
                    setSDDocument(((String) value));
                }
            }
            if( values.containsKey("SDDocumentItem") ) {
                final Object value = values.remove("SDDocumentItem");
                if( (value == null) || (!value.equals(getSDDocumentItem())) ) {
                    setSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Address") ) {
                final Object value = (values).remove("to_Address");
                if( value instanceof Map ) {
                    if( toAddress == null ) {
                        toAddress = new ReturnsDeliveryAddress();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toAddress.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReturnsDeliveryPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReturnsDeliveryPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReturnsDeliveryPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReturnsDeliveryPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAddress != null ) {
            (values).put("to_Address", toAddress);
        }
        return values;
    }

    /**
     * Fetches the <b>ReturnsDeliveryAddress</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Address</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ReturnsDeliveryAddress</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReturnsDeliveryAddress fetchAddress()
    {
        return fetchFieldAsSingle("to_Address", ReturnsDeliveryAddress.class);
    }

    /**
     * Retrieval of associated <b>ReturnsDeliveryAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property <b>to_Address</b> of a queried <b>ReturnsDeliveryPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReturnsDeliveryAddress</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReturnsDeliveryAddress getAddressOrFetch()
    {
        if( toAddress == null ) {
            toAddress = fetchAddress();
        }
        return toAddress;
    }

    /**
     * Retrieval of associated <b>ReturnsDeliveryAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property for an entity <b>ReturnsDeliveryPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Address</b> is already loaded, the result will contain
     *         the <b>ReturnsDeliveryAddress</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ReturnsDeliveryAddress> getAddressIfPresent()
    {
        return Option.of(toAddress);
    }

    /**
     * Overwrites the associated <b>ReturnsDeliveryAddress</b> entity for the loaded navigation property
     * <b>to_Address</b>.
     *
     * @param value
     *            New <b>ReturnsDeliveryAddress</b> entity.
     */
    public void setAddress( final ReturnsDeliveryAddress value )
    {
        toAddress = value;
    }

    /**
     * Helper class to allow for fluent creation of ReturnsDeliveryPartner instances.
     *
     */
    public final static class ReturnsDeliveryPartnerBuilder
    {

        private ReturnsDeliveryAddress toAddress;

        private ReturnsDeliveryPartner.ReturnsDeliveryPartnerBuilder toAddress( final ReturnsDeliveryAddress value )
        {
            toAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_Address</b> for <b>ReturnsDeliveryPartner</b> to single
         * <b>ReturnsDeliveryAddress</b>.
         *
         * @param value
         *            The ReturnsDeliveryAddress to build this ReturnsDeliveryPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReturnsDeliveryPartner.ReturnsDeliveryPartnerBuilder address( final ReturnsDeliveryAddress value )
        {
            return toAddress(value);
        }

    }

}
