/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.field.ReturnsDeliverySrlNmbrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.link.ReturnsDeliverySrlNmbrLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable.ReturnsDeliverySrlNmbrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_ReturnsDeliverySrlNmbrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReturnsDeliverySrlNmbr extends VdmEntity<ReturnsDeliverySrlNmbr>
{

    /**
     * Selector for all available fields of ReturnsDeliverySrlNmbr.
     *
     */
    public final static ReturnsDeliverySrlNmbrSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDate</b>
     * </p>
     *
     * @return Date
     */
    @SerializedName( "DeliveryDate" )
    @JsonProperty( "DeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDate</b> field to query operations.
     *
     */
    public final static ReturnsDeliverySrlNmbrField<LocalDateTime> DELIVERY_DATE =
        new ReturnsDeliverySrlNmbrField<LocalDateTime>("DeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static ReturnsDeliverySrlNmbrField<String> DELIVERY_DOCUMENT =
        new ReturnsDeliverySrlNmbrField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "DeliveryDocumentItem" )
    @JsonProperty( "DeliveryDocumentItem" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItem" )
    private String deliveryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItem</b> field to query operations.
     *
     */
    public final static ReturnsDeliverySrlNmbrField<String> DELIVERY_DOCUMENT_ITEM =
        new ReturnsDeliverySrlNmbrField<String>("DeliveryDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @return Object list
     */
    @Key
    @SerializedName( "MaintenanceItemObjectList" )
    @JsonProperty( "MaintenanceItemObjectList" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemObjectList" )
    private Integer maintenanceItemObjectList;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemObjectList</b> field to query operations.
     *
     */
    public final static ReturnsDeliverySrlNmbrField<Integer> MAINTENANCE_ITEM_OBJECT_LIST =
        new ReturnsDeliverySrlNmbrField<Integer>("MaintenanceItemObjectList");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return Document Cat.
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static ReturnsDeliverySrlNmbrField<String> SD_DOCUMENT_CATEGORY =
        new ReturnsDeliverySrlNmbrField<String>("SDDocumentCategory");
    /**
     * Navigation property <b>to_MaintenanceItemObject</b> for <b>ReturnsDeliverySrlNmbr</b> to multiple
     * <b>ReturnsDeliveryMaintObj</b>.
     *
     */
    @SerializedName( "to_MaintenanceItemObject" )
    @JsonProperty( "to_MaintenanceItemObject" )
    @ODataField( odataName = "to_MaintenanceItemObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ReturnsDeliveryMaintObj> toMaintenanceItemObject;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItemObject</b> navigation property to query
     * operations.
     *
     */
    public final static ReturnsDeliverySrlNmbrLink<ReturnsDeliveryMaintObj> TO_MAINTENANCE_ITEM_OBJECT =
        new ReturnsDeliverySrlNmbrLink<ReturnsDeliveryMaintObj>("to_MaintenanceItemObject");

    @Nonnull
    @Override
    public Class<ReturnsDeliverySrlNmbr> getType()
    {
        return ReturnsDeliverySrlNmbr.class;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDate</b>
     * </p>
     *
     * @param deliveryDate
     *            Date
     */
    public void setDeliveryDate( @Nullable final LocalDateTime deliveryDate )
    {
        rememberChangedField("DeliveryDate", this.deliveryDate);
        this.deliveryDate = deliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *            Item
     */
    public void setDeliveryDocumentItem( @Nullable final String deliveryDocumentItem )
    {
        rememberChangedField("DeliveryDocumentItem", this.deliveryDocumentItem);
        this.deliveryDocumentItem = deliveryDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @param maintenanceItemObjectList
     *            Object list
     */
    public void setMaintenanceItemObjectList( @Nullable final Integer maintenanceItemObjectList )
    {
        rememberChangedField("MaintenanceItemObjectList", this.maintenanceItemObjectList);
        this.maintenanceItemObjectList = maintenanceItemObjectList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            Document Cat.
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ReturnsDeliverySrlNmbr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeliveryDate", getDeliveryDate());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        values.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeliveryDate") ) {
                final Object value = values.remove("DeliveryDate");
                if( (value == null) || (!value.equals(getDeliveryDate())) ) {
                    setDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItem") ) {
                final Object value = values.remove("DeliveryDocumentItem");
                if( (value == null) || (!value.equals(getDeliveryDocumentItem())) ) {
                    setDeliveryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItemObjectList") ) {
                final Object value = values.remove("MaintenanceItemObjectList");
                if( (value == null) || (!value.equals(getMaintenanceItemObjectList())) ) {
                    setMaintenanceItemObjectList(((Integer) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceItemObject") ) {
                final Object value = (values).remove("to_MaintenanceItemObject");
                if( value instanceof Iterable ) {
                    if( toMaintenanceItemObject == null ) {
                        toMaintenanceItemObject = Lists.newArrayList();
                    } else {
                        toMaintenanceItemObject = Lists.newArrayList(toMaintenanceItemObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ReturnsDeliveryMaintObj entity;
                        if( toMaintenanceItemObject.size() > i ) {
                            entity = toMaintenanceItemObject.get(i);
                        } else {
                            entity = new ReturnsDeliveryMaintObj();
                            toMaintenanceItemObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReturnsDeliverySrlNmbrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReturnsDeliverySrlNmbrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReturnsDeliverySrlNmbrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReturnsDeliverySrlNmbrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceItemObject != null ) {
            (values).put("to_MaintenanceItemObject", toMaintenanceItemObject);
        }
        return values;
    }

    /**
     * Fetches the <b>ReturnsDeliveryMaintObj</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintenanceItemObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ReturnsDeliveryMaintObj</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReturnsDeliveryMaintObj> fetchMaintenanceItemObject()
    {
        return fetchFieldAsList("to_MaintenanceItemObject", ReturnsDeliveryMaintObj.class);
    }

    /**
     * Retrieval of associated <b>ReturnsDeliveryMaintObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemObject</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemObject</b> of a queried <b>ReturnsDeliverySrlNmbr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReturnsDeliveryMaintObj</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReturnsDeliveryMaintObj> getMaintenanceItemObjectOrFetch()
    {
        if( toMaintenanceItemObject == null ) {
            toMaintenanceItemObject = fetchMaintenanceItemObject();
        }
        return toMaintenanceItemObject;
    }

    /**
     * Retrieval of associated <b>ReturnsDeliveryMaintObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemObject</b>.
     * <p>
     * If the navigation property for an entity <b>ReturnsDeliverySrlNmbr</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItemObject</b> is already loaded, the result
     *         will contain the <b>ReturnsDeliveryMaintObj</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ReturnsDeliveryMaintObj>> getMaintenanceItemObjectIfPresent()
    {
        return Option.of(toMaintenanceItemObject);
    }

    /**
     * Overwrites the list of associated <b>ReturnsDeliveryMaintObj</b> entities for the loaded navigation property
     * <b>to_MaintenanceItemObject</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemObject</b> of a queried <b>ReturnsDeliverySrlNmbr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ReturnsDeliveryMaintObj</b> entities.
     */
    public void setMaintenanceItemObject( @Nonnull final List<ReturnsDeliveryMaintObj> value )
    {
        if( toMaintenanceItemObject == null ) {
            toMaintenanceItemObject = Lists.newArrayList();
        }
        toMaintenanceItemObject.clear();
        toMaintenanceItemObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ReturnsDeliveryMaintObj</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceItemObject</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemObject</b> of a queried <b>ReturnsDeliverySrlNmbr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ReturnsDeliveryMaintObj</b> entities.
     */
    public void addMaintenanceItemObject( ReturnsDeliveryMaintObj... entity )
    {
        if( toMaintenanceItemObject == null ) {
            toMaintenanceItemObject = Lists.newArrayList();
        }
        toMaintenanceItemObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ReturnsDeliverySrlNmbr instances.
     *
     */
    public final static class ReturnsDeliverySrlNmbrBuilder
    {

        private List<ReturnsDeliveryMaintObj> toMaintenanceItemObject = Lists.newArrayList();

        private ReturnsDeliverySrlNmbr.ReturnsDeliverySrlNmbrBuilder toMaintenanceItemObject(
            final List<ReturnsDeliveryMaintObj> value )
        {
            toMaintenanceItemObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItemObject</b> for <b>ReturnsDeliverySrlNmbr</b> to multiple
         * <b>ReturnsDeliveryMaintObj</b>.
         *
         * @param value
         *            The ReturnsDeliveryMaintObjs to build this ReturnsDeliverySrlNmbr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReturnsDeliverySrlNmbr.ReturnsDeliverySrlNmbrBuilder maintenanceItemObject(
            ReturnsDeliveryMaintObj... value )
        {
            return toMaintenanceItemObject(Lists.newArrayList(value));
        }

    }

}
