/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable.ReturnsDeliverySrlNmbrSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliverySrlNmbr
 * ReturnsDeliverySrlNmbr} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ReturnsDeliverySrlNmbrByKeyFluentHelper
    extends
    FluentHelperByKey<ReturnsDeliverySrlNmbrByKeyFluentHelper, ReturnsDeliverySrlNmbr, ReturnsDeliverySrlNmbrSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliverySrlNmbr
     * ReturnsDeliverySrlNmbr} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ReturnsDeliverySrlNmbr}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ReturnsDeliverySrlNmbr}
     * @param maintenanceItemObjectList
     *            Object list
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ReturnsDeliverySrlNmbrByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final Integer maintenanceItemObjectList )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceItemObjectList", maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    protected Class<ReturnsDeliverySrlNmbr> getEntityClass()
    {
        return ReturnsDeliverySrlNmbr.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
