/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CustomerReturnsDeliveryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService
 * CustomerReturnsDeliveryService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCustomerReturnsDeliveryServiceBatch
    extends
    BatchFluentHelperBasic<CustomerReturnsDeliveryServiceBatch, CustomerReturnsDeliveryServiceBatchChangeSet>
    implements
    CustomerReturnsDeliveryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCustomerReturnsDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerReturnsDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCustomerReturnsDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerReturnsDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCustomerReturnsDeliveryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCustomerReturnsDeliveryServiceBatchChangeSet(this, service);
    }

}
