/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem;

/**
 * Implementation of the {@link CustomerReturnsDeliveryServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService
 * CustomerReturnsDeliveryService}.
 *
 */
public class DefaultCustomerReturnsDeliveryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerReturnsDeliveryServiceBatch, CustomerReturnsDeliveryServiceBatchChangeSet>
    implements
    CustomerReturnsDeliveryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerReturnsDeliveryServiceBatchChangeSet(
        @Nonnull final DefaultCustomerReturnsDeliveryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerReturnsDeliveryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet updateReturnsDeliveryDocFlow(
        @Nonnull final ReturnsDeliveryDocFlow returnsDeliveryDocFlow )
    {
        return addRequestUpdate(service::updateReturnsDeliveryDocFlow, returnsDeliveryDocFlow);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet createReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return addRequestCreate(service::createReturnsDeliveryHeader, returnsDeliveryHeader);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet updateReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return addRequestUpdate(service::updateReturnsDeliveryHeader, returnsDeliveryHeader);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet deleteReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return addRequestDelete(service::deleteReturnsDeliveryHeader, returnsDeliveryHeader);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet updateReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return addRequestUpdate(service::updateReturnsDeliveryItem, returnsDeliveryItem);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryServiceBatchChangeSet deleteReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return addRequestDelete(service::deleteReturnsDeliveryItem, returnsDeliveryItem);
    }

}
