/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow
 * ReturnsDeliveryDocFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.field.ReturnsDeliveryDocFlowField
 * ReturnsDeliveryDocFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.link.ReturnsDeliveryDocFlowLink
 * ReturnsDeliveryDocFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#DELIVERY_VERSION
 * DELIVERY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#PRECEDING_DOCUMENT
 * PRECEDING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#PRECEDING_DOCUMENT_CATEGORY
 * PRECEDING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#PRECEDING_DOCUMENT_ITEM
 * PRECEDING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#SUBSEQUENTDOCUMENT
 * SUBSEQUENTDOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#QUANTITY_IN_BASE_UNIT
 * QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#SUBSEQUENT_DOCUMENT_ITEM
 * SUBSEQUENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#SD_FULFILLMENT_CALCULATION_RULE
 * SD_FULFILLMENT_CALCULATION_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryDocFlow#TRANSFER_ORDER_IN_WRHS_MGMT_IS_CONFD
 * TRANSFER_ORDER_IN_WRHS_MGMT_IS_CONFD}</li>
 * </ul>
 *
 */
public interface ReturnsDeliveryDocFlowSelectable extends EntitySelectable<ReturnsDeliveryDocFlow>
{

}
