/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader
 * ReturnsDeliveryHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.field.ReturnsDeliveryHeaderField
 * ReturnsDeliveryHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.link.ReturnsDeliveryHeaderLink
 * ReturnsDeliveryHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#ACTUAL_DELIVERY_ROUTE
 * ACTUAL_DELIVERY_ROUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#ACTUAL_GOODS_MOVEMENT_DATE
 * ACTUAL_GOODS_MOVEMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#ACTUAL_GOODS_MOVEMENT_TIME
 * ACTUAL_GOODS_MOVEMENT_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#BILLING_DOCUMENT_DATE
 * BILLING_DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#BILL_OF_LADING
 * BILL_OF_LADING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#COMPLETE_DELIVERY_IS_DEFINED
 * COMPLETE_DELIVERY_IS_DEFINED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#CONFIRMATION_TIME
 * CONFIRMATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_BLOCK_REASON
 * DELIVERY_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_DATE
 * DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_DOCUMENT_BY_SUPPLIER
 * DELIVERY_DOCUMENT_BY_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_DOCUMENT_TYPE
 * DELIVERY_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_IS_IN_PLANT
 * DELIVERY_IS_IN_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_PRIORITY
 * DELIVERY_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_TIME
 * DELIVERY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DELIVERY_VERSION
 * DELIVERY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DEPRECIATION_PERCENTAGE
 * DEPRECIATION_PERCENTAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DISTR_STATUS_BY_DECENTRALIZED_WRHS
 * DISTR_STATUS_BY_DECENTRALIZED_WRHS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#EXTERNAL_IDENTIFICATION_TYPE
 * EXTERNAL_IDENTIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#EXTERNAL_TRANSPORT_SYSTEM
 * EXTERNAL_TRANSPORT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#FACTORY_CALENDAR_BY_CUSTOMER
 * FACTORY_CALENDAR_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#GOODS_ISSUE_OR_RECEIPT_SLIP_NUMBER
 * GOODS_ISSUE_OR_RECEIPT_SLIP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#GOODS_ISSUE_TIME
 * GOODS_ISSUE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HANDLING_UNIT_IN_STOCK
 * HANDLING_UNIT_IN_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HDR_GENERAL_INCOMPLETION_STATUS
 * HDR_GENERAL_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HDR_GOODS_MVT_INCOMPLETION_STATUS
 * HDR_GOODS_MVT_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_BILLG_INCOMPLETION_STATUS
 * HEADER_BILLG_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_BILLING_BLOCK_REASON
 * HEADER_BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_DELIV_INCOMPLETION_STATUS
 * HEADER_DELIV_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_GROSS_WEIGHT
 * HEADER_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_NET_WEIGHT
 * HEADER_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_PACKING_INCOMPLETION_STS
 * HEADER_PACKING_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_PICKG_INCOMPLETION_STATUS
 * HEADER_PICKG_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_VOLUME
 * HEADER_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_VOLUME_UNIT
 * HEADER_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#HEADER_WEIGHT_UNIT
 * HEADER_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#INTERCOMPANY_BILLING_DATE
 * INTERCOMPANY_BILLING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#INTERNAL_FINANCIAL_DOCUMENT
 * INTERNAL_FINANCIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#IS_DELIVERY_FOR_SINGLE_WAREHOUSE
 * IS_DELIVERY_FOR_SINGLE_WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#IS_EXPORT_DELIVERY
 * IS_EXPORT_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#LOADING_DATE
 * LOADING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#LOADING_POINT
 * LOADING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#LOADING_TIME
 * LOADING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#MEANS_OF_TRANSPORT
 * MEANS_OF_TRANSPORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#MEANS_OF_TRANSPORT_REF_MATERIAL
 * MEANS_OF_TRANSPORT_REF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#MEANS_OF_TRANSPORT_TYPE
 * MEANS_OF_TRANSPORT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#ORDER_COMBINATION_IS_ALLOWED
 * ORDER_COMBINATION_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_DELIV_CONF_STATUS
 * OVERALL_DELIV_CONF_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_DELIV_RELTD_BILLG_STATUS
 * OVERALL_DELIV_RELTD_BILLG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_GOODS_MOVEMENT_STATUS
 * OVERALL_GOODS_MOVEMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_INTCO_BILLING_STATUS
 * OVERALL_INTCO_BILLING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_PACKING_STATUS
 * OVERALL_PACKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_PICKING_CONF_STATUS
 * OVERALL_PICKING_CONF_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_PICKING_STATUS
 * OVERALL_PICKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_PROOF_OF_DELIVERY_STATUS
 * OVERALL_PROOF_OF_DELIVERY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_SD_PROCESS_STATUS
 * OVERALL_SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVERALL_WAREHOUSE_ACTIVITY_STATUS
 * OVERALL_WAREHOUSE_ACTIVITY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVRL_ITM_DELIV_INCOMPLETION_STS
 * OVRL_ITM_DELIV_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVRL_ITM_GDS_MVT_INCOMPLETION_STS
 * OVRL_ITM_GDS_MVT_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVRL_ITM_GENERAL_INCOMPLETION_STS
 * OVRL_ITM_GENERAL_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVRL_ITM_PACKING_INCOMPLETION_STS
 * OVRL_ITM_PACKING_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#OVRL_ITM_PICKING_INCOMPLETION_STS
 * OVRL_ITM_PICKING_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PAYMENT_GUARANTEE_PROCEDURE
 * PAYMENT_GUARANTEE_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PICKED_ITEMS_LOCATION
 * PICKED_ITEMS_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PICKING_DATE
 * PICKING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PICKING_TIME
 * PICKING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PLANNED_GOODS_ISSUE_DATE
 * PLANNED_GOODS_ISSUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PROOF_OF_DELIVERY_DATE
 * PROOF_OF_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#PROPOSED_DELIVERY_ROUTE
 * PROPOSED_DELIVERY_ROUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#RECEIVING_PLANT
 * RECEIVING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#ROUTE_SCHEDULE
 * ROUTE_SCHEDULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SD_DOCUMENT_CATEGORY
 * SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SHIPMENT_BLOCK_REASON
 * SHIPMENT_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SHIPPING_CONDITION
 * SHIPPING_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SHIPPING_TYPE
 * SHIPPING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SPECIAL_PROCESSING_CODE
 * SPECIAL_PROCESSING_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#STATISTICS_CURRENCY
 * STATISTICS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TOTAL_BLOCK_STATUS
 * TOTAL_BLOCK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TOTAL_NUMBER_OF_PACKAGE
 * TOTAL_NUMBER_OF_PACKAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TRANSPORTATION_GROUP
 * TRANSPORTATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TRANSPORTATION_PLANNING_DATE
 * TRANSPORTATION_PLANNING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TRANSPORTATION_PLANNING_STATUS
 * TRANSPORTATION_PLANNING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TRANSPORTATION_PLANNING_TIME
 * TRANSPORTATION_PLANNING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#WAREHOUSE_GATE
 * WAREHOUSE_GATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#WAREHOUSE_STAGING_AREA
 * WAREHOUSE_STAGING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TO_DELIVERY_DOCUMENT_ITEM
 * TO_DELIVERY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryHeader#TO_DELIVERY_DOCUMENT_PARTNER
 * TO_DELIVERY_DOCUMENT_PARTNER}</li>
 * </ul>
 *
 */
public interface ReturnsDeliveryHeaderSelectable extends EntitySelectable<ReturnsDeliveryHeader>
{

}
