/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem
 * ReturnsDeliveryItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.field.ReturnsDeliveryItemField
 * ReturnsDeliveryItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.link.ReturnsDeliveryItemLink
 * ReturnsDeliveryItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ACTUAL_DELIVERED_QTY_IN_BASE_UNIT
 * ACTUAL_DELIVERED_QTY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ACTUAL_DELIVERY_QUANTITY
 * ACTUAL_DELIVERY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_CUSTOMER_GROUP1
 * ADDITIONAL_CUSTOMER_GROUP1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_CUSTOMER_GROUP2
 * ADDITIONAL_CUSTOMER_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_VERSION
 * DELIVERY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_CUSTOMER_GROUP3
 * ADDITIONAL_CUSTOMER_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_CUSTOMER_GROUP4
 * ADDITIONAL_CUSTOMER_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_CUSTOMER_GROUP5
 * ADDITIONAL_CUSTOMER_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_MATERIAL_GROUP1
 * ADDITIONAL_MATERIAL_GROUP1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_MATERIAL_GROUP2
 * ADDITIONAL_MATERIAL_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_MATERIAL_GROUP3
 * ADDITIONAL_MATERIAL_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_MATERIAL_GROUP4
 * ADDITIONAL_MATERIAL_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ADDITIONAL_MATERIAL_GROUP5
 * ADDITIONAL_MATERIAL_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ALTERNATE_PRODUCT_NUMBER
 * ALTERNATE_PRODUCT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#BATCH_BY_SUPPLIER
 * BATCH_BY_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#BATCH_CLASSIFICATION
 * BATCH_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#BOM_EXPLOSION
 * BOM_EXPLOSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#CONSUMPTION_POSTING
 * CONSUMPTION_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#CUST_ENGINEERING_CHG_STATUS
 * CUST_ENGINEERING_CHG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_DOCUMENT_ITEM
 * DELIVERY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_DOCUMENT_ITEM_CATEGORY
 * DELIVERY_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_DOCUMENT_ITEM_TEXT
 * DELIVERY_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_GROUP
 * DELIVERY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_QUANTITY_UNIT
 * DELIVERY_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_RELATED_BILLING_STATUS
 * DELIVERY_RELATED_BILLING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_TO_BASE_QUANTITY_DNMNTR
 * DELIVERY_TO_BASE_QUANTITY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DELIVERY_TO_BASE_QUANTITY_NMRTR
 * DELIVERY_TO_BASE_QUANTITY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DEPARTMENT_CLASSIFICATION_BY_CUST
 * DEPARTMENT_CLASSIFICATION_BY_CUST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#FIXED_SHIPG_PROCG_DURATION_IN_DAYS
 * FIXED_SHIPG_PROCG_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#GOODS_MOVEMENT_REASON_CODE
 * GOODS_MOVEMENT_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#GOODS_MOVEMENT_STATUS
 * GOODS_MOVEMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#INSPECTION_LOT
 * INSPECTION_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#INSPECTION_PARTIAL_LOT
 * INSPECTION_PARTIAL_LOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#INTERCOMPANY_BILLING_STATUS
 * INTERCOMPANY_BILLING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#INTERNATIONAL_ARTICLE_NUMBER
 * INTERNATIONAL_ARTICLE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#IS_COMPLETELY_DELIVERED
 * IS_COMPLETELY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#IS_NOT_GOODS_MOVEMENTS_RELEVANT
 * IS_NOT_GOODS_MOVEMENTS_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#IS_SEPARATE_VALUATION
 * IS_SEPARATE_VALUATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSG_OR_RCVG_BATCH
 * ISSG_OR_RCVG_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSG_OR_RCVG_MATERIAL
 * ISSG_OR_RCVG_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSG_OR_RCVG_SPCL_STOCK_IND
 * ISSG_OR_RCVG_SPCL_STOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSG_OR_RCVG_STOCK_CATEGORY
 * ISSG_OR_RCVG_STOCK_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSG_OR_RCVG_VALUATION_TYPE
 * ISSG_OR_RCVG_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSUING_OR_RECEIVING_PLANT
 * ISSUING_OR_RECEIVING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ISSUING_OR_RECEIVING_STORAGE_LOC
 * ISSUING_OR_RECEIVING_STORAGE_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_BILLING_BLOCK_REASON
 * ITEM_BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_BILLING_INCOMPLETION_STATUS
 * ITEM_BILLING_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_DELIVERY_INCOMPLETION_STATUS
 * ITEM_DELIVERY_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_GDS_MVT_INCOMPLETION_STS
 * ITEM_GDS_MVT_INCOMPLETION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_GENERAL_INCOMPLETION_STATUS
 * ITEM_GENERAL_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_IS_BILLING_RELEVANT
 * ITEM_IS_BILLING_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_PACKING_INCOMPLETION_STATUS
 * ITEM_PACKING_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_PICKING_INCOMPLETION_STATUS
 * ITEM_PICKING_INCOMPLETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#LOADING_GROUP
 * LOADING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MANUFACTURE_DATE
 * MANUFACTURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MATERIAL_FREIGHT_GROUP
 * MATERIAL_FREIGHT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MATERIAL_IS_BATCH_MANAGED
 * MATERIAL_IS_BATCH_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#MATERIAL_IS_INT_BATCH_MANAGED
 * MATERIAL_IS_INT_BATCH_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#NUMBER_OF_SERIAL_NUMBERS
 * NUMBER_OF_SERIAL_NUMBERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ORDER_ITEM
 * ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ORIGINAL_DELIVERY_QUANTITY
 * ORIGINAL_DELIVERY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#ORIGINALLY_REQUESTED_MATERIAL
 * ORIGINALLY_REQUESTED_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PACKING_STATUS
 * PACKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PARTIAL_DELIVERY_IS_ALLOWED
 * PARTIAL_DELIVERY_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PAYMENT_GUARANTEE_FORM
 * PAYMENT_GUARANTEE_FORM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PICKING_CONFIRMATION_STATUS
 * PICKING_CONFIRMATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PICKING_CONTROL
 * PICKING_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PICKING_STATUS
 * PICKING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PRIMARY_POSTING_SWITCH
 * PRIMARY_POSTING_SWITCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PRODUCT_AVAILABILITY_DATE
 * PRODUCT_AVAILABILITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PRODUCT_AVAILABILITY_TIME
 * PRODUCT_AVAILABILITY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PRODUCT_CONFIGURATION
 * PRODUCT_CONFIGURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PRODUCT_HIERARCHY_NODE
 * PRODUCT_HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PROOF_OF_DELIVERY_RELEVANCE_CODE
 * PROOF_OF_DELIVERY_RELEVANCE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#PROOF_OF_DELIVERY_STATUS
 * PROOF_OF_DELIVERY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#QUANTITY_IS_FIXED
 * QUANTITY_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#RECEIVING_POINT
 * RECEIVING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#REFERENCE_DOCUMENT_LOGICAL_SYSTEM
 * REFERENCE_DOCUMENT_LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#REFERENCE_SD_DOCUMENT_CATEGORY
 * REFERENCE_SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#REFERENCE_SD_DOCUMENT_ITEM
 * REFERENCE_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#RETAIL_PROMOTION
 * RETAIL_PROMOTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SALES_DOCUMENT_ITEM_TYPE
 * SALES_DOCUMENT_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SD_DOCUMENT_CATEGORY
 * SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SHELF_LIFE_EXPIRATION_DATE
 * SHELF_LIFE_EXPIRATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#STATISTICS_DATE
 * STATISTICS_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#STOCK_TYPE
 * STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#SUBSEQUENT_MOVEMENT_TYPE
 * SUBSEQUENT_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#TRANSPORTATION_GROUP
 * TRANSPORTATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#UNLIMITED_OVERDELIVERY_IS_ALLOWED
 * UNLIMITED_OVERDELIVERY_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#VARBL_SHIPG_PROCG_DURATION_IN_DAYS
 * VARBL_SHIPG_PROCG_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#WAREHOUSE_ACTIVITY_STATUS
 * WAREHOUSE_ACTIVITY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#WAREHOUSE_STAGING_AREA
 * WAREHOUSE_STAGING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#WAREHOUSE_STOCK_CATEGORY
 * WAREHOUSE_STOCK_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#WAREHOUSE_STORAGE_BIN
 * WAREHOUSE_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#TO_DOCUMENT_FLOW
 * TO_DOCUMENT_FLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryItem#TO_SERIAL_DELIVERY_ITEM
 * TO_SERIAL_DELIVERY_ITEM}</li>
 * </ul>
 *
 */
public interface ReturnsDeliveryItemSelectable extends EntitySelectable<ReturnsDeliveryItem>
{

}
