/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj
 * ReturnsDeliveryMaintObj}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.field.ReturnsDeliveryMaintObjField
 * ReturnsDeliveryMaintObjField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.link.ReturnsDeliveryMaintObjLink
 * ReturnsDeliveryMaintObjLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#MAINTENANCE_ITEM_OBJECT
 * MAINTENANCE_ITEM_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#MAINTENANCE_ITEM_OBJECT_LIST
 * MAINTENANCE_ITEM_OBJECT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR
 * MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdelivery.ReturnsDeliveryMaintObj#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * </ul>
 *
 */
public interface ReturnsDeliveryMaintObjSelectable extends EntitySelectable<ReturnsDeliveryMaintObj>
{

}
