/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
 * ReturnsDeliveryItem} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ReturnsDeliveryItemDeleteFluentHelper
    extends
    FluentHelperDelete<ReturnsDeliveryItemDeleteFluentHelper, ReturnsDeliveryItem>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final ReturnsDeliveryItem entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ReturnsDeliveryItem to delete from the endpoint.
     */
    public ReturnsDeliveryItemDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ReturnsDeliveryItem entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ReturnsDeliveryItem getEntity()
    {
        return entity;
    }

}
