/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryV2Service
 * CustomerReturnsDeliveryV2Service}.
 *
 */
public interface CustomerReturnsDeliveryV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CustomerReturnsDeliveryV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CustomerReturnsDeliveryV2ServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     * ReturnsDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     *            ReturnsDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
        updateReturnsDeliveryDocFlow( @Nonnull final ReturnsDeliveryDocFlow returnsDeliveryDocFlow );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *            ReturnsDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
        createReturnsDeliveryHeader( @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *            ReturnsDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
        updateReturnsDeliveryHeader( @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity in the S/4HANA system.
     *
     * @param returnsDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *            ReturnsDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
        deleteReturnsDeliveryHeader( @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *            ReturnsDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
        updateReturnsDeliveryItem( @Nonnull final ReturnsDeliveryItem returnsDeliveryItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity in the S/4HANA system.
     *
     * @param returnsDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *            ReturnsDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
        deleteReturnsDeliveryItem( @Nonnull final ReturnsDeliveryItem returnsDeliveryItem );

}
