/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem;

/**
 * Implementation of the {@link CustomerReturnsDeliveryV2ServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryV2Service
 * CustomerReturnsDeliveryV2Service}.
 *
 */
public class DefaultCustomerReturnsDeliveryV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerReturnsDeliveryV2ServiceBatch, CustomerReturnsDeliveryV2ServiceBatchChangeSet>
    implements
    CustomerReturnsDeliveryV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerReturnsDeliveryV2ServiceBatchChangeSet(
        @Nonnull final DefaultCustomerReturnsDeliveryV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnsDeliveryV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerReturnsDeliveryV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryV2ServiceBatchChangeSet updateReturnsDeliveryDocFlow(
        @Nonnull final ReturnsDeliveryDocFlow returnsDeliveryDocFlow )
    {
        return addRequestUpdate(service::updateReturnsDeliveryDocFlow, returnsDeliveryDocFlow);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryV2ServiceBatchChangeSet createReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return addRequestCreate(service::createReturnsDeliveryHeader, returnsDeliveryHeader);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryV2ServiceBatchChangeSet updateReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return addRequestUpdate(service::updateReturnsDeliveryHeader, returnsDeliveryHeader);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryV2ServiceBatchChangeSet deleteReturnsDeliveryHeader(
        @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader )
    {
        return addRequestDelete(service::deleteReturnsDeliveryHeader, returnsDeliveryHeader);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryV2ServiceBatchChangeSet updateReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return addRequestUpdate(service::updateReturnsDeliveryItem, returnsDeliveryItem);
    }

    @Nonnull
    @Override
    public CustomerReturnsDeliveryV2ServiceBatchChangeSet deleteReturnsDeliveryItem(
        @Nonnull final ReturnsDeliveryItem returnsDeliveryItem )
    {
        return addRequestDelete(service::deleteReturnsDeliveryItem, returnsDeliveryItem);
    }

}
