/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj
 * ReturnsDeliveryMaintObj}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.field.ReturnsDeliveryMaintObjField
 * ReturnsDeliveryMaintObjField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.link.ReturnsDeliveryMaintObjLink
 * ReturnsDeliveryMaintObjLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#MAINTENANCE_ITEM_OBJECT
 * MAINTENANCE_ITEM_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#MAINTENANCE_ITEM_OBJECT_LIST
 * MAINTENANCE_ITEM_OBJECT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR
 * MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryMaintObj#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * </ul>
 *
 */
public interface ReturnsDeliveryMaintObjSelectable extends EntitySelectable<ReturnsDeliveryMaintObj>
{

}
