/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner
 * ReturnsDeliveryPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.field.ReturnsDeliveryPartnerField
 * ReturnsDeliveryPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.link.ReturnsDeliveryPartnerLink
 * ReturnsDeliveryPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#BUSINESS_PARTNER_ADDRESS_UUID
 * BUSINESS_PARTNER_ADDRESS_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#REF_BUSINESS_PARTNER_ADDRESS_UUID
 * REF_BUSINESS_PARTNER_ADDRESS_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#SD_DOCUMENT
 * SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#SD_DOCUMENT_ITEM
 * SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner#TO_ADDRESS
 * TO_ADDRESS}</li>
 * </ul>
 *
 */
public interface ReturnsDeliveryPartnerSelectable extends EntitySelectable<ReturnsDeliveryPartner>
{

}
