/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation;

/**
 * Implementation of the {@link CustomerReturnSimulateServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnSimulateService
 * CustomerReturnSimulateService}.
 *
 */
public class DefaultCustomerReturnSimulateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerReturnSimulateServiceBatch, CustomerReturnSimulateServiceBatchChangeSet>
    implements
    CustomerReturnSimulateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnSimulateService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerReturnSimulateServiceBatchChangeSet(
        @Nonnull final DefaultCustomerReturnSimulateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerReturnSimulateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerReturnSimulateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerReturnSimulateServiceBatchChangeSet createCustomerReturnSimulation(
        @Nonnull final CustomerReturnSimulation customerReturnSimulation )
    {
        return addRequestCreate(service::createCustomerReturnSimulation, customerReturnSimulation);
    }

}
