/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation
 * CustRetItemPartnerSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.field.CustRetItemPartnerSimulationField
 * CustRetItemPartnerSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.link.CustRetItemPartnerSimulationLink
 * CustRetItemPartnerSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#CUSTOMER_RETURN_ITEM
 * CUSTOMER_RETURN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#TO_CUSTOMER_RETURN_ITEM
 * TO_CUSTOMER_RETURN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetItemPartnerSimulation#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * </ul>
 *
 */
public interface CustRetItemPartnerSimulationSelectable extends EntitySelectable<CustRetItemPartnerSimulation>
{

}
