/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation
 * CustRetPartnerSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.field.CustRetPartnerSimulationField
 * CustRetPartnerSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.link.CustRetPartnerSimulationLink
 * CustRetPartnerSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPartnerSimulation#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * </ul>
 *
 */
public interface CustRetPartnerSimulationSelectable extends EntitySelectable<CustRetPartnerSimulation>
{

}
