/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation
 * CustRetPrcgElmntSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.field.CustRetPrcgElmntSimulationField
 * CustRetPrcgElmntSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.link.CustRetPrcgElmntSimulationLink
 * CustRetPrcgElmntSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PRICE_CONDITION_DETERMINATION_DTE
 * PRICE_CONDITION_DETERMINATION_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_BASE_VALUE
 * CONDITION_BASE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_CATEGORY
 * CONDITION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_IS_FOR_STATISTICS
 * CONDITION_IS_FOR_STATISTICS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_ORIGIN
 * CONDITION_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#IS_GROUP_CONDITION
 * IS_GROUP_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CNDN_ROUNDING_OFF_DIFF_AMOUNT
 * CNDN_ROUNDING_OFF_DIFF_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_AMOUNT
 * CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_CONTROL
 * CONDITION_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_INACTIVE_REASON
 * CONDITION_INACTIVE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_CLASS
 * CONDITION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PRCG_PROCEDURE_COUNTER_FOR_HEADER
 * PRCG_PROCEDURE_COUNTER_FOR_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#FACTOR_FOR_CONDITION_BASIS_VALUE
 * FACTOR_FOR_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#STRUCTURE_CONDITION
 * STRUCTURE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE
 * PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_SCALE_BASIS_VALUE
 * CONDITION_SCALE_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_SCALE_BASIS_UNIT
 * CONDITION_SCALE_BASIS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_SCALE_BASIS_CURRENCY
 * CONDITION_SCALE_BASIS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CNDN_IS_RELEVANT_FOR_INTCO_BILLING
 * CNDN_IS_RELEVANT_FOR_INTCO_BILLING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_IS_MANUALLY_CHANGED
 * CONDITION_IS_MANUALLY_CHANGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#CONDITION_IS_FOR_CONFIGURATION
 * CONDITION_IS_FOR_CONFIGURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#VARIANT_CONDITION
 * VARIANT_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustRetPrcgElmntSimulation#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * </ul>
 *
 */
public interface CustRetPrcgElmntSimulationSelectable extends EntitySelectable<CustRetPrcgElmntSimulation>
{

}
