/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation
 * CustomerReturnItemSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.field.CustomerReturnItemSimulationField
 * CustomerReturnItemSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.link.CustomerReturnItemSimulationLink
 * CustomerReturnItemSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUSTOMER_RETURN_ITEM
 * CUSTOMER_RETURN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUSTOMER_RETURN_ITEM_CATEGORY
 * CUSTOMER_RETURN_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUSTOMER_RETURN_ITEM_TEXT
 * CUSTOMER_RETURN_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REQUESTED_QUANTITY_UNIT
 * REQUESTED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ADDITIONAL_MATERIAL_GROUP1
 * ADDITIONAL_MATERIAL_GROUP1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ADDITIONAL_MATERIAL_GROUP2
 * ADDITIONAL_MATERIAL_GROUP2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ADDITIONAL_MATERIAL_GROUP3
 * ADDITIONAL_MATERIAL_GROUP3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ADDITIONAL_MATERIAL_GROUP4
 * ADDITIONAL_MATERIAL_GROUP4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#ADDITIONAL_MATERIAL_GROUP5
 * ADDITIONAL_MATERIAL_GROUP5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUBTOTAL1_AMOUNT
 * SUBTOTAL1_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUBTOTAL2_AMOUNT
 * SUBTOTAL2_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUBTOTAL3_AMOUNT
 * SUBTOTAL3_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUBTOTAL4_AMOUNT
 * SUBTOTAL4_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUBTOTAL5_AMOUNT
 * SUBTOTAL5_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUBTOTAL6_AMOUNT
 * SUBTOTAL6_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#TAX_AMOUNT
 * TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SHIPPING_TYPE
 * SHIPPING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#DELIVERY_PRIORITY
 * DELIVERY_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION1
 * PRODUCT_TAX_CLASSIFICATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION2
 * PRODUCT_TAX_CLASSIFICATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION3
 * PRODUCT_TAX_CLASSIFICATION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION4
 * PRODUCT_TAX_CLASSIFICATION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION5
 * PRODUCT_TAX_CLASSIFICATION5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION6
 * PRODUCT_TAX_CLASSIFICATION6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION7
 * PRODUCT_TAX_CLASSIFICATION7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION8
 * PRODUCT_TAX_CLASSIFICATION8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_TAX_CLASSIFICATION9
 * PRODUCT_TAX_CLASSIFICATION9}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURN_REASON
 * RETURN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETS_MGMT_PROCESSING_BLOCK
 * RETS_MGMT_PROCESSING_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUST_RET_ITM_FOLLOW_UP_ACTIVITY
 * CUST_RET_ITM_FOLLOW_UP_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURNS_MATERIAL_HAS_BEEN_RECEIVED
 * RETURNS_MATERIAL_HAS_BEEN_RECEIVED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURNS_REFUND_TYPE
 * RETURNS_REFUND_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURNS_REFUND_PROCG_MODE
 * RETURNS_REFUND_PROCG_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURNS_REFUND_EXTENT
 * RETURNS_REFUND_EXTENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRELIM_REFUND_IS_DETERMINED
 * PRELIM_REFUND_IS_DETERMINED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURNS_REFUND_RJCN_REASON
 * RETURNS_REFUND_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REPLACEMENT_MATERIAL
 * REPLACEMENT_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REPLACEMENT_MATERIAL_QUANTITY
 * REPLACEMENT_MATERIAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REPLACEMENT_MATERIAL_QTY_UNIT
 * REPLACEMENT_MATERIAL_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REPLACEMENT_MATERIAL_IS_REQUESTED
 * REPLACEMENT_MATERIAL_IS_REQUESTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REPLACEMENT_MATL_SUPPLYING_PLANT
 * REPLACEMENT_MATL_SUPPLYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#NEXT_PLANT_FOR_FOLLOW_UP_ACTIVITY
 * NEXT_PLANT_FOR_FOLLOW_UP_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RETURNS_TRANSSHIPMENT_PLANT
 * RETURNS_TRANSSHIPMENT_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUPPLIER_RET_MATL_AUTHZN
 * SUPPLIER_RET_MATL_AUTHZN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#SUPLR_RET_MATL_AUTHZN_IS_REQUIRED
 * SUPLR_RET_MATL_AUTHZN_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUSTOMER_RET_MATL_INSP_RESULT_CODE
 * CUSTOMER_RET_MATL_INSP_RESULT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#NEXT_FLLW_UP_ACTIVITY_FOR_MATL_INSP
 * NEXT_FLLW_UP_ACTIVITY_FOR_MATL_INSP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#RET_MATL_INSP_RESULT_CODE
 * RET_MATL_INSP_RESULT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#PRODUCT_IS_INSPECTED_AT_CUST_SITE
 * PRODUCT_IS_INSPECTED_AT_CUST_SITE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#CUST_RET_MATL_AUTHZN
 * CUST_RET_MATL_AUTHZN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#REFERENCE_SD_DOCUMENT_ITEM
 * REFERENCE_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnItemSimulation#TO_CUSTOMER_RETURN
 * TO_CUSTOMER_RETURN}</li>
 * </ul>
 *
 */
public interface CustomerReturnItemSimulationSelectable extends EntitySelectable<CustomerReturnItemSimulation>
{

}
