/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation
 * CustomerReturnSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.field.CustomerReturnSimulationField
 * CustomerReturnSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.link.CustomerReturnSimulationLink
 * CustomerReturnSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_RETURN
 * CUSTOMER_RETURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_RETURN_TYPE
 * CUSTOMER_RETURN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_PURCHASE_ORDER_TYPE
 * CUSTOMER_PURCHASE_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_PURCHASE_ORDER_DATE
 * CUSTOMER_PURCHASE_ORDER_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_RETURN_DATE
 * CUSTOMER_RETURN_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#TOTAL_NET_AMOUNT
 * TOTAL_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SD_PRICING_PROCEDURE
 * SD_PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SD_DOCUMENT_REASON
 * SD_DOCUMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#REQUESTED_DELIVERY_DATE
 * REQUESTED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#SHIPPING_TYPE
 * SHIPPING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION1
 * CUSTOMER_TAX_CLASSIFICATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION2
 * CUSTOMER_TAX_CLASSIFICATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION3
 * CUSTOMER_TAX_CLASSIFICATION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION4
 * CUSTOMER_TAX_CLASSIFICATION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION5
 * CUSTOMER_TAX_CLASSIFICATION5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION6
 * CUSTOMER_TAX_CLASSIFICATION6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION7
 * CUSTOMER_TAX_CLASSIFICATION7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION8
 * CUSTOMER_TAX_CLASSIFICATION8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#CUSTOMER_TAX_CLASSIFICATION9
 * CUSTOMER_TAX_CLASSIFICATION9}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#ACCOUNTING_DOC_EXTERNAL_REFERENCE
 * ACCOUNTING_DOC_EXTERNAL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsimulate.CustomerReturnSimulation#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * </ul>
 *
 */
public interface CustomerReturnSimulationSelectable extends EntitySelectable<CustomerReturnSimulation>
{

}
