/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DbtMemoReqItmSubsqntProcFlowSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
 * DbtMemoReqItmSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper
    extends
    FluentHelperByKey<DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper, DbtMemoReqItmSubsqntProcFlow, DbtMemoReqItmSubsqntProcFlowSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
     * DbtMemoReqItmSubsqntProcFlow} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DbtMemoReqItmSubsqntProcFlow}
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param debitMemoRequestItem
     *            Preceding Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code DbtMemoReqItmSubsqntProcFlow}
     * @param debitMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final UUID docRelationshipUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("DebitMemoRequest", debitMemoRequest);
        this.key.put("DebitMemoRequestItem", debitMemoRequestItem);
        this.key.put("DocRelationshipUUID", docRelationshipUUID);
    }

    @Override
    @Nonnull
    protected Class<DbtMemoReqItmSubsqntProcFlow> getEntityClass()
    {
        return DbtMemoReqItmSubsqntProcFlow.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
