/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DebitMemoReqItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link.DebitMemoReqItemPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DebitMemoReqItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DebitMemoReqItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DebitMemoReqItemPartner extends VdmEntity<DebitMemoReqItemPartner>
{

    /**
     * Selector for all available fields of DebitMemoReqItemPartner.
     *
     */
    public final static DebitMemoReqItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @Key
    @SerializedName( "DebitMemoRequest" )
    @JsonProperty( "DebitMemoRequest" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequest" )
    private String debitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequest</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> DEBIT_MEMO_REQUEST =
        new DebitMemoReqItemPartnerField<String>("DebitMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
     * </p>
     *
     * @return Item number of the SD document
     */
    @Key
    @SerializedName( "DebitMemoRequestItem" )
    @JsonProperty( "DebitMemoRequestItem" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequestItem" )
    private String debitMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequestItem</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> DEBIT_MEMO_REQUEST_ITEM =
        new DebitMemoReqItemPartnerField<String>("DebitMemoRequestItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> PARTNER_FUNCTION =
        new DebitMemoReqItemPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> CUSTOMER =
        new DebitMemoReqItemPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> SUPPLIER =
        new DebitMemoReqItemPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> PERSONNEL =
        new DebitMemoReqItemPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemPartnerField<String> CONTACT_PERSON =
        new DebitMemoReqItemPartnerField<String>("ContactPerson");
    /**
     * Navigation property <b>to_DebitMemoRequest</b> for <b>DebitMemoReqItemPartner</b> to single
     * <b>DebitMemoRequest</b>.
     *
     */
    @SerializedName( "to_DebitMemoRequest" )
    @JsonProperty( "to_DebitMemoRequest" )
    @ODataField( odataName = "to_DebitMemoRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DebitMemoRequest toDebitMemoRequest;
    /**
     * Navigation property <b>to_DebitMemoRequestItem</b> for <b>DebitMemoReqItemPartner</b> to single
     * <b>DebitMemoRequestItem</b>.
     *
     */
    @SerializedName( "to_DebitMemoRequestItem" )
    @JsonProperty( "to_DebitMemoRequestItem" )
    @ODataField( odataName = "to_DebitMemoRequestItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DebitMemoRequestItem toDebitMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>to_DebitMemoRequest</b> navigation property to query
     * operations.
     *
     */
    public final static DebitMemoReqItemPartnerOneToOneLink<DebitMemoRequest> TO_DEBIT_MEMO_REQUEST =
        new DebitMemoReqItemPartnerOneToOneLink<DebitMemoRequest>("to_DebitMemoRequest");
    /**
     * Use with available fluent helpers to apply the <b>to_DebitMemoRequestItem</b> navigation property to query
     * operations.
     *
     */
    public final static DebitMemoReqItemPartnerOneToOneLink<DebitMemoRequestItem> TO_DEBIT_MEMO_REQUEST_ITEM =
        new DebitMemoReqItemPartnerOneToOneLink<DebitMemoRequestItem>("to_DebitMemoRequestItem");

    @Nonnull
    @Override
    public Class<DebitMemoReqItemPartner> getType()
    {
        return DebitMemoReqItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @param debitMemoRequest
     *            Sales and Distribution Document Number
     */
    public void setDebitMemoRequest( @Nullable final String debitMemoRequest )
    {
        rememberChangedField("DebitMemoRequest", this.debitMemoRequest);
        this.debitMemoRequest = debitMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
     * </p>
     *
     * @param debitMemoRequestItem
     *            Item number of the SD document
     */
    public void setDebitMemoRequestItem( @Nullable final String debitMemoRequestItem )
    {
        rememberChangedField("DebitMemoRequestItem", this.debitMemoRequestItem);
        this.debitMemoRequestItem = debitMemoRequestItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DebitMemoReqItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DebitMemoRequest", getDebitMemoRequest());
        result.put("DebitMemoRequestItem", getDebitMemoRequestItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DebitMemoRequest", getDebitMemoRequest());
        values.put("DebitMemoRequestItem", getDebitMemoRequestItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DebitMemoRequest") ) {
                final Object value = values.remove("DebitMemoRequest");
                if( (value == null) || (!value.equals(getDebitMemoRequest())) ) {
                    setDebitMemoRequest(((String) value));
                }
            }
            if( values.containsKey("DebitMemoRequestItem") ) {
                final Object value = values.remove("DebitMemoRequestItem");
                if( (value == null) || (!value.equals(getDebitMemoRequestItem())) ) {
                    setDebitMemoRequestItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_DebitMemoRequest") ) {
                final Object value = (values).remove("to_DebitMemoRequest");
                if( value instanceof Map ) {
                    if( toDebitMemoRequest == null ) {
                        toDebitMemoRequest = new DebitMemoRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDebitMemoRequest.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_DebitMemoRequestItem") ) {
                final Object value = (values).remove("to_DebitMemoRequestItem");
                if( value instanceof Map ) {
                    if( toDebitMemoRequestItem == null ) {
                        toDebitMemoRequestItem = new DebitMemoRequestItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDebitMemoRequestItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DebitMemoReqItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DebitMemoReqItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DebitMemoReqItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DebitMemoReqItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDebitMemoRequest != null ) {
            (values).put("to_DebitMemoRequest", toDebitMemoRequest);
        }
        if( toDebitMemoRequestItem != null ) {
            (values).put("to_DebitMemoRequestItem", toDebitMemoRequestItem);
        }
        return values;
    }

    /**
     * Fetches the <b>DebitMemoRequest</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DebitMemoRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DebitMemoRequest</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequest fetchDebitMemoRequest()
    {
        return fetchFieldAsSingle("to_DebitMemoRequest", DebitMemoRequest.class);
    }

    /**
     * Retrieval of associated <b>DebitMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DebitMemoRequest</b>.
     * <p>
     * If the navigation property <b>to_DebitMemoRequest</b> of a queried <b>DebitMemoReqItemPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DebitMemoRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequest getDebitMemoRequestOrFetch()
    {
        if( toDebitMemoRequest == null ) {
            toDebitMemoRequest = fetchDebitMemoRequest();
        }
        return toDebitMemoRequest;
    }

    /**
     * Retrieval of associated <b>DebitMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DebitMemoRequest</b>.
     * <p>
     * If the navigation property for an entity <b>DebitMemoReqItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DebitMemoRequest</b> is already loaded, the result will
     *         contain the <b>DebitMemoRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DebitMemoRequest> getDebitMemoRequestIfPresent()
    {
        return Option.of(toDebitMemoRequest);
    }

    /**
     * Overwrites the associated <b>DebitMemoRequest</b> entity for the loaded navigation property
     * <b>to_DebitMemoRequest</b>.
     *
     * @param value
     *            New <b>DebitMemoRequest</b> entity.
     */
    public void setDebitMemoRequest( final DebitMemoRequest value )
    {
        toDebitMemoRequest = value;
    }

    /**
     * Fetches the <b>DebitMemoRequestItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DebitMemoRequestItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DebitMemoRequestItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequestItem fetchDebitMemoRequestItem()
    {
        return fetchFieldAsSingle("to_DebitMemoRequestItem", DebitMemoRequestItem.class);
    }

    /**
     * Retrieval of associated <b>DebitMemoRequestItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DebitMemoRequestItem</b>.
     * <p>
     * If the navigation property <b>to_DebitMemoRequestItem</b> of a queried <b>DebitMemoReqItemPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DebitMemoRequestItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequestItem getDebitMemoRequestItemOrFetch()
    {
        if( toDebitMemoRequestItem == null ) {
            toDebitMemoRequestItem = fetchDebitMemoRequestItem();
        }
        return toDebitMemoRequestItem;
    }

    /**
     * Retrieval of associated <b>DebitMemoRequestItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DebitMemoRequestItem</b>.
     * <p>
     * If the navigation property for an entity <b>DebitMemoReqItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DebitMemoRequestItem</b> is already loaded, the result
     *         will contain the <b>DebitMemoRequestItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DebitMemoRequestItem> getDebitMemoRequestItemIfPresent()
    {
        return Option.of(toDebitMemoRequestItem);
    }

    /**
     * Overwrites the associated <b>DebitMemoRequestItem</b> entity for the loaded navigation property
     * <b>to_DebitMemoRequestItem</b>.
     *
     * @param value
     *            New <b>DebitMemoRequestItem</b> entity.
     */
    public void setDebitMemoRequestItem( final DebitMemoRequestItem value )
    {
        toDebitMemoRequestItem = value;
    }

    /**
     * Helper class to allow for fluent creation of DebitMemoReqItemPartner instances.
     *
     */
    public final static class DebitMemoReqItemPartnerBuilder
    {

        private DebitMemoRequest toDebitMemoRequest;
        private String debitMemoRequest = null;
        private DebitMemoRequestItem toDebitMemoRequestItem;
        private String debitMemoRequestItem = null;

        private DebitMemoReqItemPartner.DebitMemoReqItemPartnerBuilder toDebitMemoRequest(
            final DebitMemoRequest value )
        {
            toDebitMemoRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_DebitMemoRequest</b> for <b>DebitMemoReqItemPartner</b> to single
         * <b>DebitMemoRequest</b>.
         *
         * @param value
         *            The DebitMemoRequest to build this DebitMemoReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemPartner.DebitMemoReqItemPartnerBuilder debitMemoRequest( final DebitMemoRequest value )
        {
            return toDebitMemoRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
         * </p>
         *
         * @param value
         *            The debitMemoRequest to build this DebitMemoReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemPartner.DebitMemoReqItemPartnerBuilder debitMemoRequest( final String value )
        {
            debitMemoRequest = value;
            return this;
        }

        private DebitMemoReqItemPartner.DebitMemoReqItemPartnerBuilder toDebitMemoRequestItem(
            final DebitMemoRequestItem value )
        {
            toDebitMemoRequestItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_DebitMemoRequestItem</b> for <b>DebitMemoReqItemPartner</b> to single
         * <b>DebitMemoRequestItem</b>.
         *
         * @param value
         *            The DebitMemoRequestItem to build this DebitMemoReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemPartner.DebitMemoReqItemPartnerBuilder debitMemoRequestItem(
            final DebitMemoRequestItem value )
        {
            return toDebitMemoRequestItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
         * </p>
         *
         * @param value
         *            The debitMemoRequestItem to build this DebitMemoReqItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqItemPartner.DebitMemoReqItemPartnerBuilder debitMemoRequestItem( final String value )
        {
            debitMemoRequestItem = value;
            return this;
        }

    }

}
