/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DebitMemoReqItemPartnerSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
 * DebitMemoReqItemPartner} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class DebitMemoReqItemPartnerByKeyFluentHelper
    extends
    FluentHelperByKey<DebitMemoReqItemPartnerByKeyFluentHelper, DebitMemoReqItemPartner, DebitMemoReqItemPartnerSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DebitMemoReqItemPartner}
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param debitMemoRequestItem
     *            Item number of the SD document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code DebitMemoReqItemPartner}
     * @param debitMemoRequest
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public DebitMemoReqItemPartnerByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String partnerFunction )
    {
        super(servicePath, entityCollection);
        this.key.put("DebitMemoRequest", debitMemoRequest);
        this.key.put("DebitMemoRequestItem", debitMemoRequestItem);
        this.key.put("PartnerFunction", partnerFunction);
    }

    @Override
    @Nonnull
    protected Class<DebitMemoReqItemPartner> getEntityClass()
    {
        return DebitMemoReqItemPartner.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
