/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DebitMemoReqItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DebitMemoReqItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DebitMemoReqItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DebitMemoReqItemText extends VdmEntity<DebitMemoReqItemText>
{

    /**
     * Selector for all available fields of DebitMemoReqItemText.
     *
     */
    public final static DebitMemoReqItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @return Debit Memo Request
     */
    @Key
    @SerializedName( "DebitMemoRequest" )
    @JsonProperty( "DebitMemoRequest" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequest" )
    private String debitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequest</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemTextField<String> DEBIT_MEMO_REQUEST =
        new DebitMemoReqItemTextField<String>("DebitMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
     * </p>
     *
     * @return Debit Memo Request Item
     */
    @Key
    @SerializedName( "DebitMemoRequestItem" )
    @JsonProperty( "DebitMemoRequestItem" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequestItem" )
    private String debitMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequestItem</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemTextField<String> DEBIT_MEMO_REQUEST_ITEM =
        new DebitMemoReqItemTextField<String>("DebitMemoRequestItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemTextField<String> LANGUAGE = new DebitMemoReqItemTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemTextField<String> LONG_TEXT_ID =
        new DebitMemoReqItemTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static DebitMemoReqItemTextField<String> LONG_TEXT = new DebitMemoReqItemTextField<String>("LongText");

    @Nonnull
    @Override
    public Class<DebitMemoReqItemText> getType()
    {
        return DebitMemoReqItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @param debitMemoRequest
     *            Debit Memo Request
     */
    public void setDebitMemoRequest( @Nullable final String debitMemoRequest )
    {
        rememberChangedField("DebitMemoRequest", this.debitMemoRequest);
        this.debitMemoRequest = debitMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequestItem</b>
     * </p>
     *
     * @param debitMemoRequestItem
     *            Debit Memo Request Item
     */
    public void setDebitMemoRequestItem( @Nullable final String debitMemoRequestItem )
    {
        rememberChangedField("DebitMemoRequestItem", this.debitMemoRequestItem);
        this.debitMemoRequestItem = debitMemoRequestItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DebitMemoReqItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DebitMemoRequest", getDebitMemoRequest());
        result.put("DebitMemoRequestItem", getDebitMemoRequestItem());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DebitMemoRequest", getDebitMemoRequest());
        values.put("DebitMemoRequestItem", getDebitMemoRequestItem());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DebitMemoRequest") ) {
                final Object value = values.remove("DebitMemoRequest");
                if( (value == null) || (!value.equals(getDebitMemoRequest())) ) {
                    setDebitMemoRequest(((String) value));
                }
            }
            if( values.containsKey("DebitMemoRequestItem") ) {
                final Object value = values.remove("DebitMemoRequestItem");
                if( (value == null) || (!value.equals(getDebitMemoRequestItem())) ) {
                    setDebitMemoRequestItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DebitMemoReqItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DebitMemoReqItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DebitMemoReqItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DebitMemoReqItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService.DEFAULT_SERVICE_PATH);
    }

}
