/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.field.DebitMemoReqSubsqntProcFlowField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link.DebitMemoReqSubsqntProcFlowOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DebitMemoReqSubsqntProcFlowSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Subsequent Process Flow
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DebitMemoReqSubsqntProcFlowType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DebitMemoReqSubsqntProcFlow extends VdmEntity<DebitMemoReqSubsqntProcFlow>
{

    /**
     * Selector for all available fields of DebitMemoReqSubsqntProcFlow.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @return Preceding sales and distribution document
     */
    @Key
    @SerializedName( "DebitMemoRequest" )
    @JsonProperty( "DebitMemoRequest" )
    @Nullable
    @ODataField( odataName = "DebitMemoRequest" )
    private String debitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>DebitMemoRequest</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> DEBIT_MEMO_REQUEST =
        new DebitMemoReqSubsqntProcFlowField<String>("DebitMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocument</b>
     * </p>
     *
     * @return Subsequent Sales and Distribution Document
     */
    @Key
    @SerializedName( "SubsequentDocument" )
    @JsonProperty( "SubsequentDocument" )
    @Nullable
    @ODataField( odataName = "SubsequentDocument" )
    private String subsequentDocument;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocument</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> SUBSEQUENT_DOCUMENT =
        new DebitMemoReqSubsqntProcFlowField<String>("SubsequentDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Subsequent Document
     */
    @SerializedName( "SubsequentDocumentCategory" )
    @JsonProperty( "SubsequentDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SubsequentDocumentCategory" )
    private String subsequentDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocumentCategory</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> SUBSEQUENT_DOCUMENT_CATEGORY =
        new DebitMemoReqSubsqntProcFlowField<String>("SubsequentDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @return Level of the document flow record
     */
    @SerializedName( "ProcessFlowLevel" )
    @JsonProperty( "ProcessFlowLevel" )
    @Nullable
    @ODataField( odataName = "ProcessFlowLevel" )
    private String processFlowLevel;
    /**
     * Use with available fluent helpers to apply the <b>ProcessFlowLevel</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> PROCESS_FLOW_LEVEL =
        new DebitMemoReqSubsqntProcFlowField<String>("ProcessFlowLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallBillingStatus</b>
     * </p>
     *
     * @return SD Billing Status
     */
    @SerializedName( "OverallBillingStatus" )
    @JsonProperty( "OverallBillingStatus" )
    @Nullable
    @ODataField( odataName = "OverallBillingStatus" )
    private String overallBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallBillingStatus</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> OVERALL_BILLING_STATUS =
        new DebitMemoReqSubsqntProcFlowField<String>("OverallBillingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> OVERALL_SD_PROCESS_STATUS =
        new DebitMemoReqSubsqntProcFlowField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RelatedProcFlowDocStsFieldName</b>
     * </p>
     *
     * @return Field Name
     */
    @SerializedName( "RelatedProcFlowDocStsFieldName" )
    @JsonProperty( "RelatedProcFlowDocStsFieldName" )
    @Nullable
    @ODataField( odataName = "RelatedProcFlowDocStsFieldName" )
    private String relatedProcFlowDocStsFieldName;
    /**
     * Use with available fluent helpers to apply the <b>RelatedProcFlowDocStsFieldName</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<String> RELATED_PROC_FLOW_DOC_STS_FIELD_NAME =
        new DebitMemoReqSubsqntProcFlowField<String>("RelatedProcFlowDocStsFieldName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<LocalDateTime> CREATION_DATE =
        new DebitMemoReqSubsqntProcFlowField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<LocalTime> CREATION_TIME =
        new DebitMemoReqSubsqntProcFlowField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowField<LocalDateTime> LAST_CHANGE_DATE =
        new DebitMemoReqSubsqntProcFlowField<LocalDateTime>("LastChangeDate");
    /**
     * Navigation property <b>to_DebitMemoRequest</b> for <b>DebitMemoReqSubsqntProcFlow</b> to single
     * <b>DebitMemoRequest</b>.
     *
     */
    @SerializedName( "to_DebitMemoRequest" )
    @JsonProperty( "to_DebitMemoRequest" )
    @ODataField( odataName = "to_DebitMemoRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DebitMemoRequest toDebitMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>to_DebitMemoRequest</b> navigation property to query
     * operations.
     *
     */
    public final static DebitMemoReqSubsqntProcFlowOneToOneLink<DebitMemoRequest> TO_DEBIT_MEMO_REQUEST =
        new DebitMemoReqSubsqntProcFlowOneToOneLink<DebitMemoRequest>("to_DebitMemoRequest");

    @Nonnull
    @Override
    public Class<DebitMemoReqSubsqntProcFlow> getType()
    {
        return DebitMemoReqSubsqntProcFlow.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
     * </p>
     *
     * @param debitMemoRequest
     *            Preceding sales and distribution document
     */
    public void setDebitMemoRequest( @Nullable final String debitMemoRequest )
    {
        rememberChangedField("DebitMemoRequest", this.debitMemoRequest);
        this.debitMemoRequest = debitMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocument</b>
     * </p>
     *
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     */
    public void setSubsequentDocument( @Nullable final String subsequentDocument )
    {
        rememberChangedField("SubsequentDocument", this.subsequentDocument);
        this.subsequentDocument = subsequentDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentCategory</b>
     * </p>
     *
     * @param subsequentDocumentCategory
     *            Document Category of Subsequent Document
     */
    public void setSubsequentDocumentCategory( @Nullable final String subsequentDocumentCategory )
    {
        rememberChangedField("SubsequentDocumentCategory", this.subsequentDocumentCategory);
        this.subsequentDocumentCategory = subsequentDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @param processFlowLevel
     *            Level of the document flow record
     */
    public void setProcessFlowLevel( @Nullable final String processFlowLevel )
    {
        rememberChangedField("ProcessFlowLevel", this.processFlowLevel);
        this.processFlowLevel = processFlowLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallBillingStatus</b>
     * </p>
     *
     * @param overallBillingStatus
     *            SD Billing Status
     */
    public void setOverallBillingStatus( @Nullable final String overallBillingStatus )
    {
        rememberChangedField("OverallBillingStatus", this.overallBillingStatus);
        this.overallBillingStatus = overallBillingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RelatedProcFlowDocStsFieldName</b>
     * </p>
     *
     * @param relatedProcFlowDocStsFieldName
     *            Field Name
     */
    public void setRelatedProcFlowDocStsFieldName( @Nullable final String relatedProcFlowDocStsFieldName )
    {
        rememberChangedField("RelatedProcFlowDocStsFieldName", this.relatedProcFlowDocStsFieldName);
        this.relatedProcFlowDocStsFieldName = relatedProcFlowDocStsFieldName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DebitMemoReqSubsqntProcFlow";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DebitMemoRequest", getDebitMemoRequest());
        result.put("SubsequentDocument", getSubsequentDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DebitMemoRequest", getDebitMemoRequest());
        values.put("SubsequentDocument", getSubsequentDocument());
        values.put("SubsequentDocumentCategory", getSubsequentDocumentCategory());
        values.put("ProcessFlowLevel", getProcessFlowLevel());
        values.put("OverallBillingStatus", getOverallBillingStatus());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("RelatedProcFlowDocStsFieldName", getRelatedProcFlowDocStsFieldName());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DebitMemoRequest") ) {
                final Object value = values.remove("DebitMemoRequest");
                if( (value == null) || (!value.equals(getDebitMemoRequest())) ) {
                    setDebitMemoRequest(((String) value));
                }
            }
            if( values.containsKey("SubsequentDocument") ) {
                final Object value = values.remove("SubsequentDocument");
                if( (value == null) || (!value.equals(getSubsequentDocument())) ) {
                    setSubsequentDocument(((String) value));
                }
            }
            if( values.containsKey("SubsequentDocumentCategory") ) {
                final Object value = values.remove("SubsequentDocumentCategory");
                if( (value == null) || (!value.equals(getSubsequentDocumentCategory())) ) {
                    setSubsequentDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ProcessFlowLevel") ) {
                final Object value = values.remove("ProcessFlowLevel");
                if( (value == null) || (!value.equals(getProcessFlowLevel())) ) {
                    setProcessFlowLevel(((String) value));
                }
            }
            if( values.containsKey("OverallBillingStatus") ) {
                final Object value = values.remove("OverallBillingStatus");
                if( (value == null) || (!value.equals(getOverallBillingStatus())) ) {
                    setOverallBillingStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("RelatedProcFlowDocStsFieldName") ) {
                final Object value = values.remove("RelatedProcFlowDocStsFieldName");
                if( (value == null) || (!value.equals(getRelatedProcFlowDocStsFieldName())) ) {
                    setRelatedProcFlowDocStsFieldName(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_DebitMemoRequest") ) {
                final Object value = (values).remove("to_DebitMemoRequest");
                if( value instanceof Map ) {
                    if( toDebitMemoRequest == null ) {
                        toDebitMemoRequest = new DebitMemoRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDebitMemoRequest.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DebitMemoReqSubsqntProcFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new DebitMemoReqSubsqntProcFlowField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DebitMemoReqSubsqntProcFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DebitMemoReqSubsqntProcFlowField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDebitMemoRequest != null ) {
            (values).put("to_DebitMemoRequest", toDebitMemoRequest);
        }
        return values;
    }

    /**
     * Fetches the <b>DebitMemoRequest</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DebitMemoRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DebitMemoRequest</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequest fetchDebitMemoRequest()
    {
        return fetchFieldAsSingle("to_DebitMemoRequest", DebitMemoRequest.class);
    }

    /**
     * Retrieval of associated <b>DebitMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DebitMemoRequest</b>.
     * <p>
     * If the navigation property <b>to_DebitMemoRequest</b> of a queried <b>DebitMemoReqSubsqntProcFlow</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DebitMemoRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DebitMemoRequest getDebitMemoRequestOrFetch()
    {
        if( toDebitMemoRequest == null ) {
            toDebitMemoRequest = fetchDebitMemoRequest();
        }
        return toDebitMemoRequest;
    }

    /**
     * Retrieval of associated <b>DebitMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DebitMemoRequest</b>.
     * <p>
     * If the navigation property for an entity <b>DebitMemoReqSubsqntProcFlow</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DebitMemoRequest</b> is already loaded, the result will
     *         contain the <b>DebitMemoRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DebitMemoRequest> getDebitMemoRequestIfPresent()
    {
        return Option.of(toDebitMemoRequest);
    }

    /**
     * Overwrites the associated <b>DebitMemoRequest</b> entity for the loaded navigation property
     * <b>to_DebitMemoRequest</b>.
     *
     * @param value
     *            New <b>DebitMemoRequest</b> entity.
     */
    public void setDebitMemoRequest( final DebitMemoRequest value )
    {
        toDebitMemoRequest = value;
    }

    /**
     * Helper class to allow for fluent creation of DebitMemoReqSubsqntProcFlow instances.
     *
     */
    public final static class DebitMemoReqSubsqntProcFlowBuilder
    {

        private DebitMemoRequest toDebitMemoRequest;
        private String debitMemoRequest = null;

        private DebitMemoReqSubsqntProcFlow.DebitMemoReqSubsqntProcFlowBuilder toDebitMemoRequest(
            final DebitMemoRequest value )
        {
            toDebitMemoRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_DebitMemoRequest</b> for <b>DebitMemoReqSubsqntProcFlow</b> to single
         * <b>DebitMemoRequest</b>.
         *
         * @param value
         *            The DebitMemoRequest to build this DebitMemoReqSubsqntProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqSubsqntProcFlow.DebitMemoReqSubsqntProcFlowBuilder debitMemoRequest(
            final DebitMemoRequest value )
        {
            return toDebitMemoRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>DebitMemoRequest</b>
         * </p>
         *
         * @param value
         *            The debitMemoRequest to build this DebitMemoReqSubsqntProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DebitMemoReqSubsqntProcFlow.DebitMemoReqSubsqntProcFlowBuilder debitMemoRequest( final String value )
        {
            debitMemoRequest = value;
            return this;
        }

    }

}
