/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DebitMemoReqSubsqntProcFlowSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlow
 * DebitMemoReqSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class DebitMemoReqSubsqntProcFlowByKeyFluentHelper
    extends
    FluentHelperByKey<DebitMemoReqSubsqntProcFlowByKeyFluentHelper, DebitMemoReqSubsqntProcFlow, DebitMemoReqSubsqntProcFlowSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlow
     * DebitMemoReqSubsqntProcFlow} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DebitMemoReqSubsqntProcFlow}
     * @param servicePath
     *            Service path to be used to fetch a single {@code DebitMemoReqSubsqntProcFlow}
     * @param debitMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public DebitMemoReqSubsqntProcFlowByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String debitMemoRequest,
        final String subsequentDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("DebitMemoRequest", debitMemoRequest);
        this.key.put("SubsequentDocument", subsequentDocument);
    }

    @Override
    @Nonnull
    protected Class<DebitMemoReqSubsqntProcFlow> getEntityClass()
    {
        return DebitMemoReqSubsqntProcFlow.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
