/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService DebitMemoRequestService}.
 *
 */
public interface DebitMemoRequestServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<DebitMemoRequestServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<DebitMemoRequestServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *            DebitMemoReqItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        updateDebitMemoReqItemPartner( @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entity in the S/4HANA system.
     *
     * @param debitMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *            DebitMemoReqItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        deleteDebitMemoReqItemPartner( @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     * DebitMemoReqItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *            DebitMemoReqItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        updateDebitMemoReqItemPrcgElmnt( @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     * DebitMemoReqItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param debitMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *            DebitMemoReqItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        deleteDebitMemoReqItemPrcgElmnt( @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     * DebitMemoReqItemText} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *            DebitMemoReqItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        updateDebitMemoReqItemText( @Nonnull final DebitMemoReqItemText debitMemoReqItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     * DebitMemoReqItemText} entity in the S/4HANA system.
     *
     * @param debitMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *            DebitMemoReqItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        deleteDebitMemoReqItemText( @Nonnull final DebitMemoReqItemText debitMemoReqItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     * DebitMemoReqPartner} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *            DebitMemoReqPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        updateDebitMemoReqPartner( @Nonnull final DebitMemoReqPartner debitMemoReqPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     * DebitMemoReqPartner} entity in the S/4HANA system.
     *
     * @param debitMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *            DebitMemoReqPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        deleteDebitMemoReqPartner( @Nonnull final DebitMemoReqPartner debitMemoReqPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     * DebitMemoReqPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *            DebitMemoReqPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        updateDebitMemoReqPrcgElmnt( @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     * DebitMemoReqPrcgElmnt} entity in the S/4HANA system.
     *
     * @param debitMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *            DebitMemoReqPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        deleteDebitMemoReqPrcgElmnt( @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     * DebitMemoReqText} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *            DebitMemoReqText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqText( @Nonnull final DebitMemoReqText debitMemoReqText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     * DebitMemoReqText} entity in the S/4HANA system.
     *
     * @param debitMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *            DebitMemoReqText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqText( @Nonnull final DebitMemoReqText debitMemoReqText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *            DebitMemoRequest} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet createDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *            DebitMemoRequest} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet updateDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity in the S/4HANA system.
     *
     * @param debitMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *            DebitMemoRequest} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet deleteDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *            DebitMemoRequestItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        createDebitMemoRequestItem( @Nonnull final DebitMemoRequestItem debitMemoRequestItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *            DebitMemoRequestItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        updateDebitMemoRequestItem( @Nonnull final DebitMemoRequestItem debitMemoRequestItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity in the S/4HANA system.
     *
     * @param debitMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *            DebitMemoRequestItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DebitMemoRequestServiceBatchChangeSet
        deleteDebitMemoRequestItem( @Nonnull final DebitMemoRequestItem debitMemoRequestItem );

}
