/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DebitMemoRequestServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService DebitMemoRequestService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDebitMemoRequestServiceBatch
    extends
    BatchFluentHelperBasic<DebitMemoRequestServiceBatch, DebitMemoRequestServiceBatchChangeSet>
    implements
    DebitMemoRequestServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDebitMemoRequestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDebitMemoRequestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDebitMemoRequestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDebitMemoRequestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDebitMemoRequestServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDebitMemoRequestServiceBatchChangeSet(this, service);
    }

}
