/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem;

/**
 * Implementation of the {@link DebitMemoRequestServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService DebitMemoRequestService}.
 *
 */
public class DefaultDebitMemoRequestServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DebitMemoRequestServiceBatch, DebitMemoRequestServiceBatchChangeSet>
    implements
    DebitMemoRequestServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService service;

    @SuppressWarnings( "deprecation" )
    DefaultDebitMemoRequestServiceBatchChangeSet(
        @Nonnull final DefaultDebitMemoRequestServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DebitMemoRequestService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDebitMemoRequestServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqItemPartner(
        @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner )
    {
        return addRequestUpdate(service::updateDebitMemoReqItemPartner, debitMemoReqItemPartner);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqItemPartner(
        @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner )
    {
        return addRequestDelete(service::deleteDebitMemoReqItemPartner, debitMemoReqItemPartner);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqItemPrcgElmnt(
        @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt )
    {
        return addRequestUpdate(service::updateDebitMemoReqItemPrcgElmnt, debitMemoReqItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqItemPrcgElmnt(
        @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt )
    {
        return addRequestDelete(service::deleteDebitMemoReqItemPrcgElmnt, debitMemoReqItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqItemText(
        @Nonnull final DebitMemoReqItemText debitMemoReqItemText )
    {
        return addRequestUpdate(service::updateDebitMemoReqItemText, debitMemoReqItemText);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqItemText(
        @Nonnull final DebitMemoReqItemText debitMemoReqItemText )
    {
        return addRequestDelete(service::deleteDebitMemoReqItemText, debitMemoReqItemText);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqPartner(
        @Nonnull final DebitMemoReqPartner debitMemoReqPartner )
    {
        return addRequestUpdate(service::updateDebitMemoReqPartner, debitMemoReqPartner);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqPartner(
        @Nonnull final DebitMemoReqPartner debitMemoReqPartner )
    {
        return addRequestDelete(service::deleteDebitMemoReqPartner, debitMemoReqPartner);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqPrcgElmnt(
        @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt )
    {
        return addRequestUpdate(service::updateDebitMemoReqPrcgElmnt, debitMemoReqPrcgElmnt);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqPrcgElmnt(
        @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt )
    {
        return addRequestDelete(service::deleteDebitMemoReqPrcgElmnt, debitMemoReqPrcgElmnt);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoReqText(
        @Nonnull final DebitMemoReqText debitMemoReqText )
    {
        return addRequestUpdate(service::updateDebitMemoReqText, debitMemoReqText);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoReqText(
        @Nonnull final DebitMemoReqText debitMemoReqText )
    {
        return addRequestDelete(service::deleteDebitMemoReqText, debitMemoReqText);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet createDebitMemoRequest(
        @Nonnull final DebitMemoRequest debitMemoRequest )
    {
        return addRequestCreate(service::createDebitMemoRequest, debitMemoRequest);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoRequest(
        @Nonnull final DebitMemoRequest debitMemoRequest )
    {
        return addRequestUpdate(service::updateDebitMemoRequest, debitMemoRequest);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoRequest(
        @Nonnull final DebitMemoRequest debitMemoRequest )
    {
        return addRequestDelete(service::deleteDebitMemoRequest, debitMemoRequest);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet createDebitMemoRequestItem(
        @Nonnull final DebitMemoRequestItem debitMemoRequestItem )
    {
        return addRequestCreate(service::createDebitMemoRequestItem, debitMemoRequestItem);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet updateDebitMemoRequestItem(
        @Nonnull final DebitMemoRequestItem debitMemoRequestItem )
    {
        return addRequestUpdate(service::updateDebitMemoRequestItem, debitMemoRequestItem);
    }

    @Nonnull
    @Override
    public DebitMemoRequestServiceBatchChangeSet deleteDebitMemoRequestItem(
        @Nonnull final DebitMemoRequestItem debitMemoRequestItem )
    {
        return addRequestDelete(service::deleteDebitMemoRequestItem, debitMemoRequestItem);
    }

}
