/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.selectable.DbtMemoReqItmSubsqntProcFlowSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
 * DbtMemoReqItmSubsqntProcFlow} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class DbtMemoReqItmSubsqntProcFlowLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<DbtMemoReqItmSubsqntProcFlowLink<ObjectT>, DbtMemoReqItmSubsqntProcFlow, ObjectT>
    implements
    DbtMemoReqItmSubsqntProcFlowSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public DbtMemoReqItmSubsqntProcFlowLink( final String fieldName )
    {
        super(fieldName);
    }

    private DbtMemoReqItmSubsqntProcFlowLink(
        final EntityLink<DbtMemoReqItmSubsqntProcFlowLink<ObjectT>, DbtMemoReqItmSubsqntProcFlow, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected DbtMemoReqItmSubsqntProcFlowLink<ObjectT> translateLinkType(
        final EntityLink<DbtMemoReqItmSubsqntProcFlowLink<ObjectT>, DbtMemoReqItmSubsqntProcFlow, ObjectT> link )
    {
        return new DbtMemoReqItmSubsqntProcFlowLink<ObjectT>(link);
    }

}
